/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.graph;

import drasys.or.DoubleI;
import drasys.or.graph.AddI;
import drasys.or.graph.BaseGraph;
import drasys.or.graph.DuplicateEdgeException;
import drasys.or.graph.EdgeBase;
import drasys.or.graph.EdgeI;
import drasys.or.graph.GraphError;
import drasys.or.graph.GraphI;
import drasys.or.graph.VertexBase;
import drasys.or.graph.VertexI;
import drasys.or.graph.VertexNotFoundException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class DenseGraph
extends BaseGraph
implements AddI {
    int _vertexCapacity;
    Vector _vertexVector;

    public DenseGraph() {
        this._vertexVector = new Vector();
    }

    public DenseGraph(int n) {
        super(n);
        this._vertexCapacity = n;
        this._vertexVector = new Vector(n);
    }

    public EdgeI addEdge(EdgeI edgeI) throws DuplicateEdgeException, VertexNotFoundException {
        return this.addEdge(edgeI.getFromVertex().getKey(), edgeI.getToVertex().getKey(), edgeI.getValue(), edgeI.isDirected(), edgeI.getKey());
    }

    public EdgeI addEdge(Object object, Object object2) throws DuplicateEdgeException, VertexNotFoundException {
        return this.addEdge(object, object2, null, false, null);
    }

    public EdgeI addEdge(Object object, Object object2, Object object3) throws DuplicateEdgeException, VertexNotFoundException {
        return this.addEdge(object, object2, object3, false, null);
    }

    public EdgeI addEdge(Object object, Object object2, Object object3, boolean bl) throws DuplicateEdgeException, VertexNotFoundException {
        return this.addEdge(object, object2, object3, bl, null);
    }

    public final EdgeI addEdge(Object object, Object object2, Object object3, boolean bl, Object object4) throws DuplicateEdgeException, VertexNotFoundException {
        Vertex vertex = (Vertex)this.getVertex(object);
        if (vertex == null) {
            throw new VertexNotFoundException("Can't find the FROM vertex object");
        }
        Vertex vertex2 = (Vertex)this.getVertex(object2);
        if (vertex2 == null) {
            throw new VertexNotFoundException("Can't find the TO vertex object");
        }
        if (this.getEdge(vertex, vertex2, object4) != null) {
            throw new DuplicateEdgeException();
        }
        if (bl) {
            ++this._sizeOfDirectedEdges;
        }
        ++this._changeCount;
        return new Edge(this._sizeOfEdges++, vertex, vertex2, object4, object3, bl);
    }

    public void ensureEdgeCapacity(int n) {
    }

    public EdgeI getEdge(VertexI vertexI, VertexI vertexI2, Object object) {
        if (vertexI2.getGraph() != this) {
            throw new GraphError("The to vertx is not cointained in this graph");
        }
        if (vertexI.getGraph() != this) {
            throw new GraphError("The from vertx is not cointained in this graph");
        }
        Edge edge = ((Vertex)vertexI).getEdgeTo(((Vertex)vertexI2).getIndex());
        while (edge != null) {
            Object object2 = edge.getKey();
            if (object2 == object) {
                return edge;
            }
            if (object2 != null && object != null && object2.equals(object)) {
                return edge;
            }
            edge = edge.getNextEdge();
        }
        return null;
    }

    public EdgeI getMutableEdge(VertexI vertexI, VertexI vertexI2, Object object) {
        return this.getEdge(vertexI, vertexI2, object);
    }

    int getVertexCapacity() {
        return Math.max(this._vertexCapacity, this._vertexVector.size());
    }

    public boolean isSymmetric() {
        if (this._symmetric != null) {
            return this._symmetric;
        }
        return false;
    }

    protected VertexI newVertex(Object object, Object object2) {
        Vertex vertex = new Vertex(this._vertexVector.size(), object, object2);
        this._vertexVector.addElement(vertex);
        return vertex;
    }

    public String toString() {
        return super.toString("DenseGraph");
    }

    class Vertex
    extends VertexBase
    implements VertexI,
    Serializable {
        Vector _edgeVector = null;

        Vertex(int n, Object object, Object object2) {
            super(n, object, object2);
        }

        public void addOutEdge(Edge edge) {
            Vertex vertex = (Vertex)edge.getToVertex();
            int n = vertex._index;
            if (this._edgeVector == null) {
                this._edgeVector = new Vector(DenseGraph.this.getVertexCapacity());
            }
            if (this._edgeVector.size() <= n) {
                this._edgeVector.setSize(n + 1);
            }
            ++vertex._inDegree;
            ++this._outDegree;
            edge.setNextEdge((Edge)this._edgeVector.elementAt(n));
            this._edgeVector.setElementAt(edge, n);
        }

        public double doubleValue() {
            if (this._value == null) {
                return 0.0;
            }
            if (this._value instanceof DoubleI) {
                return ((DoubleI)this._value).doubleValue();
            }
            if (this._value instanceof Number) {
                return ((Number)this._value).doubleValue();
            }
            return 0.0;
        }

        public Edge getEdgeTo(int n) {
            if (this._edgeVector == null) {
                return null;
            }
            if (this._edgeVector.size() <= n) {
                return null;
            }
            return (Edge)this._edgeVector.elementAt(n);
        }

        public GraphI getGraph() {
            return DenseGraph.this;
        }

        public int getInDegree() {
            return this._inDegree;
        }

        public int getIndex() {
            return this._index;
        }

        public Object getKey() {
            return this._key;
        }

        public int getOutDegree() {
            return this._outDegree;
        }

        public Object getValue() {
            return this._value;
        }

        public Enumeration inEdges() {
            return new InEdgeEnumeration(this);
        }

        public boolean isEdge() {
            return false;
        }

        public boolean isVertex() {
            return true;
        }

        public Enumeration mutableInEdges() {
            return new InEdgeEnumeration(this);
        }

        public Enumeration mutableOutEdges() {
            return new OutEdgeEnumeration(this);
        }

        public Enumeration outEdges() {
            return new OutEdgeEnumeration(this);
        }

        public void setIndex(int n) {
            this._index = n;
        }

        public String toString() {
            return String.valueOf(String.valueOf(this._key)) + ", " + this._value;
        }

        private class InEdgeEnumeration
        implements Enumeration {
            int _toIndex;
            int _fromIndex;
            Edge _edge;
            Vector _vertexVector;

            InEdgeEnumeration(Vertex vertex2) {
                this._vertexVector = ((DenseGraph)vertex2.getGraph())._vertexVector;
                this._toIndex = vertex2.getIndex();
                this._fromIndex = 0;
                while (this._fromIndex < this._vertexVector.size()) {
                    Vertex vertex3 = (Vertex)this._vertexVector.elementAt(this._fromIndex);
                    this._edge = vertex3.getEdgeTo(this._toIndex);
                    if (this._edge != null) {
                        return;
                    }
                    ++this._fromIndex;
                }
            }

            public boolean hasMoreElements() {
                return this._edge != null;
            }

            public Object nextElement() {
                if (this._edge == null) {
                    return null;
                }
                Edge edge = this._edge;
                this._edge = this._edge.getNextEdge();
                if (this._edge != null) {
                    return edge;
                }
                ++this._fromIndex;
                while (this._fromIndex < this._vertexVector.size()) {
                    Vertex vertex = (Vertex)this._vertexVector.elementAt(this._fromIndex);
                    this._edge = vertex.getEdgeTo(this._toIndex);
                    if (this._edge != null) {
                        return edge;
                    }
                    ++this._fromIndex;
                }
                return edge;
            }
        }

        private class OutEdgeEnumeration
        implements Enumeration {
            int _toIndex;
            Edge _edge;
            Vector _edgeVector;

            OutEdgeEnumeration(Vertex vertex2) {
                this._edgeVector = vertex2._edgeVector;
                if (this._edgeVector == null) {
                    this._edge = null;
                    return;
                }
                this._toIndex = 0;
                while (this._toIndex < this._edgeVector.size()) {
                    this._edge = (Edge)this._edgeVector.elementAt(this._toIndex);
                    if (this._edge != null) {
                        return;
                    }
                    ++this._toIndex;
                }
            }

            public boolean hasMoreElements() {
                return this._edge != null;
            }

            public Object nextElement() {
                if (this._edge == null) {
                    return null;
                }
                Edge edge = this._edge;
                this._edge = this._edge.getNextEdge();
                if (this._edge != null) {
                    return edge;
                }
                ++this._toIndex;
                while (this._toIndex < this._edgeVector.size()) {
                    this._edge = (Edge)this._edgeVector.elementAt(this._toIndex);
                    if (this._edge != null) {
                        return edge;
                    }
                    ++this._toIndex;
                }
                return edge;
            }
        }
    }

    class Edge
    extends EdgeBase
    implements EdgeI,
    Serializable {
        Edge _nextEdge;
        Vertex _toVertex;
        Vertex _fromVertex;

        Edge(int n, Vertex vertex, Vertex vertex2, Object object, Object object2, boolean bl) {
            super(n, object, object2, bl);
            this._toVertex = vertex2;
            this._fromVertex = vertex;
            this._fromVertex.addOutEdge(this);
        }

        public VertexI getFromVertex() {
            return this._fromVertex;
        }

        public GraphI getGraph() {
            return DenseGraph.this;
        }

        public Edge getNextEdge() {
            return this._nextEdge;
        }

        public VertexI getToVertex() {
            return this._toVertex;
        }

        public void setNextEdge(Edge edge) {
            this._nextEdge = edge;
        }

        public String toString() {
            return String.valueOf(String.valueOf(this._fromVertex._key)) + (this._isDirected ? " -" : " <") + "-> " + this._toVertex._key + ", " + this._key + ", " + this._value;
        }
    }
}

