/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.graph;

import drasys.or.geom.CoordinateSystemI;
import drasys.or.geom.PointI;
import drasys.or.geom.rect3.Point;
import drasys.or.graph.AddVertexI;
import drasys.or.graph.BaseGraph;
import drasys.or.graph.DuplicateVertexException;
import drasys.or.graph.EdgeBase;
import drasys.or.graph.EdgeI;
import drasys.or.graph.EdgeValue;
import drasys.or.graph.GraphError;
import drasys.or.graph.GraphI;
import drasys.or.graph.RemoveVertexI;
import drasys.or.graph.VertexBase;
import drasys.or.graph.VertexI;
import drasys.or.graph.VertexNotFoundException;
import drasys.or.matrix.VectorI;
import java.io.Serializable;
import java.util.Enumeration;

public class PointGraph
extends BaseGraph
implements GraphI,
AddVertexI,
RemoveVertexI {
    boolean _useProxy;
    Edge _theEdge;
    CoordinateSystemI _coordinateSystem;
    double _cost = 1.0;
    double _speed = 1.0;

    public PointGraph() {
        this._coordinateSystem = null;
        this._useProxy = false;
        this._theEdge = new Edge(null, null, 0.0, 0.0, 0.0);
    }

    public PointGraph(int n) {
        super(n);
        this._coordinateSystem = null;
        this._useProxy = false;
        this._theEdge = new Edge(null, null, 0.0, 0.0, 0.0);
    }

    public PointGraph(VectorI vectorI, VectorI vectorI2) {
        super(vectorI.size());
        if (vectorI.size() != vectorI2.size()) {
            throw new GraphError("The arguments must be the same size.");
        }
        this._useProxy = false;
        this._theEdge = new Edge(null, null, 0.0, 0.0, 0.0);
        int n = vectorI.size();
        try {
            int n2 = 0;
            while (n2 < n) {
                this.addVertex(new Integer(n2), new drasys.or.geom.rect2.Point(vectorI.elementAt(n2), vectorI2.elementAt(n2)));
                ++n2;
            }
        }
        catch (DuplicateVertexException duplicateVertexException) {}
    }

    public PointGraph(VectorI vectorI, VectorI vectorI2, VectorI vectorI3) {
        super(vectorI.size());
        if (vectorI.size() != vectorI2.size()) {
            throw new GraphError("The arguments must be the same size.");
        }
        if (vectorI.size() != vectorI3.size()) {
            throw new GraphError("The arguments must be the same size.");
        }
        this._useProxy = false;
        this._theEdge = new Edge(null, null, 0.0, 0.0, 0.0);
        int n = vectorI.size();
        try {
            int n2 = 0;
            while (n2 < n) {
                this.addVertex(new Integer(n2), new Point(vectorI.elementAt(n2), vectorI2.elementAt(n2), vectorI3.elementAt(n2)));
                ++n2;
            }
        }
        catch (DuplicateVertexException duplicateVertexException) {}
    }

    private void _deleteVertex(VertexI vertexI) {
        int n = vertexI.getIndex();
        this._vertexHashtable.remove(vertexI.getKey());
        Enumeration enumeration = this.vertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            if (vertex.getIndex() <= n) continue;
            vertex.decIndex();
        }
        this._sizeOfDirectedEdges = this._sizeOfEdges = this.sizeOfVertices() * this.sizeOfVertices();
    }

    public VertexI addVertex(Object object, Object object2) throws DuplicateVertexException {
        if (object2 == null) {
            throw new GraphError("The value of a PointGraph vertex can not be null.");
        }
        if (!(object2 instanceof PointI)) {
            throw new GraphError("The value of a PointGraph vertex must implement the PointI interface.");
        }
        if (this._coordinateSystem == null) {
            this._coordinateSystem = ((PointI)object2).coordinateSystem();
        } else if (!this._coordinateSystem.equals(((PointI)object2).coordinateSystem())) {
            throw new GraphError("All the points must be from the same coordinate system.");
        }
        VertexI vertexI = super.addVertex(object, object2);
        this._sizeOfDirectedEdges = this._sizeOfEdges = this.sizeOfVertices() * this.sizeOfVertices();
        ++this._changeCount;
        return vertexI;
    }

    public CoordinateSystemI cordinateSystem() {
        return this._coordinateSystem;
    }

    public EdgeI getEdge(VertexI vertexI, VertexI vertexI2, Object object) {
        if (object != null) {
            return null;
        }
        if (vertexI2.getGraph() != this) {
            throw new GraphError("The to vertex is not contained in this graph");
        }
        if (vertexI.getGraph() != this) {
            throw new GraphError("The from vertex is not contained in this graph");
        }
        Vertex vertex = (Vertex)vertexI;
        Vertex vertex2 = (Vertex)vertexI2;
        double d = this._useProxy ? ((PointI)vertex._value).getDistanceProxyTo((PointI)vertex2._value) : ((PointI)vertex._value).getDistanceTo((PointI)vertex2._value);
        double d2 = d * this._cost;
        double d3 = d / this._speed;
        return new Edge(vertex, vertex2, d2, d3, d);
    }

    public EdgeI getMutableEdge(VertexI vertexI, VertexI vertexI2, Object object) {
        if (object != null) {
            return null;
        }
        if (vertexI2.getGraph() != this) {
            throw new GraphError("The to vertex is not contained in this graph");
        }
        if (vertexI.getGraph() != this) {
            throw new GraphError("The from vertex is not contained in this graph");
        }
        Vertex vertex = (Vertex)vertexI;
        Vertex vertex2 = (Vertex)vertexI2;
        double d = this._useProxy ? ((PointI)vertex._value).getDistanceProxyTo((PointI)vertex2._value) : ((PointI)vertex._value).getDistanceTo((PointI)vertex2._value);
        double d2 = d * this._cost;
        double d3 = d / this._speed;
        this._theEdge._fromVertex = vertex;
        this._theEdge._toVertex = vertex2;
        ((EdgeValue)this._theEdge._value).set(d2, d3, d);
        return this._theEdge;
    }

    public boolean isSymmetric() {
        if (this._symmetric != null) {
            return this._symmetric;
        }
        return this._coordinateSystem.isSymmetric();
    }

    public GraphI newGraph(int n, int n2) {
        if (n == 0) {
            return new PointGraph();
        }
        return new PointGraph(n);
    }

    protected VertexI newVertex(Object object, Object object2) {
        return new Vertex(this.sizeOfVertices(), object, (PointI)object2);
    }

    public VertexI removeVertex(VertexI vertexI, boolean bl) throws VertexNotFoundException {
        return this.removeVertex(vertexI.getKey(), bl);
    }

    public VertexI removeVertex(Object object, boolean bl) throws VertexNotFoundException {
        Vertex vertex = (Vertex)this._vertexHashtable.get(object);
        if (vertex == null) {
            throw new VertexNotFoundException();
        }
        this._deleteVertex(vertex);
        ++this._changeCount;
        return vertex;
    }

    public void setCost(double d) {
        this._cost = d;
    }

    public void setSpeed(double d) {
        this._speed = d;
    }

    public String toString() {
        return super.toString("PointGraph");
    }

    public void useDistanceProxy(boolean bl) {
        this._useProxy = bl;
    }

    class Vertex
    extends VertexBase
    implements VertexI,
    Serializable {
        Vertex(int n, Object object, PointI pointI) {
            super(n, object, pointI);
        }

        public void decIndex() {
            --this._index;
        }

        public GraphI getGraph() {
            return PointGraph.this;
        }

        public int getInDegree() {
            return PointGraph.this.sizeOfVertices();
        }

        public int getOutDegree() {
            return PointGraph.this.sizeOfVertices();
        }

        public Enumeration inEdges() {
            return new InEdgeEnumeration(this, false, PointGraph.this._useProxy);
        }

        public Enumeration mutableInEdges() {
            return new InEdgeEnumeration(this, true, PointGraph.this._useProxy);
        }

        public Enumeration mutableOutEdges() {
            return new OutEdgeEnumeration(this, true, PointGraph.this._useProxy);
        }

        Edge newEdge(Vertex vertex, Vertex vertex2, double d, double d2, double d3) {
            return new Edge(vertex, vertex2, d, d2, d3);
        }

        public Enumeration outEdges() {
            return new OutEdgeEnumeration(this, false, PointGraph.this._useProxy);
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        class InEdgeEnumeration
        implements Enumeration {
            Edge _theEdge;
            Vertex _toVertex;
            Enumeration enum;
            boolean _mutable;
            boolean _useProxy;

            InEdgeEnumeration(Vertex vertex2, boolean bl, boolean bl2) {
                this._useProxy = bl2;
                this._mutable = bl;
                this._toVertex = vertex2;
                this.enum = vertex2.getGraph().vertices();
                if (bl) {
                    this._theEdge = vertex2.newEdge(null, vertex2, 0.0, 0.0, 0.0);
                }
            }

            public boolean hasMoreElements() {
                return this.enum.hasMoreElements();
            }

            public Object nextElement() {
                Vertex vertex = (Vertex)this.enum.nextElement();
                if (vertex == null) {
                    return null;
                }
                double d = this._useProxy ? ((PointI)vertex._value).getDistanceProxyTo((PointI)this._toVertex._value) : ((PointI)vertex._value).getDistanceTo((PointI)this._toVertex._value);
                double d2 = d * ((Vertex)Vertex.this).PointGraph.this._cost;
                double d3 = d / ((Vertex)Vertex.this).PointGraph.this._speed;
                if (this._mutable) {
                    this._theEdge._fromVertex = vertex;
                    ((EdgeValue)this._theEdge._value).set(d2, d3, d);
                    return this._theEdge;
                }
                return this._toVertex.newEdge(vertex, this._toVertex, d2, d3, d);
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        class OutEdgeEnumeration
        implements Enumeration {
            Edge _theEdge;
            Vertex _fromVertex;
            Enumeration enum;
            boolean _mutable;
            boolean _useProxy;

            OutEdgeEnumeration(Vertex vertex2, boolean bl, boolean bl2) {
                this._useProxy = bl2;
                this._mutable = bl;
                this._fromVertex = vertex2;
                this.enum = vertex2.getGraph().vertices();
                if (bl) {
                    this._theEdge = vertex2.newEdge(vertex2, null, 0.0, 0.0, 0.0);
                }
            }

            public boolean hasMoreElements() {
                return this.enum.hasMoreElements();
            }

            public Object nextElement() {
                Vertex vertex = (Vertex)this.enum.nextElement();
                if (vertex == null) {
                    return null;
                }
                double d = this._useProxy ? ((PointI)this._fromVertex._value).getDistanceProxyTo((PointI)vertex._value) : ((PointI)this._fromVertex._value).getDistanceTo((PointI)vertex._value);
                double d2 = d * ((Vertex)Vertex.this).PointGraph.this._cost;
                double d3 = d / ((Vertex)Vertex.this).PointGraph.this._speed;
                if (this._mutable) {
                    this._theEdge._toVertex = vertex;
                    ((EdgeValue)this._theEdge._value).set(d2, d3, d);
                    return this._theEdge;
                }
                return this._fromVertex.newEdge(this._fromVertex, vertex, d2, d3, d);
            }
        }
    }

    class Edge
    extends EdgeBase
    implements EdgeI,
    Serializable {
        public Vertex _toVertex;
        public Vertex _fromVertex;

        Edge(Vertex vertex, Vertex vertex2, double d, double d2, double d3) {
            super(0, null, new EdgeValue(d, d2, d3), false);
            this._toVertex = vertex2;
            this._fromVertex = vertex;
        }

        public VertexI getFromVertex() {
            return this._fromVertex;
        }

        public GraphI getGraph() {
            return PointGraph.this;
        }

        public int getIndex() {
            return this._fromVertex._index * PointGraph.this.sizeOfVertices() + this._toVertex._index;
        }

        public VertexI getToVertex() {
            return this._toVertex;
        }
    }
}

