/*
 * Decompiled with CFR 0.152.
 */
package logging;

import generating.GeneratorsController;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import mapping.Mapper;
import mapping.data.JobClass;

public class Reporter {
    private static final String REPORTS_FOLDER = "Reports";
    private static DateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static void generateReportAboutJobClasses(Mapper mapper, GeneratorsController controller, String fileName) throws IOException {
        String[] jobClassesHeaders = new String[]{"Class ID", "Number of Jobs", "Arrival Rate", "Actual Arrival Rate", "Execution Time", "Actual Execution Time", "T/O", "Waiting Time", "Waiting Time-T/O", "Communication Time", "Communication Time-T/O", "Response Time (R.T.)", "R.T.-T/O", "R.T.(TU)", "R.T.-T/O (TU)"};
        if (fileName == null) {
            fileName = "Reports/jobClasses.txt";
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(new File(fileName));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        int i = 0;
        while (i < jobClassesHeaders.length - 1) {
            bufferedWriter.append(String.valueOf(jobClassesHeaders[i]) + "\t");
            ++i;
        }
        bufferedWriter.append(String.valueOf(jobClassesHeaders[i]) + "\n");
        i = 1;
        while (i <= mapper.getClassesTable().size()) {
            bufferedWriter.append(String.valueOf(((JobClass)mapper.getClassesTable().get(i)).getIndex()) + "\t");
            bufferedWriter.append(String.valueOf(controller.getGenerators()[i - 1].getJobsGeneratedNumber()) + "\t");
            bufferedWriter.append(String.valueOf(mapper.getJobClass(i).getArrivalRate()) + "\t");
            bufferedWriter.append(String.valueOf(controller.getGenerators()[i - 1].getActualRate()) + "\t");
            bufferedWriter.append(String.valueOf(mapper.getJobClass(i).getexecutionTime()) + "\t");
            bufferedWriter.append(String.valueOf(controller.getGenerators()[i - 1].getAcutualIterationAverage()) + "\t");
            bufferedWriter.append(String.valueOf(mapper.getJobsTable().getTimeOutedJobsCount(i)) + "\t");
            bufferedWriter.append(String.valueOf(mapper.getJobsTable().getSchedulingDelayInMilliSeconds(i) / 1000.0) + "\t");
            bufferedWriter.append(String.valueOf(mapper.getJobsTable().getSchedulingDelayInMilliSecondsIncludingTimedOut(i) / 1000.0) + "\t");
            bufferedWriter.append(String.valueOf(mapper.getJobsTable().getCommunicationDelayInSeconds(i)) + "\t");
            bufferedWriter.append(String.valueOf(mapper.getJobsTable().getCommunicationDelayInSecondsIncludingTimedOut(i)) + "\t");
            bufferedWriter.append(String.valueOf(mapper.getJobsTable().getResponseTimeInSeconds(i)) + "\t");
            bufferedWriter.append(String.valueOf(mapper.getJobsTable().getResponseTimeInSecondsIncludingTimedOut(i)) + "\t");
            bufferedWriter.append(String.valueOf(mapper.getJobsTable().getResponseTimeInSeconds(i) / (mapper.getTimeUnitInMinutes() * 60.0)) + "\t");
            bufferedWriter.append(String.valueOf(mapper.getJobsTable().getResponseTimeInSecondsIncludingTimedOut(i) / (mapper.getTimeUnitInMinutes() * 60.0)) + "\n");
            ++i;
        }
        bufferedWriter.append("All\t");
        bufferedWriter.append("-\t");
        bufferedWriter.append("-\t");
        bufferedWriter.append("-\t");
        bufferedWriter.append("-\t");
        bufferedWriter.append("-\t");
        bufferedWriter.append("-\t");
        bufferedWriter.append(String.valueOf(mapper.getJobsTable().getSchedulingDelayInMilliSeconds()) + "\t");
        bufferedWriter.append(String.valueOf(mapper.getJobsTable().getSchedulingDelayInMilliSecondsIncludingTimedOut()) + "\t");
        bufferedWriter.append(String.valueOf(mapper.getJobsTable().getCommunicationDelayInSeconds()) + "\t");
        bufferedWriter.append(String.valueOf(mapper.getJobsTable().getCommunicationDelayInSecondsIncludingTimedOut()) + "\t");
        bufferedWriter.append(String.valueOf(mapper.getJobsTable().getResponseTimeInSeconds()) + "\t");
        bufferedWriter.append(String.valueOf(mapper.getJobsTable().getResponseTimeInSecondsIncludingTimedOut()) + "\t");
        bufferedWriter.append(String.valueOf(mapper.getJobsTable().getResponseTimeInSecondsIncludingTimedOut() / (mapper.getTimeUnitInMinutes() * 60.0)) + "\t");
        bufferedWriter.append(String.valueOf(mapper.getJobsTable().getResponseTimeInSecondsIncludingTimedOut() / (mapper.getTimeUnitInMinutes() * 60.0)) + "\n");
        if (bufferedWriter != null) {
            bufferedWriter.close();
        }
        if (fileWriter != null) {
            fileWriter.close();
        }
    }

    public static void generateReportAboutSystemStatistics(Mapper mapper, String fileName) {
        block25: {
            if (fileName == null) {
                fileName = "Reports/statistics.txt";
            }
            FileWriter fileWriter = null;
            try {
                fileWriter = new FileWriter(new File(fileName));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            try {
                try {
                    bufferedWriter.append("Scheduling Scheme:\t");
                    bufferedWriter.append(String.valueOf(mapper.getMappingScheme().getDescription()) + "\n");
                    bufferedWriter.append("Start Time:\t");
                    bufferedWriter.append(String.valueOf(dateFormatter.format(mapper.getStartTime().getTime())) + "\n");
                    bufferedWriter.append("Stop Time:\t");
                    if (mapper.getStopTime() == null) {
                        bufferedWriter.append("Still Running\n");
                    } else {
                        bufferedWriter.append(String.valueOf(dateFormatter.format(mapper.getStopTime().getTime())) + "\n");
                    }
                    bufferedWriter.append("Duration:\t");
                    bufferedWriter.append(String.valueOf(mapper.getTimeElapsedInTimeUnits()) + " Time Units\n");
                    bufferedWriter.append("Minutes Per Time Units:\t");
                    bufferedWriter.append(String.valueOf(mapper.getTimeUnitInMinutes()) + "\tminute(s)\n");
                    bufferedWriter.append("Waiting Time\t");
                    bufferedWriter.append(String.valueOf(mapper.getJobsTable().getSchedulingDelayInMilliSeconds()) + "\tmilliseconds\n");
                    bufferedWriter.append("Waiting Time with timed out jobs\t");
                    bufferedWriter.append(String.valueOf(mapper.getJobsTable().getSchedulingDelayInMilliSecondsIncludingTimedOut()) + "\tmilliseconds\n");
                    bufferedWriter.append("Communication Delay\t");
                    bufferedWriter.append(String.valueOf(mapper.getJobsTable().getCommunicationDelayInSeconds()) + "\tseconds\n");
                    bufferedWriter.append("Communication Delay With timed out jobs\t");
                    bufferedWriter.append(String.valueOf(mapper.getJobsTable().getCommunicationDelayInSecondsIncludingTimedOut()) + "\tseconds\n");
                    bufferedWriter.append("Resonse Time:\t");
                    bufferedWriter.append(String.valueOf(mapper.getJobsTable().getResponseTimeInSeconds()) + "\tseconds\n");
                    bufferedWriter.append("Resonse Time with timed out jobs:\t");
                    bufferedWriter.append(String.valueOf(mapper.getJobsTable().getResponseTimeInSecondsIncludingTimedOut()) + "\tseconds\n");
                    bufferedWriter.append("Mean Failure Periods\t");
                    bufferedWriter.append(String.valueOf(mapper.getServersTable().getFailurePeriodsMeanOfAllServersInMinutes()) + "\tminutes\n");
                    bufferedWriter.append("Mean Up-time\t");
                    bufferedWriter.append(String.valueOf(mapper.getServersTable().getUpTimeMeanOfAllServersInMinutes()) + "\tminutes\n");
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    if (bufferedWriter != null) {
                        try {
                            bufferedWriter.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (fileWriter == null) break block25;
                    try {
                        fileWriter.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (bufferedWriter != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (fileWriter != null) {
                    try {
                        fileWriter.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static void generateReportOfMue(Mapper mapper, String fileName) throws IOException {
        if (fileName == null) {
            fileName = "Reports/Mue.txt";
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(new File(fileName));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        double[][] mue = mapper.constructMueMatrix();
        double[][] actualMue = mapper.constructActualMueMatrix();
        try {
            try {
                int j;
                bufferedWriter.append("Ideal Matrix\n");
                int i = 0;
                while (i < mue.length) {
                    j = 0;
                    while (j < mue[i].length) {
                        bufferedWriter.append(String.valueOf(mue[i][j]) + "\t");
                        ++j;
                    }
                    bufferedWriter.append("\n");
                    ++i;
                }
                bufferedWriter.append("\n\n\nActual Matrix\n");
                i = 0;
                while (i < actualMue.length) {
                    j = 0;
                    while (j < actualMue[i].length) {
                        bufferedWriter.append(String.valueOf(actualMue[i][j]) + "\t");
                        ++j;
                    }
                    bufferedWriter.append("\n");
                    ++i;
                }
            }
            catch (IOException ex) {
                throw new IOException();
            }
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

