/*
 * Decompiled with CFR 0.152.
 */
package mapping;

import adjusting.Adjuster;
import java.io.Serializable;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import mapping.Mapper;
import mapping.data.Server;

public class EndOfFailureAnnouncer
implements Runnable,
Serializable {
    private static final long serialVersionUID = 9190446048851505684L;
    private LinkedList<TimeNodeForServers> list = new LinkedList();
    private long currentSleepTime;
    private boolean alive = true;
    private Mapper mapper;
    private final long DEFAULT_SLEEP_TIME = 5000L;
    private Thread thisThread;

    public EndOfFailureAnnouncer(Mapper mapper) {
        this.setMapper(mapper);
    }

    public synchronized long getCurrentSleepTime() {
        return this.currentSleepTime;
    }

    public synchronized void setCurrentSleepTime(long currentSleepTime) {
        this.currentSleepTime = currentSleepTime;
    }

    public synchronized boolean isAlive() {
        return this.alive;
    }

    public synchronized void setAlive(boolean alive) {
        this.alive = alive;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    public synchronized void add(double AfterInMinutes, Server server) {
        this.add(new TimeNodeForServers(AfterInMinutes, server));
    }

    private void add(TimeNodeForServers node) {
        if (this.list.isEmpty()) {
            this.list.add(node);
            if (this.thisThread != null) {
                this.thisThread.interrupt();
            }
            return;
        }
        int i = 0;
        while (i < this.list.size()) {
            if (node.time.before(this.list.get((int)i).time)) {
                this.list.add(i, node);
                if (i == 0 && this.thisThread != null) {
                    this.thisThread.interrupt();
                }
                return;
            }
            ++i;
        }
        this.list.add(node);
    }

    public void startThread() {
        this.thisThread = new Thread(this);
        this.thisThread.start();
    }

    public void stopThread() {
        this.setAlive(false);
        this.thisThread.interrupt();
        this.thisThread = null;
    }

    public void print() {
        System.out.println("Size: " + this.list.size());
        System.out.println("now: " + new GregorianCalendar().getTime().toString() + "\n");
        int i = 0;
        while (i < this.list.size()) {
            System.out.println(this.list.get(i).toString());
            ++i;
        }
    }

    public void run() {
        this.upDateCurrentSleepTime();
        System.out.println("EndOfFailureAnnouncer.run: Started");
        while (this.isAlive()) {
            boolean up;
            try {
                Thread.sleep(this.getCurrentSleepTime());
            }
            catch (InterruptedException e) {
                System.err.println("EndOfFailureAnnouncer.run: Interupted");
                if (!this.isAlive()) {
                    return;
                }
                this.upDateCurrentSleepTime();
                continue;
            }
            if (this.list.isEmpty()) continue;
            GregorianCalendar currentTime = new GregorianCalendar();
            Server server = this.list.get((int)0).server;
            boolean bl = up = !Adjuster.isServerSufferingFromAFailure(currentTime, server);
            if (up) {
                System.err.println("EndOfFailureAnnouncer: Server: " + server.getHostName() + " is declared UP");
                this.getMapper().getServersTable().setServerDown(server.getIndex(), false);
                this.getMapper().getServersTable().clearServerActiveJobsNumber(server.getIndex());
                this.getMapper().getMappingScheme().serverIsUp(server.getIndex());
                if (!this.list.isEmpty()) {
                    this.list.remove(0);
                }
                this.getMapper().getAvailableServersQueue().enqueue(server.getIndex());
                this.upDateCurrentSleepTime();
                continue;
            }
            System.err.println("EndOfFailureAnnouncer. System is stilldown");
            this.upDateCurrentSleepTime();
        }
    }

    private void upDateCurrentSleepTime() {
        if (this.list.isEmpty()) {
            this.setCurrentSleepTime(5000L);
        } else {
            long sleepTime = this.list.get((int)0).time.getTimeInMillis() - new GregorianCalendar().getTimeInMillis();
            if (sleepTime < 0L) {
                sleepTime = 1000L;
            }
            this.setCurrentSleepTime(sleepTime);
        }
        GregorianCalendar timeToWakeUp = new GregorianCalendar();
        timeToWakeUp.add(14, (int)this.getCurrentSleepTime());
    }

    public static class TimeNodeForServers {
        GregorianCalendar time;
        Server server;

        public TimeNodeForServers(GregorianCalendar cal, Server server) {
            this.time = cal;
            this.server = server;
        }

        public TimeNodeForServers(double AfterInMinutes, Server server) {
            this.time = new GregorianCalendar();
            this.time.add(13, (int)((AfterInMinutes - Math.floor(AfterInMinutes)) * 60.0));
            this.time.add(12, (int)Math.floor(AfterInMinutes));
            this.server = server;
        }

        public String toString() {
            return "Server: " + this.server.getHostName() + " at " + this.time.getTime().toString();
        }
    }
}

