/*
 * Decompiled with CFR 0.152.
 */
package pulling.availability_predection;

import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.GregorianCalendar;
import pulling.availability_predection.AvailabilityLogger;
import pulling.availability_predection.CPU_Usage;
import pulling.availability_predection.TimeStamp;
import pulling.availability_predection.WeekDay;

public class AvailabilityManager
implements Runnable {
    private final double UNKNOWN = -1.0;
    private final int MINIMUM_TIME_RESOLUTION = 1;
    private final int MINIMUM_TIME_BETWEEN_READINGS = 1;
    private double[] readings;
    private boolean distributedReadingsMode = true;
    private int timeresolution = 10;
    private int readingFrequency = 5;
    private double availability = 1.0;
    private AvailabilityLogger logger;
    private boolean alive = true;
    private Thread thisThread;
    private String mapperHostName;
    private int availablityPort = 37933;
    private int mode = WEIGHTED_MEAN;
    public static int WEIGHTED_MEAN = 0;
    private double[] weights = new double[]{0.4, 0.3, 0.2, 0.1};
    public static int RECURSIVE = 1;
    private double c = 0.5;
    private double previousEstimation = 0.5;
    private boolean midnightHasJustPassed = false;

    public AvailabilityManager() {
        this.setLogger(new AvailabilityLogger(this.getTimeresolution(), this.getPastReadingsCount()));
        this.setMapperHostName(this.getLocalAddress());
        this.setAlive(true);
        this.initReadings();
    }

    public AvailabilityManager(int timeresolution, String mapperHostName, double availability) {
        this.setTimeresolution(timeresolution);
        this.setLogger(new AvailabilityLogger(this.getTimeresolution(), this.getPastReadingsCount()));
        this.setAvailability(availability);
        this.setMapperHostName(mapperHostName);
        this.setAlive(true);
        this.initReadings();
    }

    public AvailabilityManager(int timeresolution, String mapperHostName, int mode, double availability) {
        this.setTimeresolution(timeresolution);
        if (mode == RECURSIVE) {
            this.setMode(RECURSIVE);
            this.setLogger(new AvailabilityLogger(this.getTimeresolution(), 1));
        } else {
            this.setMode(WEIGHTED_MEAN);
            this.setLogger(new AvailabilityLogger(this.getTimeresolution(), this.getPastReadingsCount()));
        }
        this.setAvailability(availability);
        this.setMapperHostName(mapperHostName);
        this.setAlive(true);
        this.initReadings();
    }

    public AvailabilityManager(int timeresolution, String mapperHostName, double c, double availability) {
        this.setTimeresolution(timeresolution);
        this.setMode(RECURSIVE);
        this.setLogger(new AvailabilityLogger(this.getTimeresolution(), 1));
        this.setAvailability(availability);
        this.setMapperHostName(mapperHostName);
        this.setAlive(true);
        this.initReadings();
    }

    public AvailabilityManager(int timeresolution, String mapperHostName, double[] weights, double availability) {
        this.setTimeresolution(timeresolution);
        this.setMode(WEIGHTED_MEAN);
        if (weights != null) {
            this.setWeights(weights);
        }
        this.setLogger(new AvailabilityLogger(this.getTimeresolution(), 1));
        this.setAvailability(availability);
        this.setMapperHostName(mapperHostName);
        this.setAlive(true);
        this.initReadings();
    }

    public void startThread() {
        this.thisThread = new Thread(this);
        this.thisThread.start();
    }

    public void stopThread() {
        boolean wasAlive = this.isAlive();
        this.setAlive(false);
        if (wasAlive) {
            this.thisThread.interrupt();
            this.thisThread = null;
        }
    }

    public AvailabilityLogger getLogger() {
        return this.logger;
    }

    public void setLogger(AvailabilityLogger logger) {
        this.logger = logger;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void setAlive(boolean alive) {
        this.alive = alive;
    }

    public boolean isDistributedReadingsMode() {
        return this.distributedReadingsMode;
    }

    public void setDistributedReadingsMode(boolean distributedReadingsMode) {
        this.distributedReadingsMode = distributedReadingsMode;
        if (!this.distributedReadingsMode) {
            this.setReadingFrequency(1);
        }
    }

    public int getTimeresolution() {
        return this.timeresolution;
    }

    public void setAvailability(double avail) {
        this.availability = avail;
    }

    public double getAvailability() {
        return this.availability;
    }

    public void setTimeresolution(int timeresolution) {
        if (timeresolution >= 1) {
            this.timeresolution = timeresolution;
            if (this.getLogger() != null) {
                this.getLogger().setTimeresolution(timeresolution);
            }
        } else {
            System.out.println("Could not set time resolution; Time resolution is: " + this.getTimeresolution());
        }
    }

    public int getReadingFrequency() {
        return this.readingFrequency;
    }

    public void setReadingFrequency(int readingFrequency) {
        if (this.getTimeresolution() / this.readingFrequency >= 1) {
            this.readingFrequency = readingFrequency;
        } else {
            System.out.println("Could not set readings frequency; Reading Frequency is: " + this.getReadingFrequency());
        }
    }

    public String getMapperHostName() {
        return this.mapperHostName;
    }

    public void setMapperHostName(String mapperHostName) {
        this.mapperHostName = mapperHostName;
    }

    public int getAvailablityPort() {
        return this.availablityPort;
    }

    public void setAvailablityPort(int availablityPort) {
        this.availablityPort = availablityPort;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode == WEIGHTED_MEAN || mode == RECURSIVE ? mode : WEIGHTED_MEAN;
    }

    public int getPastReadingsCount() {
        return this.weights.length;
    }

    public double[] getWeights() {
        return this.weights;
    }

    public void setWeights(double[] weights) {
        this.weights = weights;
    }

    public double getC() {
        return this.c;
    }

    public void setC(double c) {
        this.c = c;
    }

    public double getPreviousEstimation() {
        return this.previousEstimation;
    }

    public void setPreviousEstimation(double previousEstimation) {
        this.previousEstimation = previousEstimation;
    }

    public void initReadings() {
        this.readings = new double[this.getReadingFrequency()];
        int i = 0;
        while (i < this.readings.length) {
            this.readings[i] = -1.0;
            ++i;
        }
    }

    public double getAverage() {
        double sum = 0.0;
        int count = 0;
        int i = 0;
        while (i < this.readings.length) {
            if (this.readings[i] != -1.0) {
                sum += this.readings[i];
                ++count;
            }
            ++i;
        }
        return sum / (double)count;
    }

    public double getEstimatedAvailability(GregorianCalendar calendar) {
        if (this.getMode() == WEIGHTED_MEAN) {
            double sum = 0.0;
            double weightSum = 0.0;
            int j = 1;
            while (j <= this.getPastReadingsCount()) {
                sum += this.getLogger().getReading(j, WeekDay.getWeekDay(calendar), TimeStamp.getTimeStamp(calendar)) * this.getWeights()[j - 1];
                weightSum += this.getWeights()[j - 1];
                ++j;
            }
            return sum / weightSum;
        }
        if (this.getMode() == RECURSIVE) {
            double estimation = this.getC() * this.getPreviousEstimation() + (1.0 - this.getC()) * this.getLogger().getReading(1, WeekDay.getWeekDay(calendar), TimeStamp.getTimeStamp(calendar));
            this.setPreviousEstimation(estimation);
            return estimation;
        }
        return -1.0;
    }

    public void run() {
        this.getLogger().initHistoryFile();
        boolean firstTime = true;
        while (this.isAlive()) {
            this.initReadings();
            int i = 0;
            if (firstTime) {
                i = (int)((double)this.getSleepTimeTillNextSystemTick() / ((double)this.getTimeresolution() / (double)this.getReadingFrequency() * 60.0 * 1000.0));
                i = this.getReadingFrequency() - i - 1;
                firstTime = false;
            } else {
                i = 0;
            }
            while (i < this.getReadingFrequency()) {
                block11: {
                    try {
                        long timeTillNextReading = this.getSleepTimeTillNextReading();
                        Thread.sleep(timeTillNextReading);
                        this.readings[i] = (double)CPU_Usage.getSystemIdlePercentage() * this.getAvailability();
                        if (this.midnightHasJustPassed) {
                            i = this.getReadingFrequency();
                        }
                    }
                    catch (InterruptedException e) {
                        if (this.isAlive()) break block11;
                        return;
                    }
                }
                ++i;
            }
            GregorianCalendar now = new GregorianCalendar();
            if (this.midnightHasJustPassed) {
                now.set(11, 0);
                now.set(12, 0);
                now.set(13, 0);
                now.set(14, 0);
                now.add(12, -1);
            } else {
                now.add(12, -1 * this.getTimeresolution());
            }
            try {
                TimeStamp ts = new TimeStamp(now.get(11), now.get(12));
                this.logger.insertNewReading(this.getAverage(), WeekDay.getWeekDay(now), ts);
                this.notifyMapperWithThenNewAvailability(this.getAverage());
                System.out.println("A reading has been logged and sent: " + this.getAverage() + " for " + ts.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void print(GregorianCalendar cal) {
        System.out.println(cal.getTime().toString());
    }

    private long getSleepTimeTillNextSystemTick() {
        double tickLengthInMinutes = this.getTimeresolution();
        GregorianCalendar beginningOfDay = new GregorianCalendar();
        beginningOfDay.set(11, 0);
        beginningOfDay.set(12, 0);
        beginningOfDay.set(13, 0);
        beginningOfDay.set(14, 0);
        GregorianCalendar now = new GregorianCalendar();
        long diff = now.getTimeInMillis() - beginningOfDay.getTimeInMillis();
        double ticksInDiff = (double)diff / (tickLengthInMinutes * 60.0 * 1000.0);
        double sleepTime = (Math.ceil(ticksInDiff) - ticksInDiff) * tickLengthInMinutes * 60.0 * 1000.0;
        return this.min(Math.round(sleepTime), this.getTimeTillMidnight(now));
    }

    private long getSleepTimeTillNextReading() {
        GregorianCalendar beginningOfDay = new GregorianCalendar();
        beginningOfDay.set(11, 0);
        beginningOfDay.set(12, 0);
        beginningOfDay.set(13, 0);
        beginningOfDay.set(14, 0);
        GregorianCalendar now = new GregorianCalendar();
        long diff = now.getTimeInMillis() - beginningOfDay.getTimeInMillis();
        double readingPeriod = (double)this.getTimeresolution() / (double)this.getReadingFrequency();
        double readingsPerioudsInDiff = (double)diff / (readingPeriod * 60.0 * 1000.0);
        double sleepTime = (Math.ceil(readingsPerioudsInDiff) - readingsPerioudsInDiff) * readingPeriod * 60.0 * 1000.0;
        if (this.getTimeTillMidnight(now) <= Math.round(sleepTime)) {
            this.midnightHasJustPassed = true;
            System.out.println("Midnight");
            return this.getTimeTillMidnight(now);
        }
        this.midnightHasJustPassed = false;
        return Math.round(sleepTime);
    }

    private long getTimeTillMidnight(GregorianCalendar cal) {
        GregorianCalendar nextMidnight = (GregorianCalendar)cal.clone();
        nextMidnight.set(11, 0);
        nextMidnight.set(12, 0);
        nextMidnight.set(13, 0);
        nextMidnight.set(14, 0);
        nextMidnight.set(5, cal.get(5) + 1);
        return nextMidnight.getTimeInMillis() - cal.getTimeInMillis();
    }

    private long min(long a, long b) {
        if (a <= b) {
            return a;
        }
        return b;
    }

    public void printAllTimeIntervals() {
        GregorianCalendar beginningOfDay = new GregorianCalendar();
        beginningOfDay.set(11, 0);
        beginningOfDay.set(12, 0);
        beginningOfDay.set(13, 0);
        beginningOfDay.set(14, 0);
        GregorianCalendar nextMidnight = (GregorianCalendar)beginningOfDay.clone();
        nextMidnight.set(11, 0);
        nextMidnight.set(12, 0);
        nextMidnight.set(13, 0);
        nextMidnight.set(14, 0);
        nextMidnight.set(5, beginningOfDay.get(5) + 1);
        while (beginningOfDay.before(nextMidnight)) {
            beginningOfDay.add(14, this.getTimeresolution() * 60 * 1000);
            AvailabilityManager.print(beginningOfDay);
        }
    }

    public void notifyMapperWithThenNewAvailability(double availability) throws UnknownHostException {
        Socket socket = null;
        FilterOutputStream out = null;
        try {
            try {
                socket = new Socket(this.getMapperHostName(), this.getAvailablityPort());
                out = new DataOutputStream(socket.getOutputStream());
                ((DataOutputStream)out).writeBytes(String.valueOf(this.getLocalAddress()) + "#" + availability);
            }
            catch (UnknownHostException e) {
                System.err.println("Don't know about mapper: " + this.getMapperHostName());
                e.printStackTrace();
                try {
                    if (socket != null) {
                        socket.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            catch (IOException e) {
                System.err.println("Couldn't get I/O for the connection to Mapper: " + this.getMapperHostName());
                System.out.println(this.getAvailablityPort());
                e.printStackTrace();
                try {
                    if (socket != null) {
                        socket.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String getLocalAddress() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return String.valueOf(this.getMapperHostName()) + " Resolution: " + this.getTimeresolution() + " Frequency: " + this.getReadingFrequency();
    }

    public void print() {
        System.out.print(this.toString());
    }
}

