/*
 * Decompiled with CFR 0.152.
 */
package adjusting.availability_adjusting;

import adjusting.availability_adjusting.FailurePeriod;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import probability_distribution.ExponentialDist;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FailureTrace
implements Serializable {
    private static final long serialVersionUID = -1180542768153477460L;
    private ArrayList<FailurePeriod> failingPeriods;

    public FailureTrace() {
        this.setFailurePeriods(new ArrayList<FailurePeriod>());
    }

    public ArrayList<FailurePeriod> getFailurePeriods() {
        return this.failingPeriods;
    }

    public void setFailurePeriods(ArrayList<FailurePeriod> failingPeriods) {
        this.failingPeriods = failingPeriods;
    }

    public int getNumbersOfPeriods() {
        return this.failingPeriods.size();
    }

    public double getMeanOfPeriodsInMinutes() {
        if (this.getNumbersOfPeriods() == 0) {
            return 0.0;
        }
        double sum = 0.0;
        int i = 0;
        while (i < this.getNumbersOfPeriods()) {
            sum += this.getFailurePeriods().get(i).getLengthInMinutes();
            ++i;
        }
        return sum / (double)this.getNumbersOfPeriods();
    }

    public double getMeanIfInterPeriodsInMinutes() {
        if (this.getNumbersOfPeriods() == 0) {
            return 0.0;
        }
        double sum = 0.0;
        int i = 0;
        while (i < this.getNumbersOfPeriods() - 1) {
            sum += (double)(this.getFailurePeriods().get(i + 1).getBeginningTime().getTimeInMillis() - this.getFailurePeriods().get(i).getEndTime().getTimeInMillis()) / 60000.0;
            ++i;
        }
        return sum / (double)(this.getNumbersOfPeriods() - 1);
    }

    public boolean add(FailurePeriod period) {
        if (this.getFailurePeriods().isEmpty()) {
            this.getFailurePeriods().add(period);
            return true;
        }
        int i = 0;
        while (i < this.getNumbersOfPeriods()) {
            if (period.getEndTime().before(this.getFailurePeriods().get(i).getEndTime())) {
                if (period.isOverLapped(this.getFailurePeriods().get(i))) {
                    return false;
                }
                this.getFailurePeriods().add(i, period);
                return true;
            }
            ++i;
        }
        this.getFailurePeriods().add(period);
        return true;
    }

    public void print() {
        int i = 0;
        while (i < this.getNumbersOfPeriods()) {
            this.getFailurePeriods().get(i).print();
            ++i;
        }
    }

    public boolean IsTimeInFailure(GregorianCalendar time) {
        int i = 0;
        while (i < this.getNumbersOfPeriods()) {
            if (this.getFailurePeriods().get(i).isTimeInPeriod(time)) {
                return true;
            }
            if (time.before(this.getFailurePeriods().get(i).getEndTime())) {
                return false;
            }
            ++i;
        }
        return false;
    }

    public GregorianCalendar getEndOfFailure(GregorianCalendar time) {
        int i = 0;
        while (i < this.getNumbersOfPeriods()) {
            if (this.getFailurePeriods().get(i).isTimeInPeriod(time)) {
                return this.getFailurePeriods().get(i).getEndTime();
            }
            if (time.before(this.getFailurePeriods().get(i).getEndTime())) {
                return null;
            }
            ++i;
        }
        return null;
    }

    public boolean doesPeriodOverlapAFailurePeriod(FailurePeriod period) {
        int i = 0;
        while (i < this.getNumbersOfPeriods()) {
            if (this.getFailurePeriods().get(i).isOverLapped(period)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean doesRangeOverlapAFailurePeriod(GregorianCalendar startTime, GregorianCalendar endTime) {
        FailurePeriod range = new FailurePeriod(startTime, endTime);
        return this.doesPeriodOverlapAFailurePeriod(range);
    }

    public void fillTrace(GregorianCalendar startTime, GregorianCalendar endTime, double periodLengthMean, double interPeriodLengthMean, double minutesInTimeUnit) {
        this.setFailurePeriods(new ArrayList<FailurePeriod>());
        GregorianCalendar temp = startTime;
        ExponentialDist periodLengthDist = new ExponentialDist(1.0 / (periodLengthMean * minutesInTimeUnit));
        ExponentialDist interPeriodLengthDist = new ExponentialDist(1.0 / (interPeriodLengthMean * minutesInTimeUnit));
        int count = 0;
        double sumInterPeriodLength = 0.0;
        double sumPeriodLength = 0.0;
        while (temp.before(endTime)) {
            double interPeriodLength = interPeriodLengthDist.getTimeToNextEvent();
            double periodLength = periodLengthDist.getTimeToNextEvent();
            sumInterPeriodLength += interPeriodLength;
            sumPeriodLength += periodLength;
            ++count;
            temp.add(13, (int)Math.round((interPeriodLength - Math.floor(interPeriodLength)) * 60.0));
            temp.add(12, (int)interPeriodLength);
            GregorianCalendar startOfPeriod = (GregorianCalendar)temp.clone();
            GregorianCalendar endOfPeriod = (GregorianCalendar)temp.clone();
            endOfPeriod.add(13, (int)Math.round((periodLength - Math.floor(periodLength)) * 60.0));
            endOfPeriod.add(12, (int)periodLength);
            temp = (GregorianCalendar)endOfPeriod.clone();
            this.add(new FailurePeriod(startOfPeriod, endOfPeriod));
        }
    }
}

