/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.graph.tsp;

import drasys.or.graph.GraphI;
import drasys.or.graph.PropertiesI;
import drasys.or.graph.VertexI;
import drasys.or.graph.VertexNotFoundException;
import drasys.or.graph.tsp.ConstructI;
import drasys.or.graph.tsp.ImproveI;
import drasys.or.graph.tsp.TourNotFoundException;
import java.util.Enumeration;
import java.util.Vector;

public class ConstructToImproveConverter
implements ImproveI {
    GraphI _graph;
    ConstructI _construct;

    public ConstructToImproveConverter(ConstructI constructI) {
        this._construct = constructI;
    }

    public ConstructToImproveConverter(ConstructI constructI, GraphI graphI) {
        this._construct = constructI;
        this.setGraph(graphI);
    }

    public ConstructI getConstructAlgorithm() {
        return this._construct;
    }

    public double getCost() {
        return this._construct.getCost();
    }

    public Vector getTour() {
        return this._construct.getTour();
    }

    public double improveClosedTour(Vector vector) throws TourNotFoundException {
        if (this._graph == null) {
            throw new TourNotFoundException("The graph is not set.");
        }
        if (vector.size() < 1) {
            throw new TourNotFoundException("The tour to improve was empty");
        }
        this.select(vector);
        this._construct.constructClosedTour();
        return this.getCost();
    }

    public double improveOpenTour(Vector vector) throws TourNotFoundException {
        if (this._graph == null) {
            throw new TourNotFoundException("The graph is not set.");
        }
        if (vector.size() < 1) {
            throw new TourNotFoundException("The tour to improve was empty");
        }
        this.select(vector);
        this._construct.constructOpenTour();
        return this.getCost();
    }

    public double improveOpenTour(Vector vector, boolean bl, boolean bl2) throws TourNotFoundException {
        if (this._graph == null) {
            throw new TourNotFoundException("The graph is not set.");
        }
        if (vector.size() < 1) {
            throw new TourNotFoundException("The tour to improve was empty");
        }
        this.select(vector);
        Object object = ((VertexI)vector.firstElement()).getKey();
        Object object2 = ((VertexI)vector.lastElement()).getKey();
        try {
            if (bl && bl2) {
                this._construct.constructOpenTour(object, object2);
            } else if (bl) {
                this._construct.constructOpenTourFrom(object);
            } else if (bl2) {
                this._construct.constructOpenTourTo(object2);
            } else {
                this._construct.constructOpenTour();
            }
        }
        catch (VertexNotFoundException vertexNotFoundException) {
            throw new TourNotFoundException("Can't find a vertex in the tour by key.");
        }
        return this.getCost();
    }

    public Vector rotateClosedTour(Vector vector, Object object) throws VertexNotFoundException {
        return this._construct.rotateClosedTour(vector, object);
    }

    private void select(Vector vector) {
        Enumeration enumeration = vector.elements();
        VertexI vertexI = (VertexI)enumeration.nextElement();
        boolean[] blArray = new boolean[this._graph.sizeOfVertices()];
        blArray[vertexI.getIndex()] = true;
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            vertexI = (VertexI)enumeration.nextElement();
            blArray[vertexI.getIndex()] = true;
        }
        this._construct.selectVertex(blArray);
    }

    public void setEdgeKey(Object object) {
        this._construct.setEdgeKey(object);
    }

    public void setGraph(GraphI graphI) {
        this._graph = graphI;
        this._construct.setGraph(graphI);
    }

    public void setProperties(PropertiesI propertiesI) {
        this._construct.setProperties(propertiesI);
    }
}

