/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.graph.vrp;

import drasys.or.CompareI;
import drasys.or.alg.QuickSort;
import drasys.or.graph.ElementI;
import drasys.or.graph.VertexI;
import drasys.or.graph.VertexNotFoundException;
import drasys.or.graph.tsp.ImproveI;
import drasys.or.graph.tsp.TourNotFoundException;
import drasys.or.graph.vrp.ConstructI;
import drasys.or.graph.vrp.RandomizableBase;
import drasys.or.graph.vrp.RandomizableI;
import drasys.or.graph.vrp.SolutionNotFoundException;
import java.util.Enumeration;
import java.util.Vector;

public class ClarkeWrightBase
extends RandomizableBase
implements ConstructI,
RandomizableI {
    int _pos;
    int _numTours = 0;
    Node _depot;
    Tour _tourList;
    Vector _savings;

    public ClarkeWrightBase() {
    }

    public ClarkeWrightBase(ImproveI improveI) {
        super(improveI);
    }

    private void construct() throws SolutionNotFoundException, VertexNotFoundException {
        if (this._graph == null) {
            throw new SolutionNotFoundException("The graph is not set");
        }
        VertexI vertexI = this._graph.getVertex(this._depotKey);
        if (vertexI == null) {
            throw new VertexNotFoundException("Can't find the Depot: " + this._depotKey);
        }
        this._depot = new Node(vertexI);
        this.initTours();
        this.initSavings();
        this.mergeTours();
        this._savings = null;
    }

    public double constructClosedTours(Object object) throws SolutionNotFoundException, VertexNotFoundException {
        this._closed = true;
        this._depotKey = object;
        this.construct();
        return this.getCost();
    }

    public double constructInboundTours(Object object) throws SolutionNotFoundException, VertexNotFoundException {
        this._closed = false;
        this._out = false;
        this._depotKey = object;
        this.construct();
        return this.getCost();
    }

    public double constructOutboundTours(Object object) throws SolutionNotFoundException, VertexNotFoundException {
        this._closed = false;
        this._out = true;
        this._depotKey = object;
        this.construct();
        return this.getCost();
    }

    public double getCost() throws SolutionNotFoundException {
        if (this._numTours == 0) {
            throw new SolutionNotFoundException("No solution has been created");
        }
        double d = 0.0;
        Tour tour = this._tourList;
        while (tour != null) {
            if (tour._deleted == null) {
                d += tour._cost;
            }
            tour = tour._nextTour;
        }
        return d;
    }

    private double getCost(Node node, Node node2) {
        return this.getCost(node._vertex, node2._vertex);
    }

    public double[] getCosts() throws SolutionNotFoundException {
        if (this._numTours == 0) {
            throw new SolutionNotFoundException("No solution has been created");
        }
        double[] dArray = new double[this._numTours];
        int n = 0;
        Tour tour = this._tourList;
        while (tour != null) {
            if (tour._deleted == null) {
                dArray[n++] = tour._cost;
            }
            tour = tour._nextTour;
        }
        return dArray;
    }

    private double getLoad(Node node) {
        return this.getLoad(node._vertex);
    }

    public double[] getLoads() throws SolutionNotFoundException {
        if (this._numTours == 0) {
            throw new SolutionNotFoundException("No solution has been created");
        }
        double[] dArray = new double[this._numTours];
        int n = 0;
        Tour tour = this._tourList;
        while (tour != null) {
            if (tour._deleted == null) {
                dArray[n++] = tour._load;
            }
            tour = tour._nextTour;
        }
        return dArray;
    }

    public Vector[] getTours() throws SolutionNotFoundException {
        if (this._numTours == 0) {
            throw new SolutionNotFoundException("No solution has been created");
        }
        int n = 0;
        Vector[] vectorArray = new Vector[this._numTours];
        Tour tour = this._tourList;
        while (tour != null) {
            if (tour._deleted == null) {
                int n2 = n++;
                Vector<ElementI> vector = new Vector<ElementI>();
                vectorArray[n2] = vector;
                Vector<ElementI> vector2 = vector;
                if (this._closed || this._out) {
                    vector2.addElement(this._depot._vertex);
                    vector2.addElement(this._graph.getEdge(this._depot._vertex, tour._first._vertex, this._edgeKey));
                }
                Node node = tour._first;
                vector2.addElement(node._vertex);
                Node node2 = node._next;
                while (node2 != null) {
                    vector2.addElement(this._graph.getEdge(node._vertex, node2._vertex, this._edgeKey));
                    vector2.addElement(node2._vertex);
                    node = node2;
                    node2 = node2._next;
                }
                if (this._closed || !this._out) {
                    vector2.addElement(this._graph.getEdge(tour._last._vertex, this._depot._vertex, this._edgeKey));
                    vector2.addElement(this._depot._vertex);
                }
            }
            tour = tour._nextTour;
        }
        return vectorArray;
    }

    private void improve(Tour tour) throws SolutionNotFoundException {
        double d;
        double d2 = tour._cost;
        Vector<VertexI> vector = new Vector<VertexI>(tour._sizeOfNodes + 2);
        if (this._closed || this._out) {
            vector.addElement(this._depot._vertex);
            vector.addElement(null);
        }
        Node node = tour._first;
        vector.addElement(node._vertex);
        while ((node = node._next) != null) {
            vector.addElement(null);
            vector.addElement(node._vertex);
        }
        if (this._closed || !this._out) {
            vector.addElement(null);
            vector.addElement(this._depot._vertex);
        }
        try {
            d = this._closed ? this._improve.improveClosedTour(vector) : (this._out ? this._improve.improveOpenTour(vector, true, false) : this._improve.improveOpenTour(vector, false, true));
        }
        catch (TourNotFoundException tourNotFoundException) {
            throw new SolutionNotFoundException("Subalg: " + tourNotFoundException.getMessage());
        }
        tour._cost = this._vehicleCost + d;
        double d3 = d2 - tour._cost;
        if (d3 < -1.0E-6) {
            throw new SolutionNotFoundException("The subalgorithm increased the tour cost by: " + -d3);
        }
        Enumeration enumeration = this._improve.getTour().elements();
        if (this._closed || this._out) {
            enumeration.nextElement();
            enumeration.nextElement();
        }
        node = tour._first;
        node = tour._first;
        while (node != tour._last) {
            node._vertex = (VertexI)enumeration.nextElement();
            enumeration.nextElement();
            node = node._next;
        }
        tour._last._vertex = (VertexI)enumeration.nextElement();
    }

    private void initSavings() {
        this._savings = new Vector(this._numTours * this._numTours);
        Tour tour = this._tourList;
        while (tour != null) {
            Tour tour2 = this._tourList;
            while (tour2 != null) {
                if (tour != tour2) {
                    double d = this._vehicleCost - this.getCost(tour._last, tour2._first);
                    d = this._closed ? (d += this.getCost(this._depot, tour2._first) + this.getCost(tour._last, this._depot)) : (this._out ? (d += this.getCost(this._depot, tour2._first)) : (d += this.getCost(tour._last, this._depot)));
                    this._savings.addElement(new Save(tour, tour2, d));
                }
                tour2 = tour2._nextTour;
            }
            tour = tour._nextTour;
        }
        new QuickSort(new CmpSave()).sort(this._savings);
    }

    private void initTours() throws SolutionNotFoundException {
        this._numTours = 0;
        this._tourList = null;
        Enumeration enumeration = this._graph.vertices();
        while (enumeration.hasMoreElements()) {
            VertexI vertexI = (VertexI)enumeration.nextElement();
            if (vertexI == this._depot._vertex || !this.isSelected(vertexI)) continue;
            Tour tour = new Tour(this._depot, new Node(vertexI));
            tour._nextTour = this._tourList;
            this._tourList = tour;
            ++this._numTours;
        }
    }

    private void mergeTours() throws SolutionNotFoundException {
        Save save;
        this._pos = 0;
        while ((save = this.nextSave()) != null) {
            boolean bl = true;
            boolean bl2 = false;
            while (bl) {
                bl = false;
                Tour tour = save._tour1;
                Tour tour2 = save._tour2;
                while (tour._deleted != null) {
                    tour = tour._deleted;
                }
                while (tour2._deleted != null) {
                    tour2 = tour2._deleted;
                }
                if (tour == tour2 || tour._load + tour2._load > this._maxLoad) continue;
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = this.getCost(tour._last, tour2._first);
                double d6 = this.getCost(tour2._last, tour._first);
                if (this._closed || this._out) {
                    d = this.getCost(this._depot, tour._first);
                    d2 = this.getCost(this._depot, tour2._first);
                }
                if (this._closed || !this._out) {
                    d3 = this.getCost(tour._last, this._depot);
                    d4 = this.getCost(tour2._last, this._depot);
                }
                if (d + d5 + d4 > d2 + d6 + d3) {
                    Tour tour3 = tour;
                    tour = tour2;
                    tour2 = tour3;
                }
                double d7 = this._vehicleCost - this.getCost(tour._last, tour2._first);
                if (this._closed || this._out) {
                    d7 += this.getCost(this._depot, tour2._first);
                }
                if (this._closed || !this._out) {
                    d7 += this.getCost(tour._last, this._depot);
                }
                double d8 = tour._cost + tour2._cost - d7;
                if (d7 < 0.0 || d8 > this._maxCost) {
                    if (this._improve == null || bl2) continue;
                    bl = true;
                    bl2 = true;
                    this.improve(tour);
                    this.improve(tour2);
                    continue;
                }
                tour2._deleted = tour;
                tour._last._next = tour2._first;
                tour._last = tour2._last;
                tour._load += tour2._load;
                tour._cost = d8;
                tour._sizeOfNodes += tour2._sizeOfNodes;
                --this._numTours;
            }
        }
    }

    private int nextPos(int n) {
        while (n < this._savings.size() && ((Save)this._savings.elementAt((int)n))._used) {
            ++n;
        }
        return n;
    }

    private Save nextSave() {
        int n = this._strength == 0 ? 0 : (int)(this._random.nextDouble() * (double)this._strength + 0.5);
        this._pos = this.nextPos(this._pos);
        if (this._pos >= this._savings.size()) {
            return null;
        }
        int n2 = this._pos;
        int n3 = 0;
        while (n3 < n) {
            int n4 = this.nextPos(n2 + 1);
            if (n4 >= this._savings.size()) break;
            n2 = n4;
            ++n3;
        }
        Save save = (Save)this._savings.elementAt(n2);
        save._used = true;
        return save;
    }

    class CmpSave
    implements CompareI {
        CmpSave() {
        }

        public int compare(Object object, Object object2) {
            if (((Save)object)._savings > ((Save)object2)._savings) {
                return -1;
            }
            if (((Save)object)._savings < ((Save)object2)._savings) {
                return 1;
            }
            return 0;
        }
    }

    class Save {
        Tour _tour1;
        Tour _tour2;
        double _savings;
        boolean _used = false;

        Save(Tour tour, Tour tour2, double d) {
            this._tour1 = tour;
            this._tour2 = tour2;
            this._savings = d;
        }
    }

    class Node {
        Node _next = null;
        double _load = 0.0;
        VertexI _vertex = null;

        Node(VertexI vertexI) {
            this._vertex = vertexI;
            this._load = ClarkeWrightBase.this.getLoad(vertexI);
        }
    }

    class Tour {
        Node _depot = null;
        Node _last = null;
        Node _first = null;
        Tour _deleted = null;
        Tour _nextTour = null;
        int _sizeOfNodes = 0;
        double _load = 0.0;
        double _cost = 0.0;

        Tour(Node node, Node node2) throws SolutionNotFoundException {
            this._depot = node;
            this._load = node2._load;
            this._last = node2;
            this._first = node2;
            this._cost = ClarkeWrightBase.this._vehicleCost;
            this._sizeOfNodes = 1;
            if (ClarkeWrightBase.this._closed || ClarkeWrightBase.this._out) {
                this._cost += ClarkeWrightBase.this.getCost(node, node2);
            }
            if (ClarkeWrightBase.this._closed || !ClarkeWrightBase.this._out) {
                this._cost += ClarkeWrightBase.this.getCost(node2, node);
            }
            if (this._cost > ClarkeWrightBase.this._maxCost) {
                throw new SolutionNotFoundException("A node singularly exceeds the cost constraint:" + this._cost + ">" + ClarkeWrightBase.this._maxCost);
            }
            if (this._load > ClarkeWrightBase.this._maxLoad) {
                throw new SolutionNotFoundException("A node singularly exceeds the load constraint:" + this._load + ">" + ClarkeWrightBase.this._maxLoad);
            }
        }
    }
}

