/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.matrix;

import drasys.or.matrix.ContiguousVectorI;
import drasys.or.matrix.MatrixError;
import drasys.or.matrix.SizableVectorI;
import drasys.or.matrix.Vect;
import drasys.or.matrix.VectorElementI;
import drasys.or.matrix.VectorI;
import drasys.or.util.Array;
import java.util.Enumeration;

public class ContiguousVector
extends Vect
implements ContiguousVectorI,
SizableVectorI {
    int _size;
    double[] _values;

    public ContiguousVector() {
        this._size = 0;
        this._values = new double[10];
    }

    public ContiguousVector(int n) {
        this._size = n;
        this._values = new double[Math.max(10, this._size)];
    }

    public ContiguousVector(int n, double d) {
        this._size = n;
        this._values = new double[Math.max(10, this._size)];
        Array.copy(this._size, this._values, 0, 1, d);
    }

    public ContiguousVector(int n, int n2) {
        this._size = n;
        this._values = new double[Math.max(n, n2)];
    }

    public ContiguousVector(VectorI vectorI) {
        this._size = vectorI.size();
        this._values = new double[vectorI.size()];
        Enumeration enumeration = vectorI.elements();
        while (enumeration.hasMoreElements()) {
            VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
            this._values[vectorElementI.getIndex()] = vectorElementI.getValue();
        }
    }

    public ContiguousVector(double[] dArray) {
        this(dArray, false);
    }

    public ContiguousVector(double[] dArray, boolean bl) {
        this._size = dArray.length;
        if (bl) {
            this._values = dArray;
        } else {
            this._values = new double[dArray.length];
            Array.copy(this._size, this._values, 0, 1, dArray, 0, 1);
        }
    }

    public void addElement(double d) {
        if (this._size == this._values.length) {
            this._values = Array.resize(2 * this._size, this._values);
        }
        this._values[this._size++] = d;
    }

    public int capacity() {
        return this._values.length;
    }

    public double elementAt(int n) {
        if (n >= this._size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this._values[n];
    }

    public Enumeration elements() {
        return new Enum(this._values, this._size, 0, 1);
    }

    public double[] getArray() {
        double[] dArray = new double[this._size];
        Array.copy(this._size, dArray, 0, 1, this._values, 0, 1);
        return dArray;
    }

    public int getBegin() {
        return 0;
    }

    public int getIncrement() {
        return 1;
    }

    public int getOffset(int n) {
        return n;
    }

    public double[] getValueArray() {
        return this._values;
    }

    public boolean isNull(int n) {
        return false;
    }

    public void setCapacity(int n) {
        if (n > this._values.length) {
            this._values = Array.resize(n, this._values);
        }
    }

    public void setElementAt(int n, double d) {
        if (n >= this._size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this._values[n] = d;
    }

    public void setElements(double d) {
        Array.copy(this._values.length, this._values, 0, 1, d);
    }

    public void setSize(int n) {
        if (n > this._values.length) {
            Array.resize(n, this._values);
        }
        this._size = n;
    }

    public int size() {
        return this._size;
    }

    public int sizeOfElements() {
        return this._size;
    }

    public ContiguousVectorI subvector(int n) {
        if (n >= this._size) {
            throw new MatrixError("Subvector 'begin' is past last element");
        }
        return new Sub(this._values, this._size - n, n, 1);
    }

    public ContiguousVectorI subvector(int n, int n2) {
        if (n > n2) {
            throw new MatrixError("Subvector 'begin' greater than 'end'");
        }
        if (n2 > this._size) {
            throw new MatrixError("Subvector 'end' is past last element");
        }
        return new Sub(this._values, n2 - n, n, 1);
    }

    public double sum(int n, int n2) {
        return Array.sum(n2 - n, this._values, n, 1);
    }

    public double sumOfSquaredDifferences(int n, int n2, double d) {
        return Array.sumOfSquaredDifferences(n2 - n, this._values, n, 1, d);
    }

    public double sumOfSquares(int n, int n2) {
        return Array.sumOfSquares(n2 - n, this._values, n, 1);
    }

    static class Enum
    implements Enumeration,
    VectorElementI {
        int _siz;
        int _beg;
        int _inc;
        int _idx = 0;
        double[] _values;
        private int _mindex;
        private int _moff;
        private double _mvalue;

        Enum(double[] dArray, int n, int n2, int n3) {
            this._siz = n;
            this._beg = n2;
            this._inc = n3;
            this._values = dArray;
        }

        public int getIndex() {
            return this._mindex;
        }

        public double getValue() {
            return this._mvalue;
        }

        public boolean hasMoreElements() {
            return this._idx < this._siz;
        }

        public Object nextElement() {
            if (this._idx >= this._siz) {
                return null;
            }
            this._mindex = this._idx++;
            this._moff = this._beg;
            this._mvalue = this._values[this._moff];
            this._beg += this._inc;
            return this;
        }

        public void setValue(double d) {
            this._values[this._moff] = this._mvalue = d;
        }
    }

    static class Sub
    extends Vect
    implements ContiguousVectorI {
        int _siz;
        int _beg;
        int _inc;
        double[] _values;

        public Sub(double[] dArray, int n, int n2, int n3) {
            this._siz = n;
            this._beg = n2;
            this._inc = n3;
            this._values = dArray;
        }

        public double elementAt(int n) {
            if (n >= this._siz) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return this._values[this._beg + this._inc * n];
        }

        public Enumeration elements() {
            return new Enum(this._values, this._siz, this._beg, this._inc);
        }

        public double[] getArray() {
            double[] dArray = new double[this._siz];
            Array.copy(this._siz, dArray, 0, 1, this._values, this._beg, this._inc);
            return dArray;
        }

        public int getBegin() {
            return this._beg;
        }

        public int getIncrement() {
            return this._inc;
        }

        public int getOffset(int n) {
            return this._beg + this._inc * n;
        }

        public double[] getValueArray() {
            return this._values;
        }

        public boolean isNull(int n) {
            return false;
        }

        public void setElementAt(int n, double d) {
            if (n >= this._siz) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this._values[this._beg + n * this._inc] = d;
        }

        public void setElements(double d) {
            Array.copy(this._siz, this._values, this._beg, this._inc, d);
        }

        public int size() {
            return this._siz;
        }

        public int sizeOfElements() {
            return this._siz;
        }

        public ContiguousVectorI subvector(int n) {
            if (n >= this._siz) {
                throw new MatrixError("Subvector 'begin' is past last element");
            }
            return new Sub(this._values, this._siz - n, this._beg + this._inc * n, this._inc);
        }

        public ContiguousVectorI subvector(int n, int n2) {
            if (n > n2) {
                throw new MatrixError("Subvector 'begin' greater than 'end'");
            }
            if (n2 > this._siz) {
                throw new MatrixError("Subvector 'end' is past last element");
            }
            return new Sub(this._values, n2 - n, this._beg + this._inc * n, this._inc);
        }

        public double sum(int n, int n2) {
            if (n > n2) {
                throw new MatrixError("Subvector 'begin' greater than 'end'");
            }
            if (n2 > this._siz) {
                throw new MatrixError("Subvector 'end' is past last element");
            }
            return Array.sum(this._siz, this._values, this._beg, this._inc);
        }

        public double sumOfSquaredDifferences(int n, int n2, double d) {
            if (n > n2) {
                throw new MatrixError("Subvector 'begin' greater than 'end'");
            }
            if (n2 > this._siz) {
                throw new MatrixError("Subvector 'end' is past last element");
            }
            return Array.sumOfSquaredDifferences(this._siz, this._values, this._beg, this._inc, d);
        }

        public double sumOfSquares(int n, int n2) {
            if (n > n2) {
                throw new MatrixError("Subvector 'begin' greater than 'end'");
            }
            if (n2 > this._siz) {
                throw new MatrixError("Subvector 'end' is past last element");
            }
            return Array.sumOfSquares(this._siz, this._values, this._beg, this._inc);
        }
    }
}

