/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.mp;

import drasys.or.mp.MpError;
import drasys.or.mp.VariableI;
import java.io.Serializable;

public class Variable
implements VariableI,
Serializable {
    int _columnIndex = 0;
    byte _type = (byte)21;
    String _name = null;
    double _lowerBound = 0.0;
    double _upperBound = Double.POSITIVE_INFINITY;
    double _objectiveCoefficient = 0.0;

    Variable(int n, String string) {
        this._name = string;
        this._columnIndex = n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof VariableI)) {
            return false;
        }
        VariableI variableI = (VariableI)object;
        if (this._type != variableI.getType()) {
            return false;
        }
        if (this._lowerBound != variableI.getLowerBound()) {
            return false;
        }
        if (this._upperBound != variableI.getUpperBound()) {
            return false;
        }
        return this._objectiveCoefficient == variableI.getObjectiveCoefficient();
    }

    public int getColumnIndex() {
        return this._columnIndex;
    }

    public double getLowerBound() {
        return this._lowerBound;
    }

    public String getName() {
        return this._name;
    }

    public double getObjectiveCoefficient() {
        return this._objectiveCoefficient;
    }

    public byte getType() {
        return this._type;
    }

    public double getUpperBound() {
        return this._upperBound;
    }

    public VariableI setLowerBound(double d) {
        this._lowerBound = d;
        return this;
    }

    public VariableI setObjectiveCoefficient(double d) {
        this._objectiveCoefficient = d;
        return this;
    }

    public VariableI setType(byte by) {
        if (by != 20 && by != 21 && by != 22 && by != 23) {
            throw new MpError("Invalid variable type: " + by);
        }
        this._type = by;
        return this;
    }

    public VariableI setUpperBound(double d) {
        this._upperBound = d;
        return this;
    }

    public String toString() {
        String string = "";
        string = String.valueOf(string) + "[" + this._columnIndex + "]";
        if (this._name != null) {
            string = String.valueOf(string) + ", " + this._name;
        }
        string = String.valueOf(string) + ", " + Variable.typeToString(this._type);
        string = String.valueOf(string) + ", Obj=" + this._objectiveCoefficient;
        string = String.valueOf(string) + ", LoBnd=" + this._lowerBound;
        string = String.valueOf(string) + ", UpBnd=" + this._upperBound;
        return string;
    }

    public static String typeToString(byte by) {
        switch (by) {
            case 20: {
                return "FREE";
            }
            case 21: {
                return "REAL";
            }
            case 22: {
                return "INTEGER";
            }
            case 23: {
                return "BOOLEAN";
            }
        }
        return "UNKNOWN-" + by;
    }
}

