/*
 * Decompiled with CFR 0.152.
 */
package interfacing;

import interfacing.MainFrame;
import interfacing.NonEditableTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import mapping.data.JobsTableListener;

public class JobsTableJPanel
extends JPanel
implements JobsTableListener,
MouseListener {
    private static final long serialVersionUID = -3722479581330212830L;
    private MainFrame frame;
    private NonEditableTableModel tableModel;
    private JTable jTable;
    private String[] coloumNames = new String[]{"ID", "Secondary ID", "Job Class", "Server", "Date Submitted", "Date Sent", "Date Started", "Date Done", "Status", "T/O"};
    private JScrollPane scrollPane;
    private SimpleDateFormat formatter;

    public JobsTableJPanel(MainFrame frame) {
        this.frame = frame;
        this.formatter = new SimpleDateFormat("dd/MM/yy 'at' HH:mm:ss");
        this.jTable = new JTable();
        this.scrollPane = new JScrollPane();
        this.fillJTable();
        this.scrollPane.setViewportView(this.jTable);
        this.setLayout(new BorderLayout());
        this.add(this.scrollPane);
        this.jTable.addMouseListener(this);
        this.jTable.getColumnModel().getColumn(0).setPreferredWidth(40);
        this.jTable.getColumnModel().getColumn(1).setPreferredWidth(80);
        this.jTable.getColumnModel().getColumn(2).setPreferredWidth(60);
        this.jTable.getColumnModel().getColumn(3).setPreferredWidth(100);
        this.jTable.getColumnModel().getColumn(4).setPreferredWidth(150);
        this.jTable.getColumnModel().getColumn(5).setPreferredWidth(150);
        this.jTable.getColumnModel().getColumn(6).setPreferredWidth(150);
        this.jTable.getColumnModel().getColumn(7).setPreferredWidth(150);
        this.jTable.getColumnModel().getColumn(8).setPreferredWidth(50);
        this.jTable.getColumnModel().getColumn(9).setPreferredWidth(40);
        this.jTable.setGridColor(Color.GRAY);
    }

    public void fillJTable() {
        this.tableModel = new NonEditableTableModel(this.coloumNames, 0);
        this.jTable.setModel(this.tableModel);
        long i = 0L;
        while (i < (long)this.frame.getMapper().getJobsTable().size()) {
            GregorianCalendar dateStarted = this.frame.getMapper().getJobsTable().getJobTimeStarted(i + 1L);
            String dateStartedString = dateStarted == null ? "" : this.formatter.format(dateStarted.getTime());
            GregorianCalendar dateDone = this.frame.getMapper().getJobsTable().getJobTimeDone(i + 1L);
            String dateDoneString = dateDone == null ? "" : this.formatter.format(dateDone.getTime());
            String timedOut = this.frame.getMapper().getJobsTable().getJobIsTimedOut(i + 1L) ? "Yes" : "No";
            Object[] s = new String[]{String.valueOf(this.frame.getMapper().getJobsTable().getJobIndex(i + 1L)), String.valueOf(this.frame.getMapper().getJobsTable().getJobSecondaryID(i + 1L)), String.valueOf(this.frame.getMapper().getJobsTable().getJobClassID(i + 1L)), String.valueOf(this.frame.getMapper().getJobsTable().getJobServer(i + 1L).getIndex()), this.formatter.format(this.frame.getMapper().getJobsTable().getJobTimeSubmitted(i + 1L).getTime()), dateStartedString, dateDoneString, String.valueOf(this.frame.getMapper().getJobsTable().getJobStatus(i + 1L)), timedOut};
            this.tableModel.addRow(s);
            ++i;
        }
    }

    public void jobHasBeenAdded(long jobID, long jobSecondaryID, int jobClassID, String serverName, GregorianCalendar timeSubmitted, GregorianCalendar timeSent, GregorianCalendar timeStarted, GregorianCalendar timeDone, String status, boolean timedOut) {
        String timeSentString = "";
        String timeStartedString = "";
        String timeDoneString = "";
        if (timeSent != null) {
            timeSentString = this.formatter.format(timeSent.getTime());
        }
        if (timeStarted != null) {
            timeStartedString = this.formatter.format(timeStarted.getTime());
        }
        if (timeDone != null) {
            timeDoneString = this.formatter.format(timeDone.getTime());
        }
        String timedOutString = "No";
        if (timedOut) {
            timedOutString = "Yes";
        }
        Object[] s = new String[]{String.valueOf(jobID), String.valueOf(jobSecondaryID), String.valueOf(jobClassID), serverName, this.formatter.format(timeSubmitted.getTime()), timeSentString, timeStartedString, timeDoneString, status, timedOutString};
        this.tableModel.addRow(s);
        this.repaint();
    }

    public void secondaryIDHasBeenChanged(long jobID, long jobSecondayID) {
        this.tableModel.setValueAt(jobSecondayID, (int)jobID - 1, 1);
    }

    public void jobClassIDHasBeenChanged(long jobID, int jobClassId) {
        this.tableModel.setValueAt(jobClassId, (int)jobID - 1, 2);
    }

    public void serverNameHasBeenChanged(long jobID, String serverName) {
    }

    public void serverIDHasBeenChanged(long jobID, int serverID) {
        this.tableModel.setValueAt(serverID, (int)jobID - 1, 3);
    }

    public void timeSubmittedHasBeenChanged(long jobID, GregorianCalendar timeSubmitted) {
        this.tableModel.setValueAt(this.formatter.format(timeSubmitted.getTime()), (int)jobID - 1, 4);
    }

    public void timeSentHasBeenChanged(long jobID, GregorianCalendar timeSent) {
        this.tableModel.setValueAt(this.formatter.format(timeSent.getTime()), (int)jobID - 1, 5);
    }

    public void timeStartedHasBeenChanged(long jobID, GregorianCalendar timeStarted) {
        this.tableModel.setValueAt(this.formatter.format(timeStarted.getTime()), (int)jobID - 1, 6);
    }

    public void timeDoneHasBeenChanged(long jobID, GregorianCalendar timeDone) {
        this.tableModel.setValueAt(this.formatter.format(timeDone.getTime()), (int)jobID - 1, 7);
    }

    public void statusHasBeenChanged(long jobID, String status) {
        this.tableModel.setValueAt(status, (int)jobID - 1, 8);
    }

    public void timedOutStatusChanged(long jobID, boolean timedOut) {
        if (timedOut) {
            this.tableModel.setValueAt("Yes", (int)jobID - 1, 9);
        } else {
            this.tableModel.setValueAt("No", (int)jobID - 1, 9);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() != 2) {
            return;
        }
        if (this.jTable.getSelectedRow() >= 0 && this.jTable.getSelectedRow() < this.frame.getMapper().getJobsTable().size()) {
            JOptionPane.showMessageDialog(this, "Server hostname is: " + this.frame.getMapper().getJobsTable().getJobServer((long)this.jTable.getSelectedRow() + 1L).getHostName(), "Job", 1);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }
}

