/*
 * Decompiled with CFR 0.152.
 */
package logging;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import logging.Event;

public class Logger
implements Serializable {
    private static final long serialVersionUID = 8644243290739780799L;
    private String fileName;
    private FileWriter fileWriter;
    private BufferedWriter bufferedWriter;
    private boolean textMode = true;
    private final String LOGS_FOLDER = new String("Logs");

    public Logger(String fileName) {
        this.setFileName(fileName);
        try {
            this.setFileWriter(new FileWriter(String.valueOf(this.LOGS_FOLDER) + "/" + this.getFileName() + ".log", true));
            this.setBufferedWriter(new BufferedWriter(this.getFileWriter()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private FileWriter getFileWriter() {
        return this.fileWriter;
    }

    private void setFileWriter(FileWriter fileWriter) {
        this.fileWriter = fileWriter;
    }

    private BufferedWriter getBufferedWriter() {
        return this.bufferedWriter;
    }

    private void setBufferedWriter(BufferedWriter bufferedWriter) {
        this.bufferedWriter = bufferedWriter;
    }

    public String getFileName() {
        return this.fileName;
    }

    private void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean isTextMode() {
        return this.textMode;
    }

    public void setTextMode(boolean textMode) {
        this.textMode = textMode;
    }

    public void log(String eventString) {
        this.logEvent(new Event(eventString));
    }

    public void logEvent(Event ev) {
        if (this.isTextMode()) {
            this.logEventTM(ev);
        } else {
            this.logEventOM(ev);
        }
    }

    private void logEventTM(Event ev) {
        try {
            this.getBufferedWriter().append(String.valueOf(ev.toString()) + "\n");
            this.getBufferedWriter().flush();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private void logEventOM(Event ev) {
        block12: {
            ObjectOutputStream output = null;
            try {
                try {
                    output = new ObjectOutputStream(new FileOutputStream(new File(String.valueOf(this.LOGS_FOLDER) + "/" + this.fileName), true));
                    output.writeObject(ev);
                    System.out.println(String.valueOf(ev.toString()) + " was added.");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (output == null) break block12;
                    try {
                        output.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void printAllEvents() {
        ObjectInputStream input = null;
        Object o = null;
        try {
            input = new ObjectInputStream(new FileInputStream(new File(this.getFileName())));
            while (true) {
                o = input.readObject();
                System.out.print(((Event)o).toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        catch (ClassNotFoundException e1) {
            try {
                e1.printStackTrace();
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void closeStreams() {
        try {
            this.getFileWriter().close();
            this.getBufferedWriter().close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

