/*
 * Decompiled with CFR 0.152.
 */
package pulling.executing;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import pulling.executing.ServerSideExecuter;

public class CompletionAnnouncer_Xgrid
implements Runnable {
    private final String FINISHED = "Finished";
    private String mapperHostName;
    private int completionServerPort = 37931;
    private int completionAnnouncerPort = 37932;
    private boolean alive;
    private String hostName;
    private String password;
    private long jobID;
    private long jobSecondaryID;
    private long serverID;
    private long timeToSleepAtStart;
    private ServerSideExecuter executer;
    private Thread thisThread;
    ServerSocket serverSocket = null;
    Socket socket = null;
    DataInputStream in = null;
    Socket mapperSocket = null;
    DataOutputStream out = null;

    public CompletionAnnouncer_Xgrid(String mapperHostName, String password, ServerSideExecuter executer) {
        try {
            this.setHostName(InetAddress.getLocalHost().getCanonicalHostName());
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        this.setTimeToSleepAtStart(3000L);
        this.setMapperHostName(mapperHostName);
        this.setPassword(password);
        this.setAlive(true);
        this.setExecuter(executer);
    }

    public synchronized boolean isAlive() {
        return this.alive;
    }

    public synchronized void setAlive(boolean alive) {
        this.alive = alive;
    }

    public String getMapperHostName() {
        return this.mapperHostName;
    }

    public void setMapperHostName(String mapperHostName) {
        this.mapperHostName = mapperHostName;
    }

    public int getCompletionServerPort() {
        return this.completionServerPort;
    }

    public void setCompletionServerPort(int completionServerPort) {
        this.completionServerPort = completionServerPort;
    }

    public int getCompletionAnnouncerPort() {
        return this.completionAnnouncerPort;
    }

    public void setCompletionAnnouncerPort(int completionAnnouncerPort) {
        this.completionAnnouncerPort = completionAnnouncerPort;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String mapperPassword) {
        this.password = mapperPassword;
    }

    public long getJobID() {
        return this.jobID;
    }

    public void setJobID(long jobID) {
        this.jobID = jobID;
    }

    public long getJobSecondaryID() {
        return this.jobSecondaryID;
    }

    public void setJobSecondaryID(long jobSecondaryID) {
        this.jobSecondaryID = jobSecondaryID;
    }

    public long getServerID() {
        return this.serverID;
    }

    public void setServerID(long serverID) {
        this.serverID = serverID;
    }

    public long getTimeToSleepAtStart() {
        return this.timeToSleepAtStart;
    }

    public void setTimeToSleepAtStart(long timeToSleepAtStart) {
        this.timeToSleepAtStart = timeToSleepAtStart;
    }

    public ServerSideExecuter getExecuter() {
        return this.executer;
    }

    public void setExecuter(ServerSideExecuter executer) {
        this.executer = executer;
    }

    public void startThread() {
        this.thisThread = new Thread(this);
        this.thisThread.start();
    }

    public void stopThread() {
        boolean wasAlive = this.isAlive();
        this.setAlive(false);
        if (wasAlive) {
            this.getExecuter().deleteJob(this.getJobSecondaryID(), this.getHostName(), this.getPassword());
            this.thisThread.interrupt();
            this.thisThread = null;
        }
        this.closeStreams();
    }

    public void closeStreams() {
        if (this.mapperSocket != null) {
            try {
                this.mapperSocket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void run() {
        boolean active = false;
        this.serverSocket = null;
        this.socket = null;
        this.in = null;
        try {
            this.serverSocket = new ServerSocket(this.getCompletionAnnouncerPort());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        System.out.print("Completion Announcer: " + this.getMapperHostName());
        while (this.isAlive()) {
            block70: {
                block68: {
                    block69: {
                        this.jobID = 0L;
                        this.jobSecondaryID = 0L;
                        this.serverID = 0L;
                        this.timeToSleepAtStart = 0L;
                        try {
                            int r;
                            this.socket = this.serverSocket.accept();
                            this.in = new DataInputStream(this.socket.getInputStream());
                            while ((r = this.in.read()) != -1 && r != 35) {
                                this.jobID = 10L * this.jobID + (long)((char)r - 48);
                            }
                            while ((r = this.in.read()) != -1 && r != 35) {
                                this.jobSecondaryID = 10L * this.jobSecondaryID + (long)((char)r - 48);
                            }
                            while ((r = this.in.read()) != -1 && r != 35) {
                                this.serverID = 10L * this.serverID + (long)((char)r - 48);
                            }
                            while ((r = this.in.read()) != -1 && r != 35) {
                                this.timeToSleepAtStart = 10L * this.timeToSleepAtStart + (long)((char)r - 48);
                            }
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                            if (!this.isAlive()) {
                                System.err.println("Completion Announcer Stopped");
                                if (this.in != null) {
                                    try {
                                        this.in.close();
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                }
                                if (this.socket != null) {
                                    try {
                                        this.socket.close();
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                }
                                return;
                            }
                            if (this.in != null) {
                                try {
                                    this.in.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                            if (this.socket != null) {
                                try {
                                    this.socket.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                            break block68;
                        }
                        catch (Exception ex) {
                            try {
                                ex.printStackTrace();
                                break block68;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                if (this.in != null) {
                                    try {
                                        this.in.close();
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                }
                                if (this.socket != null) {
                                    try {
                                        this.socket.close();
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                        }
                        if (this.in == null) break block69;
                        try {
                            this.in.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (this.socket != null) {
                        try {
                            this.socket.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                active = true;
                this.setJobID(this.jobID);
                this.setJobSecondaryID(this.jobSecondaryID);
                this.setServerID(this.serverID);
                this.setTimeToSleepAtStart(this.timeToSleepAtStart);
                try {
                    Thread.sleep(this.getTimeToSleepAtStart());
                }
                catch (InterruptedException e) {
                    if (this.isAlive()) break block70;
                    return;
                }
            }
            String status = null;
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
            while (active) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    this.closeStreams();
                }
                if (!this.isAlive()) {
                    return;
                }
                if (this.getJobID() != -1L) {
                    status = this.getExecuter().getJobStatus(this.getJobSecondaryID(), this.getHostName(), this.getPassword());
                }
                if (!status.equalsIgnoreCase("Finished")) continue;
                active = false;
                try {
                    String dateSubmitted = this.getExecuter().getDateStarted(this.getJobSecondaryID(), this.getHostName(), this.getPassword());
                    String dateDone = this.getExecuter().getDateStopped(this.getJobSecondaryID(), this.getHostName(), this.getPassword());
                    String message = String.valueOf(formatter.format(new GregorianCalendar().getTime())) + "#" + this.getServerID() + "#" + this.getHostName() + "#" + this.getJobID() + "#" + this.getJobSecondaryID() + "#" + dateSubmitted + "#" + dateDone;
                    this.mapperSocket = new Socket(this.getMapperHostName(), this.getCompletionServerPort());
                    this.out = new DataOutputStream(this.mapperSocket.getOutputStream());
                    System.out.println("Completion Announcer.run (" + this.getHostName() + "): Job with the id was done: " + this.getJobID() + ", " + this.getJobSecondaryID());
                    this.out.writeBytes(message);
                }
                catch (UnknownHostException e) {
                    System.err.println("Don't know about mapper: " + this.getMapperHostName());
                    try {
                        if (this.out != null) {
                            this.out.flush();
                            this.out.close();
                        }
                        if (this.mapperSocket == null) continue;
                        this.mapperSocket.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
                catch (IOException e) {
                    try {
                        System.err.println("FinishedThread.run: Couldn't Connect with the socket  the connection to: " + this.getMapperHostName() + " did not function properly. Make sure Completion Server is listening at " + this.getCompletionServerPort());
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        try {
                            if (this.out != null) {
                                this.out.flush();
                                this.out.close();
                            }
                            if (this.mapperSocket != null) {
                                this.mapperSocket.close();
                            }
                        }
                        catch (IOException e3) {
                            e3.printStackTrace();
                        }
                    }
                }
                try {
                    if (this.out != null) {
                        this.out.flush();
                        this.out.close();
                    }
                    if (this.mapperSocket == null) continue;
                    this.mapperSocket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

