/*
 * Decompiled with CFR 0.152.
 */
package adjusting;

import adjusting.availability_adjusting.FailureTrace;
import java.io.Serializable;
import java.util.GregorianCalendar;
import mapping.data.JobClass;
import mapping.data.Server;

public class Adjuster
implements Serializable {
    private static final long serialVersionUID = 8141122488651635811L;

    public static double getRatio(JobClass jobClass, Server server) {
        double realRate = server.getRealRate(jobClass.getIndex());
        double assumedRate = server.getAssumedRate(jobClass.getIndex());
        double ratio = realRate / assumedRate;
        return ratio;
    }

    public static boolean didAFailureHappen(GregorianCalendar startTime, GregorianCalendar endTime, Server server) {
        FailureTrace trace = server.getFailureTrace();
        return trace.doesRangeOverlapAFailurePeriod(startTime, endTime);
    }

    public static boolean isServerSufferingFromAFailure(GregorianCalendar now, Server server) {
        FailureTrace trace = server.getFailureTrace();
        return trace.IsTimeInFailure(now);
    }

    public static GregorianCalendar getEndOFFailurePeriod(GregorianCalendar now, Server server) {
        FailureTrace trace = server.getFailureTrace();
        return trace.getEndOfFailure(now);
    }
}

