/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.graph.vrp;

import drasys.or.graph.GraphI;
import drasys.or.graph.PropertiesI;
import drasys.or.graph.VertexNotFoundException;
import drasys.or.graph.vrp.ConstructI;
import drasys.or.graph.vrp.RandomizableI;
import drasys.or.graph.vrp.SolutionNotFoundException;
import drasys.or.graph.vrp.VRPBase;
import drasys.or.graph.vrp.VRPError;
import drasys.or.graph.vrp.VRPException;
import drasys.or.graph.vrp.VRPI;
import drasys.or.prob.RandomI;
import java.util.Vector;

public class Randomizer
implements ConstructI {
    Vector _counts = new Vector();
    Vector _strengths = new Vector();
    RandomizableI _randomizable;
    double _bestCost;
    double[] _bestCosts = null;
    double[] _bestLoads = null;
    Vector[] _bestOfTours = null;

    public Randomizer(RandomizableI randomizableI) throws VRPException {
        this._randomizable = randomizableI;
        if (!(randomizableI instanceof ConstructI)) {
            throw new VRPException("The argument 'randomizable' must implement 'ConstructI'.");
        }
    }

    public void addIterations(int n, int n2) {
        if (n <= 0) {
            throw new VRPError("The count must greater than zero");
        }
        this._counts.addElement(new Integer(n));
        this._strengths.addElement(new Integer(n2));
    }

    public double constructClosedTours(Object object) throws SolutionNotFoundException, VertexNotFoundException {
        if (!(this._randomizable instanceof ConstructI)) {
            throw new VRPError("The randomized algorithm doesn't implement 'ConstructI'.");
        }
        ConstructI constructI = (ConstructI)((Object)this._randomizable);
        this._bestCost = Double.POSITIVE_INFINITY;
        this._bestCosts = null;
        this._bestLoads = null;
        this._bestOfTours = null;
        if (this._strengths.size() <= 0) {
            throw new SolutionNotFoundException("The randomizer has no iterations");
        }
        int n = 0;
        while (n < this._strengths.size()) {
            int n2 = (Integer)this._counts.elementAt(n);
            int n3 = (Integer)this._strengths.elementAt(n);
            this._randomizable.setStrength(n3);
            int n4 = 0;
            while (n4 < n2) {
                double d = constructI.constructClosedTours(object);
                if (d < this._bestCost) {
                    this._bestCost = d;
                    this._bestCosts = constructI.getCosts();
                    this._bestLoads = constructI.getLoads();
                    this._bestOfTours = constructI.getTours();
                }
                ++n4;
            }
            ++n;
        }
        return this._bestCost;
    }

    public double constructInboundTours(Object object) throws SolutionNotFoundException, VertexNotFoundException {
        if (!(this._randomizable instanceof ConstructI)) {
            throw new VRPError("The randomized algorithm doesn't implement 'ConstructI'.");
        }
        ConstructI constructI = (ConstructI)((Object)this._randomizable);
        this._bestCost = Double.POSITIVE_INFINITY;
        this._bestCosts = null;
        this._bestLoads = null;
        this._bestOfTours = null;
        if (this._strengths.size() <= 0) {
            throw new SolutionNotFoundException("The randomizer has no iterations");
        }
        int n = 0;
        while (n < this._strengths.size()) {
            int n2 = (Integer)this._counts.elementAt(n);
            int n3 = (Integer)this._strengths.elementAt(n);
            this._randomizable.setStrength(n3);
            int n4 = 0;
            while (n4 < n2) {
                double d = constructI.constructInboundTours(object);
                if (d < this._bestCost) {
                    this._bestCost = d;
                    this._bestCosts = constructI.getCosts();
                    this._bestLoads = constructI.getLoads();
                    this._bestOfTours = constructI.getTours();
                }
                ++n4;
            }
            ++n;
        }
        return this._bestCost;
    }

    public double constructOutboundTours(Object object) throws SolutionNotFoundException, VertexNotFoundException {
        if (!(this._randomizable instanceof ConstructI)) {
            throw new VRPError("The randomized algorithm doesn't implement 'ConstructI'.");
        }
        ConstructI constructI = (ConstructI)((Object)this._randomizable);
        this._bestCost = Double.POSITIVE_INFINITY;
        this._bestCosts = null;
        this._bestLoads = null;
        this._bestOfTours = null;
        if (this._strengths.size() <= 0) {
            throw new SolutionNotFoundException("The randomizer has no iterations");
        }
        int n = 0;
        while (n < this._strengths.size()) {
            int n2 = (Integer)this._counts.elementAt(n);
            int n3 = (Integer)this._strengths.elementAt(n);
            this._randomizable.setStrength(n3);
            int n4 = 0;
            while (n4 < n2) {
                double d = constructI.constructOutboundTours(object);
                if (d < this._bestCost) {
                    this._bestCost = d;
                    this._bestCosts = constructI.getCosts();
                    this._bestLoads = constructI.getLoads();
                    this._bestOfTours = constructI.getTours();
                }
                ++n4;
            }
            ++n;
        }
        return this._bestCost;
    }

    public double getCost() throws SolutionNotFoundException {
        if (this._bestOfTours == null) {
            throw new SolutionNotFoundException("No solution has been created");
        }
        return this._bestCost;
    }

    public double[] getCosts() throws SolutionNotFoundException {
        if (this._bestOfTours == null) {
            throw new SolutionNotFoundException("No solution has been created");
        }
        return this._bestCosts;
    }

    public double[] getLoads() throws SolutionNotFoundException {
        if (this._bestOfTours == null) {
            throw new SolutionNotFoundException("No solution has been created");
        }
        return this._bestLoads;
    }

    public RandomI getRandom() {
        return this._randomizable.getRandom();
    }

    public Vector[] getTours() throws SolutionNotFoundException {
        if (this._bestOfTours == null) {
            throw new SolutionNotFoundException("No solution has been created");
        }
        return VRPBase.copyTours(this._bestOfTours);
    }

    public void selectVertex(Object object, boolean bl) throws VertexNotFoundException {
        if (!(this._randomizable instanceof ConstructI)) {
            throw new VRPError("The randomized algorithm doesn't implement 'ConstructI'.");
        }
        ((ConstructI)((Object)this._randomizable)).selectVertex(object, bl);
    }

    public void selectVertex(boolean bl) {
        if (!(this._randomizable instanceof ConstructI)) {
            throw new VRPError("The randomized algorithm doesn't implement 'ConstructI'.");
        }
        ((ConstructI)((Object)this._randomizable)).selectVertex(bl);
    }

    public void selectVertex(boolean[] blArray) {
        if (!(this._randomizable instanceof ConstructI)) {
            throw new VRPError("The randomized algorithm doesn't implement 'ConstructI'.");
        }
        ((ConstructI)((Object)this._randomizable)).selectVertex(blArray);
    }

    public void setCapacityConstraint(double d) {
        ((VRPI)((Object)this._randomizable)).setCapacityConstraint(d);
    }

    public void setCostConstraint(double d) {
        ((VRPI)((Object)this._randomizable)).setCostConstraint(d);
    }

    public void setEdgeKey(Object object) {
        ((VRPI)((Object)this._randomizable)).setEdgeKey(object);
    }

    public void setGraph(GraphI graphI) {
        ((VRPI)((Object)this._randomizable)).setGraph(graphI);
    }

    public void setProperties(PropertiesI propertiesI) {
        ((VRPI)((Object)this._randomizable)).setProperties(propertiesI);
    }

    public void setRandom(RandomI randomI) {
        this._randomizable.setRandom(randomI);
    }

    public void setVehicleCost(double d) {
        ((VRPI)((Object)this._randomizable)).setVehicleCost(d);
    }
}

