/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.matrix;

import drasys.or.matrix.CompressedMatrix;
import drasys.or.matrix.MatrixElementI;
import drasys.or.matrix.MatrixI;
import drasys.or.matrix.VectorElementI;
import drasys.or.matrix.VectorI;
import drasys.or.util.Array;
import java.util.Enumeration;

public class CompressedColumnMatrix
extends CompressedMatrix {
    int[] _columnSize = null;
    int[] _columnBegin = null;
    int[] _rowIndex = null;
    int[] _columnIndex = null;
    int[] _rowEnd = null;
    int[] _valueIndex = null;

    public CompressedColumnMatrix(int n, int n2, int n3) {
        this(n, n2, n3, n2 * (1 + n3));
    }

    public CompressedColumnMatrix(int n, int n2, int n3, int n4) {
        this._sizeOfRows = n;
        this._fillInSpace = n3;
        this._sizeOfColumns = 0;
        this.resizeColumns(n2);
        this.resizeElements(n4);
    }

    public CompressedColumnMatrix(MatrixI matrixI, int n) {
        this._sizeOfRows = matrixI.sizeOfRows();
        this._sizeOfColumns = matrixI.sizeOfColumns();
        this._sizeOfElements = matrixI.sizeOfElements();
        this._fillInSpace = n;
        this.resizeColumns(this._sizeOfColumns);
        this.resizeElements(this._sizeOfElements + this._sizeOfColumns * n);
        int n2 = 0;
        int n3 = 0;
        while (n3 < this._sizeOfColumns) {
            this._columnBegin[n3] = n2;
            Enumeration enumeration = matrixI.columnElements(n3);
            while (enumeration.hasMoreElements()) {
                MatrixElementI matrixElementI = (MatrixElementI)enumeration.nextElement();
                int n4 = matrixElementI.getRowIndex();
                double d = matrixElementI.getValue();
                int n5 = n3;
                this._columnSize[n5] = this._columnSize[n5] + 1;
                this._values[n2] = d;
                this._rowIndex[n2++] = n4;
            }
            n2 += this._fillInSpace;
            ++n3;
        }
    }

    public CompressedColumnMatrix(VectorI vectorI, int n) {
        this._sizeOfRows = vectorI.size();
        this._sizeOfColumns = vectorI.size();
        this._sizeOfElements = vectorI.size();
        this._fillInSpace = n;
        this.resizeColumns(this._sizeOfColumns);
        this.resizeElements(this._sizeOfElements + this._sizeOfColumns * n);
        int n2 = 0;
        int n3 = 0;
        while (n3 < this._sizeOfColumns) {
            double d = vectorI.elementAt(n3);
            int n4 = n3;
            this._columnSize[n4] = this._columnSize[n4] + 1;
            this._values[n2] = d;
            this._rowIndex[n2++] = n3++;
        }
        n2 += this._fillInSpace;
    }

    public CompressedColumnMatrix(double[][] dArray, int n) {
        super(dArray);
        this._fillInSpace = n;
        this._sizeOfRows = dArray.length;
        this.resizeColumns(this._sizeOfColumns);
        this.resizeElements(this._sizeOfElements + this._sizeOfColumns * n);
        int n2 = 0;
        int n3 = 0;
        while (n3 < this._sizeOfColumns) {
            this._columnBegin[n3] = n2;
            int n4 = 0;
            while (n4 < dArray.length) {
                double[] dArray2 = dArray[n4];
                if (dArray2 != null && dArray2.length > n3) {
                    int n5 = n3;
                    this._columnSize[n5] = this._columnSize[n5] + 1;
                    this._values[n2] = dArray2[n3];
                    this._rowIndex[n2++] = n4;
                }
                ++n4;
            }
            n2 += this._fillInSpace;
            ++n3;
        }
    }

    public CompressedColumnMatrix(double[][] dArray, int n, double d) {
        super(dArray, d);
        this._fillInSpace = n;
        this._sizeOfRows = dArray.length;
        this.resizeColumns(this._sizeOfColumns);
        this.resizeElements(this._sizeOfElements + this._sizeOfColumns * n);
        int n2 = 0;
        int n3 = 0;
        while (n3 < this._sizeOfColumns) {
            this._columnBegin[n3] = n2;
            int n4 = 0;
            while (n4 < dArray.length) {
                double d2;
                double[] dArray2 = dArray[n4];
                if (dArray2 != null && dArray2.length > n3 && !this.equals(d2 = dArray2[n3], 0.0)) {
                    int n5 = n3;
                    this._columnSize[n5] = this._columnSize[n5] + 1;
                    this._values[n2] = d2;
                    this._rowIndex[n2++] = n4;
                }
                ++n4;
            }
            n2 += this._fillInSpace;
            ++n3;
        }
    }

    public void addColumn(VectorI vectorI) {
        int n = this._sizeOfColumns;
        this.setSize(this._sizeOfRows, this._sizeOfColumns + 1);
        if (vectorI == null) {
            return;
        }
        Enumeration enumeration = vectorI.elements();
        while (enumeration.hasMoreElements()) {
            VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
            this.setElementAt(vectorElementI.getIndex(), n, vectorElementI.getValue());
        }
    }

    public void addRow(VectorI vectorI) {
        int n = this._sizeOfColumns;
        this.setSize(this._sizeOfRows + 1, this._sizeOfColumns);
        if (vectorI == null) {
            return;
        }
        Enumeration enumeration = vectorI.elements();
        while (enumeration.hasMoreElements()) {
            VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
            this.setElementAt(n, vectorElementI.getIndex(), vectorElementI.getValue());
        }
    }

    public void buildRowIndex() {
        int n;
        int n2;
        this._columnIndex = new int[this._sizeOfElements];
        this._rowEnd = new int[this._sizeOfColumns];
        this._valueIndex = new int[this._sizeOfElements];
        int[] nArray = new int[this._sizeOfRows];
        int n3 = 0;
        while (n3 < this._sizeOfColumns) {
            n2 = this._columnBegin[n3];
            n = this._columnSize[n3];
            while (n > 0) {
                int n4 = this._rowIndex[n2];
                nArray[n4] = nArray[n4] + 1;
                --n;
                ++n2;
            }
            ++n3;
        }
        n2 = 0;
        n = 0;
        while (n < this._sizeOfRows) {
            this._rowEnd[n] = n2 += nArray[n];
            ++n;
        }
        Array.copy(this._sizeOfRows, nArray, 0, 1, 0);
        int n5 = 0;
        while (n5 < this._sizeOfColumns) {
            int n6 = this._columnBegin[n5];
            int n7 = this._columnSize[n5];
            while (n7 > 0) {
                int n8 = this._rowIndex[n6];
                int n9 = (n8 == 0 ? 0 : this._rowEnd[n8 - 1]) + nArray[n8];
                this._columnIndex[n9] = n5;
                this._valueIndex[n9] = n6++;
                int n10 = n8;
                nArray[n10] = nArray[n10] + 1;
                --n7;
            }
            ++n5;
        }
    }

    public int capacityOfColumns() {
        return this._columnBegin.length;
    }

    public int capacityOfRows() {
        return Integer.MAX_VALUE;
    }

    public Enumeration columnElements(int n) {
        if (n < 0 || n >= this._sizeOfColumns) {
            throw new IndexOutOfBoundsException("Column=" + n + ", sizeOfColumns=" + this._sizeOfColumns);
        }
        return new EnumCol(n);
    }

    public void deleteRowIndex() {
        this._columnIndex = null;
        this._rowEnd = null;
        this._valueIndex = null;
    }

    public double elementAt(int n, int n2) {
        if (n < 0 || n >= this._sizeOfRows) {
            throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._sizeOfRows);
        }
        if (n2 < 0 || n2 >= this._sizeOfColumns) {
            throw new IndexOutOfBoundsException("Column=" + n2 + ", sizeOfColumns=" + this._sizeOfColumns);
        }
        int n3 = Array.find(this._columnSize[n2], this._rowIndex, this._columnBegin[n2], 1, n, n);
        return n3 == -1 ? 0.0 : this._values[n3];
    }

    public Enumeration elements() {
        return new Enum();
    }

    public double[][] getArray() {
        double[][] dArray = new double[this.sizeOfRows()][this.sizeOfColumns()];
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            MatrixElementI matrixElementI = (MatrixElementI)enumeration.nextElement();
            dArray[matrixElementI.getRowIndex()][matrixElementI.getColumnIndex()] = matrixElementI.getValue();
        }
        return dArray;
    }

    public int[] getColumnBeginArray() {
        return this._columnBegin;
    }

    public int[] getColumnIndexArray() {
        return this._columnIndex;
    }

    public int[] getColumnSizeArray() {
        return this._columnSize;
    }

    public int[] getRowEndArray() {
        return this._rowEnd;
    }

    public int[] getRowIndexArray() {
        return this._rowIndex;
    }

    public int[] getValueIndexArray() {
        return this._valueIndex;
    }

    private void insert(int n, int n2, double d) {
        int n3 = this._columnBegin[n2] + this._columnSize[n2];
        if (n2 == this._sizeOfColumns - 1) {
            if (this._sizeOfElements >= this._values.length) {
                Array.resize(2 * this._values.length, this._values);
            }
        } else if (n3 >= this._columnBegin[n2 + 1]) {
            int n4 = 10 + this._sizeOfElements + this._sizeOfColumns * this._fillInSpace;
            n4 = Math.max(n4, this._values.length);
            int[] nArray = new int[n4];
            double[] dArray = new double[n4];
            int n5 = 0;
            int n6 = 0;
            while (n6 < this._sizeOfColumns) {
                int n7 = this._columnBegin[n6];
                this._columnBegin[n6] = n5;
                int n8 = this._columnSize[n6];
                Array.copy(n8, dArray, n5, 1, this._values, n7, 1);
                Array.copy(n8, nArray, n5, 1, this._rowIndex, n7, 1);
                if (n6 == n2) {
                    ++n5;
                }
                n5 += n8 + this._fillInSpace;
                ++n6;
            }
            this._values = dArray;
            this._rowIndex = nArray;
        }
        this._values[n3] = d;
        this._rowIndex[n3] = n;
        int n9 = n2;
        this._columnSize[n9] = this._columnSize[n9] + 1;
        ++this._sizeOfElements;
        if (this._rowEnd != null) {
            this.deleteRowIndex();
        }
    }

    public boolean isColumnMajor() {
        return true;
    }

    public boolean isNull(int n, int n2) {
        if (n < 0 || n >= this._sizeOfRows) {
            throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._sizeOfRows);
        }
        if (n2 < 0 || n2 >= this._sizeOfColumns) {
            throw new IndexOutOfBoundsException("Column=" + n2 + ", sizeOfColumns=" + this._sizeOfColumns);
        }
        int n3 = Array.find(this._columnSize[n2], this._rowIndex, this._columnBegin[n2], 1, n, n);
        return n3 == -1;
    }

    public boolean isRowMajor() {
        return false;
    }

    private void resizeColumns(int n) {
        this._columnSize = Array.resize(n, this._columnSize);
        this._columnBegin = Array.resize(n, this._columnBegin);
    }

    private void resizeElements(int n) {
        this._values = Array.resize(n, this._values);
        this._rowIndex = Array.resize(n, this._rowIndex);
    }

    public Enumeration rowElements(int n) {
        if (n < 0 || n >= this._sizeOfRows) {
            throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._sizeOfRows);
        }
        if (this._rowEnd == null) {
            this.buildRowIndex();
        }
        return new EnumRow(n);
    }

    public void setCapacity(int n, int n2) {
        if (n2 > this.capacityOfColumns()) {
            this.resizeColumns(n2);
            this.resizeElements(this._sizeOfElements + n2 * this._fillInSpace);
        }
    }

    public void setElementAt(int n, int n2, double d) {
        if (n < 0 || n >= this._sizeOfRows) {
            throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._sizeOfRows);
        }
        if (n2 < 0 || n2 >= this._sizeOfColumns) {
            throw new IndexOutOfBoundsException("Column=" + n2 + ", sizeOfColumns=" + this._sizeOfColumns);
        }
        int n3 = Array.find(this._columnSize[n2], this._rowIndex, this._columnBegin[n2], 1, n, n);
        if (n3 != -1) {
            this._values[n3] = d;
        } else {
            this.insert(n, n2, d);
        }
    }

    public void setSize(int n, int n2) {
        if (n < this._sizeOfRows || n2 < this._sizeOfColumns) {
            this._sizeOfRows = 0;
            this._sizeOfColumns = 0;
        }
        if (n2 > this.capacityOfColumns()) {
            this.setCapacity(n, n2);
        }
        if (n2 > this._sizeOfColumns) {
            int n3 = n2 - this._sizeOfColumns;
            Array.copy(n3, this._columnSize, this._sizeOfColumns, 1, 0);
            int n4 = this._sizeOfColumns == 0 ? 0 : this._columnBegin[this._sizeOfColumns - 1] + this._columnSize[this._sizeOfColumns - 1] + this._fillInSpace;
            int n5 = this._sizeOfColumns;
            while (n5 < n2) {
                this._columnBegin[n5] = n4;
                n4 += this._fillInSpace;
                ++n5;
            }
            this._sizeOfColumns = n2;
        }
        this._sizeOfRows = Math.max(this._sizeOfRows, n);
    }

    public int sizeOfElements() {
        return this._sizeOfElements;
    }

    public double sum(int n, int n2, int n3, int n4) {
        double d = 0.0;
        while (n3 < n4) {
            int n5 = this._columnBegin[n3];
            int n6 = this._columnSize[n3];
            while (n6 > 0) {
                int n7 = this._rowIndex[n5];
                if (n7 >= n && n7 < n2) {
                    d += this._values[n5];
                }
                --n6;
                ++n5;
            }
            ++n3;
        }
        return d;
    }

    public double sumOfSquaredDifferences(int n, int n2, int n3, int n4, double d) {
        int n5 = 0;
        double d2 = 0.0;
        int n6 = (n2 - n) * (n4 - n3);
        while (n3 < n4) {
            int n7 = this._columnBegin[n3];
            int n8 = this._columnSize[n3];
            while (n8 > 0) {
                int n9 = this._rowIndex[n7];
                if (n9 >= n && n9 < n2) {
                    double d3 = this._values[n7] - d;
                    d2 += d3 * d3;
                    ++n5;
                }
                --n8;
                ++n7;
            }
            ++n3;
        }
        if (d != 0.0) {
            d2 += (double)(n6 - n5) * d * d;
        }
        return d2;
    }

    public double sumOfSquares(int n, int n2, int n3, int n4) {
        double d = 0.0;
        while (n3 < n4) {
            int n5 = this._columnBegin[n3];
            int n6 = this._columnSize[n3];
            while (n6 > 0) {
                int n7 = this._rowIndex[n5];
                if (n7 >= n && n7 < n2) {
                    double d2 = this._values[n5];
                    d += d2 * d2;
                }
                --n6;
                ++n5;
            }
            ++n3;
        }
        return d;
    }

    private class Enum
    implements Enumeration,
    MatrixElementI {
        int _row = 0;
        int _beg = 0;
        int _cnt = 0;
        int _column = 0;
        int _mrow;
        int _mcol;
        int _mk;
        double _mvalue;

        public Enum() {
            while (this._column < CompressedColumnMatrix.this._sizeOfColumns && CompressedColumnMatrix.this._columnSize[this._column] < 1) {
                ++this._column;
            }
            if (this._column < CompressedColumnMatrix.this._sizeOfColumns) {
                this._cnt = CompressedColumnMatrix.this._columnSize[this._column];
                this._beg = CompressedColumnMatrix.this._columnBegin[this._column];
            }
        }

        public int getColumnIndex() {
            return this._mcol;
        }

        public int getRowIndex() {
            return this._mrow;
        }

        public double getValue() {
            return this._mvalue;
        }

        public boolean hasMoreElements() {
            return this._column < CompressedColumnMatrix.this._sizeOfColumns;
        }

        public Object nextElement() {
            if (this._column >= CompressedColumnMatrix.this._sizeOfColumns) {
                return null;
            }
            this._mk = this._beg;
            this._mcol = this._column++;
            this._mrow = CompressedColumnMatrix.this._rowIndex[this._beg];
            this._mvalue = CompressedColumnMatrix.this._values[this._beg++];
            if (--this._cnt <= 0) {
                while (this._column < CompressedColumnMatrix.this._sizeOfColumns && CompressedColumnMatrix.this._columnSize[this._column] < 1) {
                    ++this._column;
                }
                if (this._column < CompressedColumnMatrix.this._sizeOfColumns) {
                    this._cnt = CompressedColumnMatrix.this._columnSize[this._column];
                    this._beg = CompressedColumnMatrix.this._columnBegin[this._column];
                }
            }
            return this;
        }

        public void setValue(double d) {
            CompressedColumnMatrix.this._values[this._mk] = this._mvalue = d;
        }
    }

    private class EnumCol
    implements Enumeration,
    MatrixElementI {
        int _beg = 0;
        int _end = 0;
        int _mrow;
        int _mcol;
        int _mk;
        double _mvalue;

        public EnumCol(int n) {
            this._mcol = n;
            this._beg = CompressedColumnMatrix.this._columnBegin[n];
            this._end = this._beg + CompressedColumnMatrix.this._columnSize[n];
        }

        public int getColumnIndex() {
            return this._mcol;
        }

        public int getRowIndex() {
            return this._mrow;
        }

        public double getValue() {
            return this._mvalue;
        }

        public boolean hasMoreElements() {
            return this._beg < this._end;
        }

        public Object nextElement() {
            if (this._beg >= this._end) {
                return null;
            }
            this._mk = this._beg;
            this._mrow = CompressedColumnMatrix.this._rowIndex[this._beg];
            this._mvalue = CompressedColumnMatrix.this._values[this._beg];
            ++this._beg;
            return this;
        }

        public void setValue(double d) {
            CompressedColumnMatrix.this._values[this._mk] = this._mvalue = d;
        }
    }

    private class EnumRow
    implements Enumeration,
    MatrixElementI {
        int _beg = 0;
        int _end = 0;
        int _mrow;
        int _mcol;
        int _mk;
        double _mvalue;

        public EnumRow(int n) {
            this._mrow = n;
            this._beg = n == 0 ? 0 : CompressedColumnMatrix.this._rowEnd[n - 1];
            this._end = CompressedColumnMatrix.this._rowEnd[n];
        }

        public int getColumnIndex() {
            return this._mcol;
        }

        public int getRowIndex() {
            return this._mrow;
        }

        public double getValue() {
            return this._mvalue;
        }

        public boolean hasMoreElements() {
            return this._beg < this._end;
        }

        public Object nextElement() {
            if (this._beg >= this._end) {
                return null;
            }
            this._mk = CompressedColumnMatrix.this._valueIndex[this._beg];
            this._mrow = CompressedColumnMatrix.this._columnIndex[this._beg];
            this._mvalue = CompressedColumnMatrix.this._values[this._mk];
            ++this._beg;
            return this;
        }

        public void setValue(double d) {
            CompressedColumnMatrix.this._values[this._mk] = this._mvalue = d;
        }
    }
}

