/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.matrix.complex;

import drasys.or.Complex;
import drasys.or.ComplexI;
import drasys.or.matrix.MatrixError;
import drasys.or.matrix.complex.ContiguousMatrixI;
import drasys.or.matrix.complex.ContiguousVector;
import drasys.or.matrix.complex.ContiguousVectorI;
import drasys.or.matrix.complex.Matrix;
import drasys.or.matrix.complex.MatrixElementI;
import drasys.or.matrix.complex.MatrixI;
import drasys.or.matrix.complex.SizableMatrixI;
import drasys.or.matrix.complex.VectorElementI;
import drasys.or.matrix.complex.VectorI;
import drasys.or.util.Array;
import drasys.or.util.ComplexArray;
import java.util.Enumeration;

public abstract class ContiguousMatrix
extends Matrix
implements ContiguousMatrixI,
SizableMatrixI {
    int _sizeOfRows = 0;
    int _sizeOfColumns = 0;
    int _capacityOfRows = 0;
    int _capacityOfColumns = 0;
    double[] _values = null;

    public ContiguousMatrix(int n, int n2, int n3, int n4) {
        this._sizeOfRows = n;
        this._sizeOfColumns = n2;
        this._capacityOfRows = Math.max(n, n3);
        this._capacityOfColumns = Math.max(n2, n4);
        this._values = ComplexArray.resize(this._capacityOfRows * this._capacityOfColumns, this._values);
    }

    public ContiguousMatrix(MatrixI matrixI) {
        this._capacityOfRows = this._sizeOfRows = matrixI.sizeOfRows();
        this._capacityOfColumns = this._sizeOfColumns = matrixI.sizeOfColumns();
        this._values = ComplexArray.resize(this._capacityOfRows * this._capacityOfColumns, this._values);
    }

    public ContiguousMatrix(VectorI vectorI) {
        this._capacityOfRows = this._sizeOfRows = vectorI.size();
        this._capacityOfColumns = this._sizeOfColumns = vectorI.size();
        this._values = ComplexArray.resize(this._capacityOfRows * this._capacityOfColumns, this._values);
        Enumeration enumeration = vectorI.elements();
        while (enumeration.hasMoreElements()) {
            VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
            this.setElementAt(vectorElementI.getIndex(), vectorElementI.getIndex(), vectorElementI.getValue());
        }
    }

    public ContiguousMatrix(double[][] dArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < dArray.length) {
            double[] dArray2 = dArray[n2];
            if (dArray2 != null && dArray2.length > n) {
                n = dArray2.length;
            }
            ++n2;
        }
        this._capacityOfRows = this._sizeOfRows = dArray.length;
        this._capacityOfColumns = this._sizeOfColumns = n / 2;
        this._values = ComplexArray.resize(this._capacityOfRows * this._capacityOfColumns, this._values);
    }

    public ContiguousMatrix(double[][] dArray, double[][] dArray2) {
        double[] dArray3;
        int n;
        int n2 = 0;
        if (dArray == null && dArray2 == null) {
            throw new MatrixError("Both arrays can't be null.");
        }
        if (dArray != null && dArray2 != null && dArray.length != dArray2.length) {
            throw new MatrixError("The real and imag arrays must be the same number of rows: " + dArray.length + ", " + dArray2.length);
        }
        if (dArray != null) {
            n = 0;
            while (n < dArray.length) {
                dArray3 = dArray[n];
                if (dArray3 != null && dArray3.length > n2) {
                    n2 = dArray3.length;
                }
                ++n;
            }
        }
        if (dArray2 != null) {
            n = 0;
            while (n < dArray2.length) {
                dArray3 = dArray2[n];
                if (dArray3 != null && dArray3.length > n2) {
                    n2 = dArray3.length;
                }
                ++n;
            }
        }
        this._sizeOfRows = dArray != null ? dArray.length : dArray2.length;
        this._capacityOfRows = this._sizeOfRows;
        this._capacityOfColumns = this._sizeOfColumns = n2;
        this._values = ComplexArray.resize(this._capacityOfRows * this._capacityOfColumns, this._values);
    }

    public abstract void addColumn(VectorI var1);

    public abstract void addRow(VectorI var1);

    public int capacityOfColumns() {
        return this._capacityOfColumns;
    }

    public int capacityOfRows() {
        return this._capacityOfRows;
    }

    public ContiguousVectorI columnVector(int n) {
        return new ContiguousVector.Sub(this._values, this.sizeOfRows(), this.getOffset(0, n), this.getRowIncrement());
    }

    public ContiguousVectorI diagonalVector() {
        return new ContiguousVector.Sub(this._values, this.sizeOfRows(), this.getOffset(0, 0), this.getRowIncrement() + this.getColumnIncrement());
    }

    public abstract int getColumnIncrement();

    public abstract int getOffset(int var1, int var2);

    public abstract int getRowIncrement();

    public double[] getValueArray() {
        return this._values;
    }

    public boolean isNull(int n, int n2) {
        if (n < 0 || n >= this._sizeOfRows) {
            throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._sizeOfRows);
        }
        if (n2 < 0 || n2 >= this._sizeOfColumns) {
            throw new IndexOutOfBoundsException("Column=" + n2 + ", sizeOfColumns=" + this._sizeOfColumns);
        }
        return false;
    }

    public ContiguousVectorI rowVector(int n) {
        return new ContiguousVector.Sub(this._values, this.sizeOfColumns(), this.getOffset(n, 0), this.getColumnIncrement());
    }

    public abstract void setCapacity(int var1, int var2);

    public void setElements(ComplexI complexI) {
        ComplexArray.copy(this._values.length / 2, this._values, 0, 1, complexI);
    }

    public abstract void setSize(int var1, int var2);

    public int sizeOfColumns() {
        return this._sizeOfColumns;
    }

    public int sizeOfElements() {
        return this._sizeOfRows * this._sizeOfColumns;
    }

    public int sizeOfRows() {
        return this._sizeOfRows;
    }

    public Complex sum(int n, int n2, int n3, int n4) {
        int n5 = this.getOffset(n, n3);
        Complex complex = new Complex();
        int n6 = n2 - n;
        int n7 = n4 - n3;
        if (n6 < 1 || n7 < 1) {
            return complex;
        }
        int n8 = this.getRowIncrement();
        int n9 = this.getColumnIncrement();
        Complex complex2 = new Complex();
        if (n9 < n8) {
            int n10 = 0;
            while (n10 < n6) {
                complex.add(ComplexArray.sum(n7, this._values, n5, n9, complex2));
                ++n10;
                n5 += n8;
            }
        } else {
            int n11 = 0;
            while (n11 < n7) {
                complex.add(ComplexArray.sum(n6, this._values, n5, n8, complex2));
                ++n11;
                n5 += n9;
            }
        }
        return complex;
    }

    public Complex sumOfSquaredDifferences(int n, int n2, int n3, int n4, ComplexI complexI) {
        int n5 = this.getOffset(n, n3);
        Complex complex = new Complex();
        int n6 = n2 - n;
        int n7 = n4 - n3;
        if (n6 < 1 || n7 < 1) {
            return complex;
        }
        int n8 = this.getRowIncrement();
        int n9 = this.getColumnIncrement();
        Complex complex2 = new Complex();
        if (n9 < n8) {
            int n10 = 0;
            while (n10 < n6) {
                complex.add(ComplexArray.sumOfSquares(n7, this._values, n5, n9, complex2));
                ++n10;
                n5 += n8;
            }
        } else {
            int n11 = 0;
            while (n11 < n7) {
                complex.add(ComplexArray.sumOfSquaredDifferences(n6, this._values, n5, n8, complexI, complex2));
                ++n11;
                n5 += n9;
            }
        }
        return complex;
    }

    public Complex sumOfSquares(int n, int n2, int n3, int n4) {
        int n5 = this.getOffset(n, n3);
        Complex complex = new Complex();
        int n6 = n2 - n;
        int n7 = n4 - n3;
        if (n6 < 1 || n7 < 1) {
            return complex;
        }
        int n8 = this.getRowIncrement();
        int n9 = this.getColumnIncrement();
        Complex complex2 = new Complex();
        if (n9 < n8) {
            int n10 = 0;
            while (n10 < n6) {
                complex.add(ComplexArray.sumOfSquares(n7, this._values, n5, n9, complex2));
                ++n10;
                n5 += n8;
            }
        } else {
            int n11 = 0;
            while (n11 < n7) {
                complex.add(ComplexArray.sumOfSquares(n6, this._values, n5, n8, complex2));
                ++n11;
                n5 += n9;
            }
        }
        return complex;
    }

    static class Enum
    implements ComplexI,
    Enumeration,
    MatrixElementI {
        int _k;
        int _siz1;
        int _siz2;
        int _beg1;
        int _beg2;
        int _inc1;
        int _inc2;
        int _cnt1 = 0;
        int _cnt2 = 0;
        boolean _rowMajor;
        double[] _values;
        int _mrow;
        int _mcol;
        int _mcoef;
        double _mreal;
        double _mimag;

        public Enum(double[] dArray, int n, int n2, int n3, int n4, int n5) {
            this._beg1 = this._beg2 = n3;
            this._values = dArray;
            if (n4 < n5) {
                this._rowMajor = true;
                this._siz1 = n;
                this._siz2 = n2;
                this._inc1 = n4;
                this._inc2 = n5;
            } else {
                this._rowMajor = false;
                this._siz1 = n2;
                this._siz2 = n;
                this._inc1 = n5;
                this._inc2 = n4;
            }
        }

        public int getColumnIndex() {
            return this._mcol;
        }

        public double getImag() {
            return this._mimag;
        }

        public double getReal() {
            return this._mreal;
        }

        public int getRowIndex() {
            return this._mrow;
        }

        public ComplexI getValue() {
            return this;
        }

        public boolean hasMoreElements() {
            return this._cnt2 < this._siz2;
        }

        public Object nextElement() {
            if (this._cnt2 >= this._siz2) {
                return null;
            }
            if (this._rowMajor) {
                this._mrow = this._cnt1++;
                this._mcol = this._cnt2;
            } else {
                this._mrow = this._cnt2;
                this._mcol = this._cnt1++;
            }
            this._mcoef = 2 * this._beg1;
            this._mreal = this._values[this._mcoef];
            this._mimag = this._values[this._mcoef + 1];
            if (++this._cnt1 >= this._siz1) {
                ++this._cnt2;
                this._cnt1 = 0;
                this._beg1 = this._beg2 += this._inc2;
            } else {
                ++this._cnt1;
                this._beg1 += this._inc1;
            }
            return this;
        }

        public void setValue(ComplexI complexI) {
            this._values[this._mcoef] = this._mreal = complexI.getReal();
            this._values[this._mcoef + 1] = this._mimag = complexI.getImag();
        }
    }

    public static class Sub
    extends Matrix
    implements ContiguousMatrixI {
        int _m;
        int _n;
        int _beg;
        int _inci;
        int _incj;
        double[] _values;

        public Sub(double[] dArray, int n, int n2, int n3, int n4, int n5) {
            this._values = dArray;
            this._m = n;
            this._n = n2;
            this._beg = n3;
            this._inci = n4;
            this._incj = n5;
        }

        public Enumeration columnElements(int n) {
            if (n < 0 || n >= this._n) {
                throw new IndexOutOfBoundsException("Column=" + n + ", sizeOfColumns=" + this._n);
            }
            return this.submatrix(0, this.sizeOfRows(), n, n + 1).elements();
        }

        public ContiguousVectorI columnVector(int n) {
            return new ContiguousVector.Sub(this._values, this.sizeOfRows(), this.getOffset(0, n), this.getRowIncrement());
        }

        public ContiguousVectorI diagonalVector() {
            return new ContiguousVector.Sub(this._values, this.sizeOfRows(), this.getOffset(0, 0), this.getRowIncrement() + this.getColumnIncrement());
        }

        public Complex elementAt(int n, int n2) {
            if (n < 0 || n >= this._m) {
                throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._m);
            }
            if (n2 < 0 || n2 >= this._n) {
                throw new IndexOutOfBoundsException("Column=" + n2 + ", sizeOfColumns=" + this._n);
            }
            int n3 = 2 * this.getOffset(n, n2);
            return new Complex(this._values[n3], this._values[n3 + 1]);
        }

        public Complex elementAt(int n, int n2, Complex complex) {
            if (n < 0 || n >= this._m) {
                throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._m);
            }
            if (n2 < 0 || n2 >= this._n) {
                throw new IndexOutOfBoundsException("Column=" + n2 + ", sizeOfColumns=" + this._n);
            }
            int n3 = 2 * this.getOffset(n, n2);
            if (complex == null) {
                return new Complex(this._values[n3], this._values[n3 + 1]);
            }
            complex.real = this._values[n3];
            complex.imag = this._values[n3 + 1];
            return complex;
        }

        public Enumeration elements() {
            return new Enum(this._values, this.sizeOfRows(), this.sizeOfColumns(), this._beg, this.getRowIncrement(), this.getColumnIncrement());
        }

        public double[][] getArray() {
            double[][] dArray = new double[this._m][this._n];
            int n = 0;
            while (n < dArray.length) {
                double[] dArray2 = dArray[n];
                if (dArray2 != null) {
                    Array.copy(dArray2.length, dArray2, 0, 1, this._values, this.getOffset(n, 0), this._inci);
                }
                ++n;
            }
            return dArray;
        }

        public int getColumnIncrement() {
            return this._incj;
        }

        public int getOffset(int n, int n2) {
            if (n < 0 || n >= this._m) {
                throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._m);
            }
            if (n2 < 0 || n2 >= this._n) {
                throw new IndexOutOfBoundsException("Column=" + n2 + ", sizeOfColumns=" + this._n);
            }
            return n * this._inci + n2 * this._incj;
        }

        public int getRowIncrement() {
            return this._inci;
        }

        public double[] getValueArray() {
            return this._values;
        }

        public boolean isColumnMajor() {
            return this._incj < this._inci;
        }

        public boolean isNull(int n, int n2) {
            return false;
        }

        public boolean isRowMajor() {
            return this._inci < this._incj;
        }

        public Enumeration rowElements(int n) {
            if (n < 0 || n >= this._m) {
                throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._m);
            }
            return this.submatrix(n, n + 1, 0, this._n).elements();
        }

        public ContiguousVectorI rowVector(int n) {
            return new ContiguousVector.Sub(this._values, this.sizeOfColumns(), this.getOffset(n, 0), this.getColumnIncrement());
        }

        public void setElementAt(int n, int n2, ComplexI complexI) {
            if (n < 0 || n >= this._m) {
                throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._m);
            }
            if (n2 < 0 || n2 >= this._n) {
                throw new IndexOutOfBoundsException("Column=" + n2 + ", sizeOfColumns=" + this._n);
            }
            int n3 = 2 * this.getOffset(n, n2);
            this._values[n3] = complexI.getReal();
            this._values[n3 + 1] = complexI.getImag();
        }

        public void setElements(ComplexI complexI) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5 = this._beg;
            if (this._inci < this._incj) {
                n4 = this._m;
                n3 = this._inci;
                n2 = this._incj;
                n = this._beg + this._n * this._incj;
            } else {
                n4 = this._n;
                n3 = this._incj;
                n2 = this._inci;
                n = this._beg + this._m * this._inci;
            }
            while (n5 < n) {
                ComplexArray.copy(n4, this._values, n5, n3, complexI);
                n5 += n2;
            }
        }

        public int sizeOfColumns() {
            return this._n;
        }

        public int sizeOfElements() {
            return this._m * this._n;
        }

        public int sizeOfRows() {
            return this._m;
        }

        public ContiguousMatrixI submatrix(int n, int n2) {
            return new Sub(this._values, this.sizeOfRows() - n, this.sizeOfColumns() - n2, this.getOffset(n, n2), this.getRowIncrement(), this.getColumnIncrement());
        }

        public ContiguousMatrixI submatrix(int n, int n2, int n3, int n4) {
            return new Sub(this._values, n2 - n, n4 - n3, this.getOffset(n, n3), this.getRowIncrement(), this.getColumnIncrement());
        }

        public Complex sum(int n, int n2, int n3, int n4) {
            int n5 = this.getOffset(n, n3);
            Complex complex = new Complex();
            int n6 = n2 - n;
            int n7 = n4 - n3;
            if (n6 < 1 || n7 < 1) {
                return complex;
            }
            Complex complex2 = new Complex();
            if (this._incj < this._inci) {
                int n8 = 0;
                while (n8 < n6) {
                    complex.add(ComplexArray.sum(n7, this._values, n5, this._incj, complex2));
                    ++n8;
                    n5 += this._inci;
                }
            } else {
                int n9 = 0;
                while (n9 < n7) {
                    complex.add(ComplexArray.sum(n6, this._values, n5, this._inci, complex2));
                    ++n9;
                    n5 += this._incj;
                }
            }
            return complex;
        }

        public Complex sumOfSquaredDifferences(int n, int n2, int n3, int n4, ComplexI complexI) {
            int n5 = this.getOffset(n, n3);
            Complex complex = new Complex();
            int n6 = n2 - n;
            int n7 = n4 - n3;
            if (n6 < 1 || n7 < 1) {
                return complex;
            }
            Complex complex2 = new Complex();
            if (this._incj < this._inci) {
                int n8 = 0;
                while (n8 < n6) {
                    complex.add(ComplexArray.sumOfSquares(n7, this._values, n5, this._incj, complex2));
                    ++n8;
                    n5 += this._inci;
                }
            } else {
                int n9 = 0;
                while (n9 < n7) {
                    complex.add(ComplexArray.sumOfSquaredDifferences(n6, this._values, n5, this._inci, complexI, complex2));
                    ++n9;
                    n5 += this._incj;
                }
            }
            return complex;
        }

        public Complex sumOfSquares(int n, int n2, int n3, int n4) {
            int n5 = this.getOffset(n, n3);
            Complex complex = new Complex();
            int n6 = n2 - n;
            int n7 = n4 - n3;
            if (n6 < 1 || n7 < 1) {
                return complex;
            }
            Complex complex2 = new Complex();
            if (this._incj < this._inci) {
                int n8 = 0;
                while (n8 < n6) {
                    complex.add(ComplexArray.sumOfSquares(n7, this._values, n5, this._incj, complex2));
                    ++n8;
                    n5 += this._inci;
                }
            } else {
                int n9 = 0;
                while (n9 < n7) {
                    complex.add(ComplexArray.sumOfSquares(n6, this._values, n5, this._inci, complex2));
                    ++n9;
                    n5 += this._incj;
                }
            }
            return complex;
        }
    }
}

