/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.prob;

import drasys.or.Functions;
import drasys.or.nonlinear.FunctionI;
import drasys.or.prob.ProbError;

public class IncompleteGamma
extends Functions
implements FunctionI {
    int _maxIt = 150;
    double _epsilon = 1.0E-6;
    double _a;
    double _1a;
    double _a1;
    double _ainv;
    double _alng;

    public IncompleteGamma(double d) {
        if (d <= 0.0) {
            throw new ProbError("'a' must be greater than '0.0'");
        }
        this._a = d;
        this._a1 = d + 1.0;
        this._1a = 1.0 - d;
        this._ainv = 1.0 / d;
        this._alng = this.lnGamma(d);
    }

    private double f1(double d) {
        if (d == 0.0) {
            return 0.0;
        }
        double d2 = Math.log(d);
        double d3 = this._a;
        double d4 = this._ainv;
        double d5 = this._ainv;
        int n = 1;
        while (n <= this._maxIt) {
            d4 += (d5 *= d / (d3 += 1.0));
            if (Math.abs(d5) < Math.abs(d4) * this._epsilon) {
                return d4 * Math.exp(-d + this._a * d2 - this._alng);
            }
            ++n;
        }
        throw new ProbError("Can't find igamma to within epsilon");
    }

    private double f2(double d) {
        double d2;
        if (d == 0.0) {
            return 1.0;
        }
        double d3 = Math.log(d);
        double d4 = d + this._1a;
        double d5 = Double.MAX_VALUE;
        double d6 = d2 = 1.0 / d4;
        int n = 1;
        while (n <= this._maxIt) {
            double d7 = (double)(-n) * ((double)n - this._a);
            d2 = 1.0 / (d7 * d2 + (d4 += 2.0));
            d5 = d4 + d7 / d5;
            double d8 = d2 * d5;
            d6 *= d8;
            if (Math.abs(d8 - 1.0) < this._epsilon) {
                return d6 * Math.exp(-d + this._a * d3 - this._alng);
            }
            ++n;
        }
        throw new ProbError("Can't find igamma to within epsilon");
    }

    public double function(double d) throws ProbError {
        if (d < 0.0) {
            throw new ProbError("'x' can't be less than '0'.");
        }
        if (d < this._a1) {
            return this.f1(d);
        }
        return 1.0 - this.f2(d);
    }

    public void setEpsilon(double d) {
        this._epsilon = d;
    }

    public void setMaxIterations(int n) {
        this._maxIt = n;
    }
}

