/*
 * Decompiled with CFR 0.152.
 */
package interfacing;

import interfacing.JobClassesTableModelListener;
import interfacing.MainFrame;
import interfacing.OurDefaultTableModel;
import interfacing.PropertiesJPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import mapping.data.JobClass;
import mapping.data.JobClassesTable;

public class JobClassesTableJPanel
extends JPanel
implements PropertyChangeListener,
ActionListener {
    private static final long serialVersionUID = -1314942526341209428L;
    private String[] columnNames = new String[]{"ID", "Execution Time", "Arrival Rate"};
    private MainFrame frame;
    private JTable jTable;
    private OurDefaultTableModel tableModel;
    private JobClassesTableModelListener jobClassesTableModelListener;
    private JScrollPane jTableScrollPane;
    private JSplitPane splitPane;
    private JScrollPane leftScrollPane;
    private JScrollPane righScrollPane;
    private JPanel jTableContainer;
    private JButton addButton;
    private JButton removeButton;
    private JPanel buttonsConatainers;
    private PropertiesJPanel propPanel;
    private JButton submitButton;
    private JPanel propPanelContainer;
    private JPanel filelocale;
    private JLabel filename;

    public JobClassesTable getJobClassesTable() {
        return this.frame.getMapper().getClassesTable();
    }

    public JobClassesTableJPanel(MainFrame frame) {
        this.frame = frame;
        this.filename = new JLabel("The file was loaded from: " + frame.getReadFile());
        this.leftScrollPane = new JScrollPane();
        this.righScrollPane = new JScrollPane();
        this.jTable = new JTable();
        this.jTableScrollPane = new JScrollPane();
        this.jTableContainer = new JPanel();
        this.setLayout(new BorderLayout());
        this.splitPane = new JSplitPane(1, this.leftScrollPane, this.righScrollPane);
        this.splitPane.setDividerLocation(400);
        this.filelocale = new JPanel();
        this.filelocale.add(this.filename);
        this.jobClassesTableModelListener = new JobClassesTableModelListener(this.getJobClassesTable());
        this.jTableContainer.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 0;
        gbConstraints.fill = 0;
        gbConstraints.anchor = 11;
        gbConstraints.gridheight = 1;
        gbConstraints.gridwidth = 1;
        this.jTableScrollPane.setViewportView(this.jTable);
        this.jTableContainer.add((Component)this.jTableScrollPane, gbConstraints);
        gbConstraints.gridy = 1;
        this.buttonsConatainers = new JPanel();
        this.addButton = new JButton("");
        this.addButton.setIcon(new ImageIcon("Icons/edit_add_22.png"));
        this.addButton.addActionListener(this);
        this.removeButton = new JButton("");
        this.removeButton.setIcon(new ImageIcon("Icons/edit_remove_22.png"));
        this.removeButton.addActionListener(this);
        this.buttonsConatainers.add(this.addButton);
        this.buttonsConatainers.add(this.removeButton);
        this.jTableContainer.add((Component)this.buttonsConatainers, gbConstraints);
        gbConstraints.gridy = 2;
        this.jTableContainer.add((Component)this.filelocale, gbConstraints);
        gbConstraints.weighty = 1.0;
        gbConstraints.fill = 1;
        gbConstraints.gridy = 3;
        this.jTableContainer.add(Box.createVerticalGlue(), gbConstraints);
        this.leftScrollPane.setViewportView(this.jTableContainer);
        this.leftScrollPane.setAlignmentY(0.0f);
        this.add(this.splitPane);
        this.jTable.setGridColor(Color.BLACK);
        this.buildPropretyJPanel();
        this.hidePropertyJPanel();
        this.fillJTable();
        int h = (1 + this.jTable.getModel().getRowCount()) * this.jTable.getRowHeight() + 100;
        this.setPreferredSize(new Dimension(500, h));
        this.splitPane.addPropertyChangeListener(this);
    }

    public void fillJTable() {
        this.tableModel = new OurDefaultTableModel(this.columnNames, 0);
        this.jTable.setModel(this.tableModel);
        int i = 0;
        while (i < this.getJobClassesTable().size()) {
            Object[] s = new String[]{String.valueOf(((JobClass)this.getJobClassesTable().get(i + 1)).getIndex()), String.valueOf(((JobClass)this.getJobClassesTable().get(i + 1)).getexecutionTime()), String.valueOf(((JobClass)this.getJobClassesTable().get(i + 1)).getArrivalRate())};
            this.tableModel.addRow(s);
            ++i;
        }
        this.jobClassesTableModelListener = new JobClassesTableModelListener(this.getJobClassesTable());
        this.tableModel.addTableModelListener(this.jobClassesTableModelListener);
    }

    public void printClasses() {
        this.getJobClassesTable().printAll();
    }

    public void buildPropretyJPanel() {
        String[] names = new String[]{"Execution Time", "Arrival"};
        this.propPanel = new PropertiesJPanel(names, null);
        this.submitButton = new JButton("Submit");
        this.submitButton.addActionListener(this);
        this.propPanelContainer = new JPanel();
        this.propPanelContainer.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 10;
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 0;
        this.propPanelContainer.add((Component)this.propPanel, gbConstraints);
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 1;
        this.propPanelContainer.add((Component)this.submitButton, gbConstraints);
        gbConstraints.weighty = 1.0;
        gbConstraints.fill = 1;
        gbConstraints.gridy = 2;
        this.propPanelContainer.add(Box.createVerticalGlue(), gbConstraints);
        gbConstraints.gridheight = 3;
        gbConstraints.weightx = 0.0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridx = 1;
        gbConstraints.gridy = 0;
        this.propPanelContainer.add(Box.createHorizontalGlue(), gbConstraints);
        this.righScrollPane.setViewportView(this.propPanelContainer);
        this.righScrollPane.setAlignmentY(0.0f);
        this.repaint();
    }

    public void showPropertyJPanel() {
        this.propPanel.clearFields();
        this.propPanelContainer.setVisible(true);
    }

    public void hidePropertyJPanel() {
        this.propPanelContainer.setVisible(false);
    }

    public void removeClass() {
        if (this.jTable.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "Please select a job class from the table.", "Error", 0);
            return;
        }
        this.getJobClassesTable().removeJobClass(this.jTable.getSelectedRow() + 1);
        this.fillJTable();
        this.reSizeJTable();
    }

    private void reSizeJTable() {
        if (this.jTable == null) {
            return;
        }
        int rowCount = 1 + this.jTable.getModel().getRowCount();
        int rowHeight = this.jTable.getRowHeight();
        int h = rowCount * rowHeight + 5;
        Dimension d = new Dimension(this.splitPane.getDividerLocation() - 10, h);
        this.jTable.setSize(d);
        this.jTableContainer.setPreferredSize(d);
        this.jTableScrollPane.setPreferredSize(d);
        this.setPreferredSize(new Dimension(500, d.height + 70));
    }

    public void repaint() {
        this.reSizeJTable();
        super.repaint();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addButton) {
            this.showPropertyJPanel();
        }
        if (e.getSource() == this.removeButton) {
            this.removeClass();
        }
        if (e.getSource() == this.submitButton) {
            try {
                this.getJobClassesTable().addJobClass(Double.parseDouble(this.propPanel.getValue(1)), Long.parseLong(this.propPanel.getValue(0)));
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this, "Please enter valid numbers.", "Error", 0);
                return;
            }
            this.fillJTable();
            this.hidePropertyJPanel();
            this.splitPane.setDividerLocation(this.splitPane.getDividerLocation() + 1);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.reSizeJTable();
    }

    public void disableInput() {
        this.tableModel.setEditable(false);
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
    }

    public void enableInput() {
        this.tableModel.setEditable(true);
        this.addButton.setEnabled(true);
        this.removeButton.setEnabled(true);
    }

    public void printModel(OurDefaultTableModel model) {
        int i = 0;
        while (i < model.getRowCount()) {
            int j = 0;
            while (j < model.getColumnCount()) {
                System.out.print(model.getValueAt(i, j) + " ");
                ++j;
            }
            System.out.println();
            ++i;
        }
    }
}

