/*
 * Decompiled with CFR 0.152.
 */
package interfacing;

import interfacing.MainFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SystemLevelStatisticsJPanel
extends JPanel {
    private static final long serialVersionUID = 3704614389093084232L;
    private String[] headers = new String[]{"Start Time", "Time Units Passed", "System Time Units in Minutes", "Waiting Time", "Waiting Time-T/O", "Communication Delay", "Communication Delay-T/O", "Response Time", "Response Time-T/O"};
    private String[] tooltips = new String[]{"The time when the current test has started.", "The time passed since the start time of the test expressed in Time Units.", "One Time Unit is worth this value.", "Mean of all the differences between Time Submitted and Time Done for all jobs execluding timed out jobs.", "Mean of all the differences between Time Submitted and Time Done for all jobs including timed out jobs.", "Mean of all the differences between Time Submitted and Time Sent for all jobs execluding timed out jobs..", "Mean of all the differences between Time Submitted and Time Sent for all jobs including timed out jobs.", "Mean of all the differences between Time Sent and Time Started for all jobs execluding timed out jobs..", "Mean of all the differences between Time Sent and Time Started for all jobs including timed out jobs.."};
    private MainFrame frame;
    JLabel[] labels;
    private JButton buttonUpdate = new JButton("Update");

    public SystemLevelStatisticsJPanel(MainFrame frame) {
        this.frame = frame;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 17;
        this.labels = new JLabel[this.headers.length];
        int i = 0;
        while (i < this.headers.length) {
            gbConstraints.gridy = i;
            gbConstraints.gridx = 0;
            JLabel label = new JLabel(String.valueOf(this.headers[i]) + ": ");
            label.setForeground(Color.GRAY);
            label.setToolTipText(this.tooltips[i]);
            label.setAlignmentX(2.0f);
            label.setHorizontalTextPosition(2);
            label.setHorizontalAlignment(2);
            this.add((Component)label, gbConstraints);
            gbConstraints.gridx = 1;
            this.labels[i] = new JLabel("Can't get it now");
            this.labels[i].setToolTipText(this.tooltips[i]);
            this.add((Component)this.labels[i], gbConstraints);
            ++i;
        }
        gbConstraints.gridy = i;
        gbConstraints.gridx = 0;
        gbConstraints.gridwidth = 2;
        this.add((Component)this.buttonUpdate, gbConstraints);
        gbConstraints.weighty = 1.0;
        gbConstraints.fill = 1;
        gbConstraints.gridy = i + 1;
        this.add(Box.createVerticalGlue(), gbConstraints);
        this.buttonUpdate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SystemLevelStatisticsJPanel.this.refresh();
            }
        });
    }

    public void refresh() {
        if (this.frame.getMapper().getStartTime() == null) {
            return;
        }
        DecimalFormat decimalFomatter = new DecimalFormat();
        decimalFomatter.setMaximumFractionDigits(3);
        SimpleDateFormat dateFormatter = new SimpleDateFormat("MMM, dd HH:mm:ss");
        this.labels[0].setText(dateFormatter.format(this.frame.getMapper().getStartTime().getTime()));
        this.labels[1].setText(String.valueOf(decimalFomatter.format(this.frame.getMapper().getTimeElapsedInTimeUnits())) + " Time Unit(s)");
        this.labels[2].setText(String.valueOf(decimalFomatter.format(this.frame.getMapper().getTimeUnitInMinutes())) + " minute(s)");
        this.labels[3].setText(String.valueOf(decimalFomatter.format(this.frame.getMapper().getJobsTable().getSchedulingDelayInMilliSeconds() / 1000.0)) + " seconds");
        this.labels[4].setText(String.valueOf(decimalFomatter.format(this.frame.getMapper().getJobsTable().getSchedulingDelayInMilliSecondsIncludingTimedOut() / 1000.0)) + " seconds");
        this.labels[5].setText(String.valueOf(decimalFomatter.format(this.frame.getMapper().getJobsTable().getCommunicationDelayInSeconds())) + " seconds");
        this.labels[6].setText(String.valueOf(decimalFomatter.format(this.frame.getMapper().getJobsTable().getCommunicationDelayInSecondsIncludingTimedOut())) + " seconds");
        this.labels[7].setText(String.valueOf(decimalFomatter.format(this.frame.getMapper().getJobsTable().getResponseTimeInSeconds())) + " seconds");
        this.labels[8].setText(String.valueOf(decimalFomatter.format(this.frame.getMapper().getJobsTable().getResponseTimeInSecondsIncludingTimedOut())) + " seconds");
    }
}

