/*
 * Decompiled with CFR 0.152.
 */
package mapping;

import java.util.GregorianCalendar;
import mapping.Gcu_MS_Thread;
import mapping.JobsQueue;
import mapping.Mapper;
import mapping.MappingScheme;
import mapping.data.Job;
import mapping.data.Server;

public class Gcu_MS
extends MappingScheme {
    private static final long serialVersionUID = -5803201792942657448L;
    private static long QUEUE_IS_EMPTY = -1L;
    private JobsQueue[] classesQueues;
    private Gcu_MS_Thread Gcu_MS_Thread;
    private Thread thread;

    public Gcu_MS(Mapper mapper) {
        super(mapper);
        this.setDescription("GCU");
    }

    public JobsQueue[] getClassesQueues() {
        return this.classesQueues;
    }

    public void setClassesQueues(JobsQueue[] classesQueues) {
        this.classesQueues = classesQueues;
    }

    protected Gcu_MS_Thread getGcu_MS_Thread() {
        return this.Gcu_MS_Thread;
    }

    protected void setGcu_MS_Thread(Gcu_MS_Thread gcu_MS_Thread) {
        this.Gcu_MS_Thread = gcu_MS_Thread;
    }

    protected Thread getThread() {
        return this.thread;
    }

    protected void setThread(Thread thread) {
        this.thread = thread;
    }

    public void startMappingScheme() {
        try {
            this.initQueues();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setGcu_MS_Thread(new Gcu_MS_Thread(this));
        this.getGcu_MS_Thread().startThread();
    }

    public void stopMappingScheme() {
        this.getGcu_MS_Thread().stopThread();
    }

    protected void mapJob(Job job) {
        int jobClassID = this.getMapper().getJobsTable().getJobClassID(job.getIndex());
        this.getClassesQueues()[jobClassID - 1].enqueue(job);
    }

    public void handleJobTimeOut(long jobID) {
        this.getMapper().getJobsTable().setTimedOut(jobID, true);
        this.getMapper().getJobsTable().setJobServer(jobID, null);
        this.getMapper().resubmitJob((Job)this.getMapper().getJobsTable().get(jobID));
    }

    public void serverIsDown(int serverID) {
    }

    public void serverIsUp(int serverID) {
    }

    protected void printQueues() {
        int i = 0;
        while (i < this.getClassesQueues().length) {
            System.out.println("Queue " + (i + 1) + ":");
            this.getClassesQueues()[i].print();
            ++i;
        }
        System.out.println("\n\n");
    }

    protected String getQueuesString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.getClassesQueues().length) {
            buf.append("Queue " + (i + 1) + ": \n");
            buf.append(this.getClassesQueues()[i].toString());
            ++i;
        }
        return buf.toString();
    }

    public void initQueues() {
        this.classesQueues = new JobsQueue[this.getMapper().getClassesTable().size()];
        int i = 0;
        while (i < this.getMapper().getClassesTable().size()) {
            this.classesQueues[i] = new JobsQueue();
            ++i;
        }
    }

    protected Job sendJobForServer(int readyServer) {
        double max = 0.0;
        int queueIndex = 0;
        long DiOfT = -1L;
        long nowInMillis = new GregorianCalendar().getTimeInMillis();
        Job job = null;
        Server server = (Server)this.getMapper().getServersTable().get(readyServer);
        int i = 0;
        while (i < this.getClassesQueues().length) {
            double Uij = server.getAssumedRate(i + 1);
            if (this.getClassesQueues()[i].size() > 0) {
                long timeSubmittedInMillis = this.getMapper().getJobsTable().getJobTimeSubmitted(this.getClassesQueues()[i].peak().getIndex()).getTimeInMillis();
                DiOfT = nowInMillis - timeSubmittedInMillis;
            } else {
                DiOfT = QUEUE_IS_EMPTY;
            }
            if (Uij * (double)DiOfT > max) {
                max = Uij * (double)DiOfT;
                queueIndex = i;
            }
            ++i;
        }
        job = this.getClassesQueues()[queueIndex].peak();
        if (job != null) {
            long result = this.getMapper().sendJob(job.getIndex(), readyServer);
            if (result >= 0L) {
                this.getClassesQueues()[queueIndex].dequeue();
            } else {
                job = null;
            }
        }
        return job;
    }
}

