/*
 * Decompiled with CFR 0.152.
 */
package mapping;

import mapping.LPAS_DG_MS;
import mapping.data.IDsQueue;
import mapping.data.Server;

public class LPAS_DG_MS_ThreadFCFS
implements Runnable {
    private boolean alive;
    private Thread thisThread;
    private LPAS_DG_MS lpas_dg_ms;

    public LPAS_DG_MS_ThreadFCFS(LPAS_DG_MS lpas_dg_ms) {
        this.setAlive(true);
        this.setLpas_dg_ms(lpas_dg_ms);
    }

    public synchronized boolean isAlive() {
        return this.alive;
    }

    public synchronized void setAlive(boolean alive) {
        this.alive = alive;
    }

    public LPAS_DG_MS getLpas_dg_ms() {
        return this.lpas_dg_ms;
    }

    public void setLpas_dg_ms(LPAS_DG_MS lpas_dg_ms) {
        this.lpas_dg_ms = lpas_dg_ms;
    }

    public void startThread() {
        System.out.println("LPAS Thread started");
        this.thisThread = new Thread(this);
        this.thisThread.start();
    }

    public void stopThread() {
        this.setAlive(false);
        this.thisThread.interrupt();
        this.thisThread = null;
    }

    public void run() {
        Server server = null;
        IDsQueue<Integer> q = this.getLpas_dg_ms().getMapper().getAvailableServersQueue();
        while (this.isAlive()) {
            if (!q.isEmpty()) {
                int serverID = q.peak();
                server = (Server)this.getLpas_dg_ms().getMapper().getServersTable().get(serverID);
                if (server.getNumberOfActiveJobs() != 0 || this.getLpas_dg_ms().getMapper().getServersTable().isServerDown(serverID)) continue;
                System.out.println("LPAS_THREAD: sendJobForServer( " + serverID + ")");
                int result = this.getLpas_dg_ms().sendJobForServer(serverID);
                if (result >= 0) continue;
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    if (this.isAlive()) continue;
                    return;
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

