/*
 * Decompiled with CFR 0.152.
 */
package mapping;

import mapping.NREP_MS;
import mapping.data.IDsQueue;
import mapping.data.Server;

public class NREP_MS_Thread
implements Runnable {
    private boolean alive = true;
    private int repetitions = 5;
    private int[] serverIDs = new int[this.repetitions];
    private Server[] server = new Server[this.repetitions];
    private int result;
    private Thread thisThread;
    private NREP_MS rep_ms;

    public NREP_MS_Thread(NREP_MS rep_ms) {
        this.setAlive(true);
        this.setNREP_MS(rep_ms);
    }

    public synchronized boolean isAlive() {
        return this.alive;
    }

    public synchronized void setAlive(boolean alive) {
        this.alive = alive;
    }

    public NREP_MS getNREP_MS() {
        return this.rep_ms;
    }

    public void setNREP_MS(NREP_MS Rep_ms) {
        this.rep_ms = Rep_ms;
    }

    public void startThread() {
        System.out.println(String.valueOf(this.repetitions) + " Replication Thread started");
        this.thisThread = new Thread(this);
        this.thisThread.start();
    }

    public void stopThread() {
        this.setAlive(false);
        this.thisThread.interrupt();
        this.thisThread = null;
    }

    public boolean arrayisFull(int[] array) {
        boolean Full = true;
        int i = 0;
        while (i < array.length) {
            if (array[i] == 0) {
                Full = false;
            }
            ++i;
        }
        return Full;
    }

    public boolean readyforJobSubmission() {
        boolean ready = true;
        if (!this.arrayisFull(this.serverIDs)) {
            ready = false;
        }
        int i = 0;
        while (i < this.server.length) {
            if (this.server[i].getNumberOfActiveJobs() != 0 || this.getNREP_MS().getMapper().getServersTable().isServerDown(this.serverIDs[i])) {
                ready = false;
            }
            ++i;
        }
        return ready;
    }

    public void run() {
        int i = 0;
        IDsQueue<Integer> q = this.getNREP_MS().getMapper().getAvailableServersQueue();
        while (this.isAlive()) {
            if (q.isEmpty()) continue;
            if (i < this.serverIDs.length) {
                this.serverIDs[i] = q.getVal((int)(Math.random() * (double)q.getRowCount()));
                ++i;
            }
            if (this.arrayisFull(this.serverIDs)) {
                i = 0;
                while (i < this.serverIDs.length) {
                    this.server[i] = (Server)this.getNREP_MS().getMapper().getServersTable().get(this.serverIDs[i]);
                    ++i;
                }
            }
            if (this.readyforJobSubmission()) {
                this.result = this.getNREP_MS().sendJobForServer(this.serverIDs);
                if (this.result >= 0) continue;
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException e) {
                    if (this.isAlive()) continue;
                    return;
                }
            }
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

