/*
 * Decompiled with CFR 0.152.
 */
package mapping;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.GregorianCalendar;
import mapping.LPAS_DG_MS;
import mapping.LP_Solver;
import mapping.Mapper;
import mapping.data.DeltaStar;
import mapping.data.Job;
import mapping.data.Server;
import mapping.data.ServersTable;

public class Testing {
    public static void main(String[] args) {
        Mapper m = new Mapper();
        m.setServersTable(new ServersTable());
        ((Server)m.getServersTable().get(2)).setAvailabilty(1.0);
        ((Server)m.getServersTable().get(1)).addProcessingRate(5.0, 5.0, 1);
        ((Server)m.getServersTable().get(1)).addProcessingRate(2.0, 2.0, 1);
        ((Server)m.getServersTable().get(2)).addProcessingRate(5.0, 5.0, 1);
        ((Server)m.getServersTable().get(2)).addProcessingRate(1.0, 1.0, 11);
        LPAS_DG_MS lpas_dg_ms = new LPAS_DG_MS(m);
        ObjectOutputStream output = null;
        try {
            output = new ObjectOutputStream(new FileOutputStream(new File("test"), true));
            output.writeObject(lpas_dg_ms);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main3(String[] args) {
        Mapper m = new Mapper();
        m.setServersTable(new ServersTable());
        ((Server)m.getServersTable().get(2)).setAvailabilty(1.0);
        ((Server)m.getServersTable().get(1)).addProcessingRate(5.0, 5.0, 1);
        ((Server)m.getServersTable().get(1)).addProcessingRate(2.0, 2.0, 1);
        ((Server)m.getServersTable().get(2)).addProcessingRate(5.0, 5.0, 1);
        ((Server)m.getServersTable().get(2)).addProcessingRate(1.0, 1.0, 11);
        for (Integer key1 : m.getServersTable().keySet()) {
            Server obj = (Server)m.getServersTable().get(key1);
            System.out.print(obj.getHostName());
        }
    }

    public static void waitToFinish() {
        ServerSocket serverSocket = null;
        Socket socket = null;
        DataInputStream in = null;
        try {
            try {
                int r;
                System.out.print("Test is waiting for finish announcment");
                serverSocket = new ServerSocket(37931);
                socket = serverSocket.accept();
                in = new DataInputStream(socket.getInputStream());
                System.out.print("\nReceived in Testing: ");
                while ((r = in.read()) != -1) {
                    System.out.print(" " + (char)r);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    serverSocket.close();
                    socket.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                serverSocket.close();
                socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void testGenerator() {
    }

    public static void generateTaskForTest(int jobClassID, Mapper m) {
        Job job = new Job(jobClassID, 1000L);
        m.submitJob(job);
        System.out.println("Task Generated from class: " + jobClassID);
    }

    public static void prepareLPAS_DG(Mapper m) {
        m.setMappingScheme(new LPAS_DG_MS(m));
        try {
            DeltaStar delta = LP_Solver.solveWithAj(m.getServersTable(), m.getClassesTable());
            delta.printAll();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void LPAS_Test(Mapper m) {
        m.getMappingScheme().mapJob(new Job(1, 1000L));
        m.getMappingScheme().mapJob(new Job(1, 1000L));
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        m.getMappingScheme().mapJob(new Job(1, 1000L));
        m.getMappingScheme().mapJob(new Job(2, 1000L));
        m.getMappingScheme().mapJob(new Job(1, 1000L));
        ((LPAS_DG_MS)m.getMappingScheme()).printQueues();
        ((LPAS_DG_MS)m.getMappingScheme()).refreshDeltaStar();
        System.out.print("\n\n\nChoosen:\n");
    }

    public static void test() {
        GregorianCalendar c = new GregorianCalendar();
        Date d = c.getTime();
        System.out.print(d.toString());
    }

    public static void buildTablesAndSolve_v2(Mapper m) {
    }

    public static void buildTablesAndSolve(Mapper m) {
    }
}

