/*
 * Decompiled with CFR 0.152.
 */
package mapping.data;

import java.io.Serializable;
import java.util.GregorianCalendar;
import mapping.data.Server;

public class Job
implements Serializable {
    private static final long serialVersionUID = 1166268079811990240L;
    public static final String QUEUED = "Queued";
    public static final String RUNNING = "Running";
    public static final String DONE = "Done";
    public static final String TIMEDOUT = "Timed-out";
    public static final int NOT_ASSIGNED = -4000;
    public static final long NOT_DONE = -6000L;
    public static final long NOT_SENT = -7000L;
    private long index;
    private long secondaryID = -4000L;
    private Server server;
    private double timeExpected;
    private long executionTime;
    private int JobClassID;
    private GregorianCalendar timeSubmitted;
    private GregorianCalendar timeSent;
    private GregorianCalendar timeStarted;
    private GregorianCalendar timeDone;
    private boolean timedOut = false;

    protected String getStatus() {
        if (this.timeDone == null && this.timeStarted == null && this.timeSent == null) {
            return QUEUED;
        }
        if (this.timeDone == null) {
            return RUNNING;
        }
        if (this.timeDone != null) {
            return DONE;
        }
        return null;
    }

    public Job(int id, Server server, double timeExpected) {
        this.setIndex(id);
        this.setServer(server);
        this.setTimeExpected(timeExpected);
        this.setTimeSubmitted(new GregorianCalendar());
    }

    public Job(int id, Server server) {
        this.setIndex(id);
        this.setServer(server);
        this.setTimeExpected(this.timeExpected);
        this.setTimeSubmitted(new GregorianCalendar());
    }

    public Job(int id, Server server, GregorianCalendar timeSubmitted) {
        this.setIndex(id);
        this.setServer(server);
        this.setTimeExpected(-4000.0);
        this.setTimeSubmitted(timeSubmitted);
    }

    public Job(int index, Server server, double timeExpected, GregorianCalendar timeSubmitted) {
        this.setIndex(index);
        this.setServer(server);
        this.setTimeExpected(timeExpected);
        this.setTimeSubmitted(timeSubmitted);
    }

    public Job(int jobClassId, long executionTime) {
        this.setIndex(-4000L);
        this.setServer(new Server(""));
        this.setTimeExpected(-4000.0);
        this.setJobClassID(jobClassId);
        this.setexecutionTime(executionTime);
    }

    public synchronized long getIndex() {
        return this.index;
    }

    protected void setIndex(long index) {
        this.index = index;
    }

    protected long getSecondaryID() {
        return this.secondaryID;
    }

    protected void setSecondaryID(long secondaryID) {
        this.secondaryID = secondaryID;
    }

    public long getexecutionTime() {
        return this.executionTime;
    }

    protected void setexecutionTime(long executionTime) {
        this.executionTime = executionTime;
    }

    protected GregorianCalendar getTimeSubmitted() {
        return this.timeSubmitted;
    }

    protected void setTimeSubmitted(GregorianCalendar timeSubmitted) {
        this.timeSubmitted = timeSubmitted;
    }

    protected double getTimeExpected() {
        return this.timeExpected;
    }

    protected void setTimeExpected(double timeExpected) {
        this.timeExpected = timeExpected;
    }

    protected Server getServer() {
        return this.server;
    }

    protected void setServer(Server server) {
        this.server = server;
    }

    protected int getJobClassID() {
        return this.JobClassID;
    }

    protected void setJobClassID(int jobClassID) {
        this.JobClassID = jobClassID;
    }

    protected GregorianCalendar getTimeStarted() {
        return this.timeStarted;
    }

    protected GregorianCalendar getTimeSent() {
        return this.timeSent;
    }

    protected void setTimeSent(GregorianCalendar timeSent) {
        this.timeSent = timeSent;
    }

    protected void setTimeStarted(GregorianCalendar timeStarted) {
        this.timeStarted = timeStarted;
    }

    protected GregorianCalendar getTimeDone() {
        return this.timeDone;
    }

    protected void setTimeDone(GregorianCalendar timeDone) {
        this.timeDone = timeDone;
    }

    protected boolean isTimedOut() {
        return this.timedOut;
    }

    protected void setTimedOut(boolean timedOut) {
        this.timedOut = timedOut;
    }

    public String toString() {
        String hostName = "";
        if (this.getServer() != null) {
            hostName = this.getServer().getHostName();
        }
        return "Job ( " + this.getIndex() + ", " + this.getSecondaryID() + ") Server: " + hostName + ",\n Time Submitted: " + this.getTimeSubmitted().getTime().toString() + "  Class ID: " + this.getJobClassID();
    }

    public void print() {
        System.out.print(this.toString());
    }

    public long getTimeBetweenSubmissionTimeAndDoneTimeInMilliSeconds() {
        if (this.getStatus().equals(DONE)) {
            return this.getTimeDone().getTimeInMillis() - this.getTimeSubmitted().getTimeInMillis();
        }
        return -6000L;
    }

    public double getTimeBetweenSubmissionTimeAndDoneTimeInSeconds() {
        if (this.getStatus().equals(DONE)) {
            return (double)(this.getTimeDone().getTimeInMillis() - this.getTimeSubmitted().getTimeInMillis()) / 1000.0;
        }
        return -6000.0;
    }

    public double getTimeBetweenSubmissionTimeAndSentTimeInMilliSeconds() {
        if (this.getStatus().equals(RUNNING) || this.getStatus().equals(DONE)) {
            return this.getTimeSent().getTimeInMillis() - this.getTimeSubmitted().getTimeInMillis();
        }
        return -7000.0;
    }

    public double getTimeBetweenStartTimeAndSentTimeInSeconds() {
        if (this.getStatus().equals(DONE)) {
            return (double)(this.getTimeStarted().getTimeInMillis() - this.getTimeSent().getTimeInMillis()) / 1000.0;
        }
        return -6000.0;
    }
}

