/*
 * Decompiled with CFR 0.152.
 */
package pulling.availability_imposer;

import java.io.Serializable;
import java.util.LinkedList;
import pulling.availability_imposer.Arch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node
implements Serializable {
    private static final long serialVersionUID = 3829862197493899372L;
    private double aj;
    private String description;
    private long periodToStay;
    private LinkedList<Arch> archs;
    protected boolean visited = false;

    public Node(double aj, String description, long periodToStay) {
        this.setAj(aj);
        this.setDescription(description);
        this.setPeriodToStay(periodToStay);
        this.archs = new LinkedList();
    }

    protected double getAj() {
        return this.aj;
    }

    protected void setAj(double aj) {
        this.aj = aj;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getPeriodToStay() {
        return this.periodToStay;
    }

    public void setPeriodToStay(long periodToStay) {
        this.periodToStay = periodToStay;
    }

    public LinkedList<Arch> getArchs() {
        return this.archs;
    }

    public void setArchs(LinkedList<Arch> archs) {
        this.archs = archs;
    }

    public void addArch(double probability, Node distinatioNode) {
        Arch arch = new Arch(probability, distinatioNode);
        this.archs.add(arch);
    }

    public boolean isSumValid() {
        double sum = 0.0;
        int i = 0;
        while (i < this.archs.size()) {
            sum += this.archs.get(i).getProbability();
            ++i;
        }
        return sum > 0.999 && sum < 1.001;
    }

    public int getNeighboursNumber() {
        return this.getArchs().size();
    }

    public Node getNeighbour(int i) {
        return this.getArchs().get(i).getDestinationNode();
    }

    public double getPropability(int i) {
        return this.getArchs().get(i).getProbability();
    }

    public String toString() {
        return String.valueOf(this.getDescription()) + ",\nTime to stay: " + this.getPeriodToStay() + "\nAvailability: " + this.getAj() + "\nArchs: " + this.archs.toString() + "\n";
    }

    public void visit() {
        this.print();
        this.visited = true;
    }

    public void print() {
        System.out.print(this.toString());
    }
}

