/*
 * Decompiled with CFR 0.152.
 */
package arrival_generator;

import arrival_generator.ArrivalGenerator;
import generating.JobLogger;
import mapping.Mapper;
import mapping.data.JobClass;
import probability_distribution.ExponentialDist;
import probability_distribution.ProbabilityDist;
import probability_distribution.UniformDist;

public class EXP_AND_UNI_AG
extends ArrivalGenerator {
    private ProbabilityDist probabilitydist;
    private ProbabilityDist variationDistribution;
    private Mapper mapper;
    private JobClass jobclass;
    private JobLogger jobLogger;

    public EXP_AND_UNI_AG(JobClass jobClass, Mapper mapper) {
        this.setMapper(mapper);
        this.setDescription("EXP_AND_UNI_AG");
        this.setJobClass(jobClass);
        String filename = new String("JobClass" + jobClass.getIndex());
        this.setJobLogger(new JobLogger(filename, jobClass.getIndex()));
        this.setProbabilityDist(new ExponentialDist(this.getJobClass().getArrivalRate() / (this.getMapper().getTimeUnitInMinutes() * 60.0 * 1000.0)));
        this.setVariationDistribution(new UniformDist(0.05));
    }

    protected void setJobLogger(JobLogger joblogger) {
        this.jobLogger = joblogger;
    }

    protected JobLogger getJobLogger() {
        return this.jobLogger;
    }

    protected Mapper getMapper() {
        return this.mapper;
    }

    protected void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    protected JobClass getJobClass() {
        return this.jobclass;
    }

    protected void setJobClass(JobClass jobClass) {
        this.jobclass = jobClass;
    }

    protected ProbabilityDist getProbabilityDist() {
        return this.probabilitydist;
    }

    protected void setProbabilityDist(ProbabilityDist probabilityDist) {
        this.probabilitydist = probabilityDist;
    }

    public ProbabilityDist getVariationDistribution() {
        return this.variationDistribution;
    }

    public void setVariationDistribution(ProbabilityDist variationDistribution) {
        this.variationDistribution = variationDistribution;
    }

    public void closeLogger() {
        this.getJobLogger().closeStreams();
    }

    public long[] getNextJobInfo() {
        long[] JobInfo2 = new long[3];
        long JobClass2 = this.getJobClass().getIndex();
        long ArrivalTime = (long)this.getProbabilityDist().FInverse();
        long executionTime = Math.round(this.getVariationDistribution().FInverse() * (double)this.getJobClass().getexecutionTime() + (double)this.getJobClass().getexecutionTime());
        JobInfo2[0] = JobClass2;
        JobInfo2[1] = ArrivalTime;
        JobInfo2[2] = executionTime;
        this.getJobLogger().logJob(JobInfo2[1], JobInfo2[2]);
        return JobInfo2;
    }
}

