/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.graph;

import drasys.or.CorruptedError;
import drasys.or.DoubleI;
import drasys.or.graph.BaseGraph;
import drasys.or.graph.DuplicateEdgeException;
import drasys.or.graph.DuplicateVertexException;
import drasys.or.graph.EdgeBase;
import drasys.or.graph.EdgeI;
import drasys.or.graph.EdgeNotFoundException;
import drasys.or.graph.EditI;
import drasys.or.graph.GraphError;
import drasys.or.graph.GraphI;
import drasys.or.graph.VertexBase;
import drasys.or.graph.VertexI;
import drasys.or.graph.VertexNotFoundException;
import drasys.or.matrix.MatrixElementI;
import drasys.or.matrix.MatrixI;
import java.io.Serializable;
import java.util.Enumeration;

public class SparseGraph
extends BaseGraph
implements EditI {
    public SparseGraph() {
    }

    public SparseGraph(int n) {
        super(n);
    }

    public SparseGraph(MatrixI matrixI) {
        super(Math.max(matrixI.sizeOfRows(), matrixI.sizeOfColumns()));
        int n = Math.max(matrixI.sizeOfRows(), matrixI.sizeOfColumns());
        try {
            Integer[] integerArray = new Integer[n];
            int n2 = 0;
            while (n2 < n) {
                integerArray[n2] = new Integer(n2);
                this.addVertex(integerArray[n2]);
                ++n2;
            }
            Enumeration enumeration = matrixI.elements();
            while (enumeration.hasMoreElements()) {
                MatrixElementI matrixElementI = (MatrixElementI)enumeration.nextElement();
                double d = matrixElementI.getValue();
                if (d == Double.POSITIVE_INFINITY) continue;
                this.addEdge(integerArray[matrixElementI.getRowIndex()], integerArray[matrixElementI.getColumnIndex()], new Double(d), true);
            }
        }
        catch (DuplicateEdgeException duplicateEdgeException) {
        }
        catch (VertexNotFoundException vertexNotFoundException) {
        }
        catch (DuplicateVertexException duplicateVertexException) {}
    }

    private void _deleteEdge(EdgeI edgeI) {
        int n = edgeI.getIndex();
        Enumeration enumeration = this.edges();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (edge.getIndex() <= n) continue;
            edge.decIndex();
        }
    }

    private void _deleteVertex(VertexI vertexI) {
        int n = vertexI.getIndex();
        this._vertexHashtable.remove(vertexI.getKey());
        Enumeration enumeration = this.vertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            if (vertex.getIndex() <= n) continue;
            vertex.decIndex();
        }
    }

    private void _removeEdge(Edge edge, boolean bl) {
        Vertex vertex = (Vertex)edge.getToVertex();
        Vertex vertex2 = (Vertex)edge.getFromVertex();
        if (!vertex.removeInEdge(edge)) {
            throw new CorruptedError("Edge was not in the to vertex.");
        }
        if (!vertex2.removeOutEdge(edge)) {
            throw new CorruptedError("Edge was not in the from vertex.");
        }
        if (bl) {
            if (vertex.getInDegree() == 0 && vertex.getOutDegree() == 0) {
                this._deleteVertex(vertex);
            }
            if (vertex2.getInDegree() == 0 && vertex2.getOutDegree() == 0) {
                this._deleteVertex(vertex2);
            }
        }
        --this._sizeOfEdges;
        if (edge._isDirected) {
            --this._sizeOfDirectedEdges;
        }
        this._deleteEdge(edge);
    }

    protected void _removeVertex(VertexI vertexI, boolean bl) {
        Vertex vertex = (Vertex)vertexI;
        while (vertex.getInEdge() != null) {
            this._removeEdge(vertex.getInEdge(), bl);
        }
        while (vertex.getOutEdge() != null) {
            this._removeEdge(vertex.getOutEdge(), bl);
        }
        if (!bl) {
            this._deleteVertex(vertexI);
        }
    }

    public EdgeI addEdge(EdgeI edgeI) throws DuplicateEdgeException, VertexNotFoundException {
        return this.addEdge(edgeI.getFromVertex().getKey(), edgeI.getToVertex().getKey(), edgeI.getValue(), edgeI.isDirected(), edgeI.getKey());
    }

    public EdgeI addEdge(Object object, Object object2) throws DuplicateEdgeException, VertexNotFoundException {
        return this.addEdge(object, object2, null, false, null);
    }

    public EdgeI addEdge(Object object, Object object2, Object object3) throws DuplicateEdgeException, VertexNotFoundException {
        return this.addEdge(object, object2, object3, false, null);
    }

    public EdgeI addEdge(Object object, Object object2, Object object3, boolean bl) throws DuplicateEdgeException, VertexNotFoundException {
        return this.addEdge(object, object2, object3, bl, null);
    }

    public final EdgeI addEdge(Object object, Object object2, Object object3, boolean bl, Object object4) throws DuplicateEdgeException, VertexNotFoundException {
        Vertex vertex = (Vertex)this.getVertex(object);
        if (vertex == null) {
            throw new VertexNotFoundException("Can't find the FROM vertex object");
        }
        Vertex vertex2 = (Vertex)this.getVertex(object2);
        if (vertex2 == null) {
            throw new VertexNotFoundException("Can't find the TO vertex object");
        }
        if (this.getEdge(vertex, vertex2, object4) != null) {
            throw new DuplicateEdgeException();
        }
        if (bl) {
            ++this._sizeOfDirectedEdges;
        }
        ++this._changeCount;
        return new Edge(this._sizeOfEdges++, vertex, vertex2, object4, object3, bl);
    }

    public void ensureEdgeCapacity(int n) {
    }

    public EdgeI getEdge(VertexI vertexI, VertexI vertexI2, Object object) {
        if (vertexI2.getGraph() != this) {
            throw new GraphError("The to vertx is not cointained in this graph");
        }
        if (vertexI.getGraph() != this) {
            throw new GraphError("The from vertx is not cointained in this graph");
        }
        Vertex vertex = (Vertex)vertexI2;
        Vertex vertex2 = (Vertex)vertexI;
        if (vertex2.getOutDegree() < vertex.getInDegree()) {
            Edge edge = vertex2.getOutEdge();
            while (edge != null) {
                if (edge.getToVertex() == vertex) {
                    if (edge.getKey() == object) {
                        return edge;
                    }
                    if (edge.getKey() != null && object != null && edge.getKey().equals(object)) {
                        return edge;
                    }
                }
                edge = edge.getNextOutEdge();
            }
        } else {
            Edge edge = vertex.getInEdge();
            while (edge != null) {
                if (edge.getFromVertex() == vertex2) {
                    if (edge.getKey() == object) {
                        return edge;
                    }
                    if (edge.getKey() != null && object != null && edge.getKey().equals(object)) {
                        return edge;
                    }
                }
                edge = edge.getNextInEdge();
            }
        }
        return null;
    }

    public EdgeI getMutableEdge(VertexI vertexI, VertexI vertexI2, Object object) {
        return this.getEdge(vertexI, vertexI2, object);
    }

    public boolean isSymmetric() {
        if (this._symmetric != null) {
            return this._symmetric;
        }
        return false;
    }

    protected VertexI newVertex(Object object, Object object2) {
        return new Vertex(this.sizeOfVertices(), object, object2);
    }

    public void removeAllEdges() {
        this._sizeOfEdges = 0;
        this._sizeOfDirectedEdges = 0;
        Enumeration enumeration = this.vertices();
        while (enumeration.hasMoreElements()) {
            ((Vertex)enumeration.nextElement()).removeAllEdges();
        }
        ++this._changeCount;
    }

    public EdgeI removeEdge(EdgeI edgeI, boolean bl) throws VertexNotFoundException, EdgeNotFoundException {
        return this.removeEdge(edgeI.getFromVertex().getKey(), edgeI.getFromVertex().getKey(), edgeI.getKey(), bl);
    }

    public EdgeI removeEdge(Object object, Object object2, Object object3, boolean bl) throws VertexNotFoundException, EdgeNotFoundException {
        VertexI vertexI = (VertexI)this._vertexHashtable.get(object);
        if (vertexI == null) {
            throw new VertexNotFoundException("Can't find FROM vertex");
        }
        VertexI vertexI2 = (VertexI)this._vertexHashtable.get(object2);
        if (vertexI2 == null) {
            throw new VertexNotFoundException("Can't find TO vertex");
        }
        EdgeI edgeI = this.getEdge(vertexI, vertexI2, object3);
        if (edgeI == null) {
            throw new EdgeNotFoundException();
        }
        this._removeEdge((Edge)edgeI, bl);
        ++this._changeCount;
        return edgeI;
    }

    public VertexI removeVertex(VertexI vertexI, boolean bl) throws VertexNotFoundException {
        return this.removeVertex(vertexI.getKey(), bl);
    }

    public VertexI removeVertex(Object object, boolean bl) throws VertexNotFoundException {
        VertexI vertexI = (VertexI)this._vertexHashtable.get(object);
        if (vertexI == null) {
            throw new VertexNotFoundException();
        }
        this._removeVertex(vertexI, bl);
        ++this._changeCount;
        return vertexI;
    }

    public String toString() {
        return super.toString("SparseGraph");
    }

    class Vertex
    extends VertexBase
    implements VertexI,
    Serializable {
        Edge _inList = null;
        Edge _outList = null;

        Vertex(int n, Object object, Object object2) {
            super(n, object, object2);
        }

        public void addInEdge(Edge edge) {
            edge.setNextInEdge(this._inList);
            this._inList = edge;
            ++this._inDegree;
        }

        public void addOutEdge(Edge edge) {
            edge.setNextOutEdge(this._outList);
            this._outList = edge;
            ++this._outDegree;
        }

        public void decIndex() {
            --this._index;
        }

        public double doubleValue() {
            if (this._value == null) {
                return 0.0;
            }
            if (this._value instanceof DoubleI) {
                return ((DoubleI)this._value).doubleValue();
            }
            if (this._value instanceof Number) {
                return ((Number)this._value).doubleValue();
            }
            return 0.0;
        }

        public GraphI getGraph() {
            return SparseGraph.this;
        }

        public int getInDegree() {
            return this._inDegree;
        }

        public Edge getInEdge() {
            return this._inList;
        }

        public int getIndex() {
            return this._index;
        }

        public Object getKey() {
            return this._key;
        }

        public int getOutDegree() {
            return this._outDegree;
        }

        public Edge getOutEdge() {
            return this._outList;
        }

        public Object getValue() {
            return this._value;
        }

        public Enumeration inEdges() {
            return new InEdgeEnumeration(this);
        }

        public boolean isEdge() {
            return false;
        }

        public boolean isVertex() {
            return true;
        }

        public Enumeration mutableInEdges() {
            return new InEdgeEnumeration(this);
        }

        public Enumeration mutableOutEdges() {
            return new OutEdgeEnumeration(this);
        }

        public Enumeration outEdges() {
            return new OutEdgeEnumeration(this);
        }

        public void removeAllEdges() {
            this._inList = null;
            this._outList = null;
            this._inDegree = 0;
            this._outDegree = 0;
        }

        public boolean removeInEdge(Edge edge) {
            if (this._inList == edge) {
                this._inList = this._inList.getNextInEdge();
                --this._inDegree;
                return true;
            }
            Edge edge2 = this._inList;
            while (edge2 != null) {
                if (edge2.getNextInEdge() == edge) {
                    edge2.setNextInEdge(edge2.getNextInEdge().getNextInEdge());
                    --this._inDegree;
                    return true;
                }
                edge2 = edge2.getNextInEdge();
            }
            return false;
        }

        public boolean removeOutEdge(Edge edge) {
            if (this._outList == edge) {
                this._outList = this._outList.getNextOutEdge();
                --this._outDegree;
                return true;
            }
            Edge edge2 = this._outList;
            while (edge2 != null) {
                if (edge2.getNextOutEdge() == edge) {
                    edge2.setNextOutEdge(edge2.getNextOutEdge().getNextOutEdge());
                    --this._outDegree;
                    return true;
                }
                edge2 = edge2.getNextOutEdge();
            }
            return false;
        }

        public String toString() {
            return String.valueOf(String.valueOf(this._key)) + ", " + this._value;
        }

        private class InEdgeEnumeration
        implements Enumeration {
            Edge _edge;

            InEdgeEnumeration(Vertex vertex2) {
                this._edge = vertex2.getInEdge();
            }

            public boolean hasMoreElements() {
                return this._edge != null;
            }

            public Object nextElement() {
                Edge edge = this._edge;
                this._edge = this._edge.getNextInEdge();
                return edge;
            }
        }

        private class OutEdgeEnumeration
        implements Enumeration {
            Edge _edge;

            OutEdgeEnumeration(Vertex vertex2) {
                this._edge = vertex2.getOutEdge();
            }

            public boolean hasMoreElements() {
                return this._edge != null;
            }

            public Object nextElement() {
                Edge edge = this._edge;
                this._edge = this._edge.getNextOutEdge();
                return edge;
            }
        }
    }

    class Edge
    extends EdgeBase
    implements EdgeI,
    Serializable {
        Vertex _toVertex;
        Vertex _fromVertex;
        Edge _nextInEdge;
        Edge _nextOutEdge;

        Edge(int n, Vertex vertex, Vertex vertex2, Object object, Object object2, boolean bl) {
            super(n, object, object2, bl);
            this._toVertex = vertex2;
            this._fromVertex = vertex;
            this._toVertex.addInEdge(this);
            this._fromVertex.addOutEdge(this);
        }

        public void decIndex() {
            --this._index;
        }

        public VertexI getFromVertex() {
            return this._fromVertex;
        }

        public GraphI getGraph() {
            return SparseGraph.this;
        }

        public Edge getNextInEdge() {
            return this._nextInEdge;
        }

        public Edge getNextOutEdge() {
            return this._nextOutEdge;
        }

        public VertexI getToVertex() {
            return this._toVertex;
        }

        public void setNextInEdge(Edge edge) {
            this._nextInEdge = edge;
        }

        public void setNextOutEdge(Edge edge) {
            this._nextOutEdge = edge;
        }

        public String toString() {
            return String.valueOf(String.valueOf(this._fromVertex._key)) + (this._isDirected ? " -" : " <") + "-> " + this._toVertex._key + ", " + this._key + ", " + this._value;
        }
    }
}

