/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.matrix.complex;

import drasys.or.Complex;
import drasys.or.ComplexI;
import drasys.or.matrix.complex.ComplexContainerI;
import java.io.Serializable;

public class ComplexContainer
implements ComplexContainerI,
Serializable {
    protected static double _globalEpsilon = 1.0E-6;
    protected double _epsilon;

    public ComplexContainer() {
        this._epsilon = _globalEpsilon;
    }

    public ComplexContainer(double d) {
        this._epsilon = d;
    }

    public boolean equals(Complex complex, Complex complex2) {
        double d = complex.real - complex2.real;
        if (d < 0.0) {
            d = -d;
        }
        if (d > this._epsilon) {
            return false;
        }
        d = complex.imag - complex2.imag;
        if (d < 0.0) {
            d = -d;
        }
        return d <= this._epsilon;
    }

    public boolean equals(ComplexI complexI, ComplexI complexI2) {
        double d = complexI.getReal() - complexI2.getReal();
        if (d < 0.0) {
            d = -d;
        }
        if (d > this._epsilon) {
            return false;
        }
        d = complexI.getImag() - complexI2.getImag();
        if (d < 0.0) {
            d = -d;
        }
        return d <= this._epsilon;
    }

    public double getEpsilon() {
        return this._epsilon;
    }

    public static double getGlobalEpsilon() {
        return _globalEpsilon;
    }

    public void setEpsilon(double d) {
        this._epsilon = d;
    }

    public static void setGlobalEpsilon(double d) {
        _globalEpsilon = d;
    }
}

