/*
 * Decompiled with CFR 0.152.
 */
package interfacing;

import adjusting.availability_adjusting.FailureTrace;
import interfacing.MainFrame;
import interfacing.OurDefaultTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import mapping.data.Server;

public class FailuresTraceJPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 5393004602796008077L;
    private MainFrame frame;
    private String[] headers = new String[]{"Start", "End", "Status"};
    private JTable failureTracesJTable;
    private JTextField periodsMean = new JTextField(15);
    private JTextField interPeriodsMean = new JTextField(15);
    private Format formatter;
    private Server server;

    public FailuresTraceJPanel() {
    }

    public FailuresTraceJPanel(MainFrame frame, Server server) {
        this.server = server;
        this.frame = frame;
        this.formatter = new SimpleDateFormat("dd/MM/yy '@' HH:mm:ss");
        this.failureTracesJTable = new JTable(server.getFailureTrace().getNumbersOfPeriods(), this.headers.length);
        this.failureTracesJTable.setModel(new OurDefaultTableModel(this.headers, server.getFailureTrace().getNumbersOfPeriods()));
        ((OurDefaultTableModel)this.failureTracesJTable.getModel()).setEditable(false);
        this.refresh();
        JScrollPane scrollPane = new JScrollPane(this.failureTracesJTable);
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPane, "Center");
        JPanel statisticsJPanel = new JPanel();
        statisticsJPanel.setLayout(new BorderLayout());
        JPanel labels = new JPanel();
        labels.setLayout(new GridLayout(2, 2));
        labels.add(new JLabel("Mean Failure Period"));
        labels.add(this.periodsMean);
        labels.add(new JLabel("Mean Up-time"));
        labels.add(this.interPeriodsMean);
        JButton applyButton = new JButton("Apply");
        applyButton.addActionListener(this);
        statisticsJPanel.add((Component)labels, "Center");
        statisticsJPanel.add((Component)applyButton, "South");
        this.add((Component)statisticsJPanel, "South");
    }

    public void refresh() {
        if (this.server.getFailureTrace() == null) {
            return;
        }
        FailureTrace ft = this.server.getFailureTrace();
        this.failureTracesJTable.setModel(new OurDefaultTableModel(this.headers, this.server.getFailureTrace().getNumbersOfPeriods()));
        int i = 0;
        while (i < ft.getNumbersOfPeriods()) {
            this.failureTracesJTable.setValueAt(this.formatter.format(ft.getFailurePeriods().get(i).getBeginningTime().getTime()), i, 0);
            this.failureTracesJTable.setValueAt(this.formatter.format(ft.getFailurePeriods().get(i).getEndTime().getTime()), i, 1);
            this.failureTracesJTable.setValueAt("Failed", i, 2);
            ++i;
        }
        this.periodsMean.setText(String.valueOf(ft.getMeanOfPeriodsInMinutes() / this.frame.getMapper().getTimeUnitInMinutes()));
        this.interPeriodsMean.setText(String.valueOf(ft.getMeanIfInterPeriodsInMinutes() / this.frame.getMapper().getTimeUnitInMinutes()));
    }

    public void actionPerformed(ActionEvent e) {
        this.applyInput();
    }

    public void applyInput() {
        double interPeriodsMean;
        double periodsMean;
        if (this.server.getFailureTrace() == null) {
            System.out.print("NULL");
            return;
        }
        try {
            periodsMean = Double.parseDouble(this.periodsMean.getText().trim());
            interPeriodsMean = Double.parseDouble(this.interPeriodsMean.getText().trim());
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this, "Means should be numbers", "Error", 0);
            return;
        }
        GregorianCalendar startTime = new GregorianCalendar();
        GregorianCalendar endTime = new GregorianCalendar();
        endTime.add(10, 48);
        this.server.getFailureTrace().fillTrace(startTime, endTime, periodsMean, interPeriodsMean, this.frame.getMapper().getTimeUnitInMinutes());
        this.refresh();
    }
}

