/*
 * Decompiled with CFR 0.152.
 */
package interfacing;

import interfacing.MainFrame;
import interfacing.NonEditableTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import mapping.LP_Solver;

public class LP_JPanel
extends JPanel {
    private static final long serialVersionUID = -6939332491088413670L;
    private MainFrame frame;
    private JTable deltaStarMatrixJTable;
    private JScrollPane deltaStarMatrixScrollPane;
    private JLabel lambdaJLabel;
    private JLabel rowJLabel;
    private JLabel stabilizableJLabel;
    private JButton buttonUpdate;
    private JPanel northPanel;
    final String iconsFolder = "Icons";
    Dimension d;

    public LP_JPanel(MainFrame frame) {
        this.frame = frame;
        this.setLayout(new BorderLayout());
        this.deltaStarMatrixJTable = new JTable();
        this.deltaStarMatrixScrollPane = new JScrollPane();
        this.northPanel = new JPanel();
        this.buttonUpdate = new JButton("Solve");
        this.lambdaJLabel = new JLabel();
        this.stabilizableJLabel = new JLabel();
        this.rowJLabel = new JLabel();
        this.buttonUpdate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LP_JPanel.this.refresh();
            }
        });
        this.northPanel.setLayout(new GridLayout(2, 1));
        this.northPanel.add(this.buttonUpdate);
        JPanel resultsPanel = new JPanel();
        this.lambdaJLabel.setBorder(BorderFactory.createEtchedBorder());
        this.rowJLabel.setBorder(BorderFactory.createEtchedBorder());
        this.stabilizableJLabel.setBorder(BorderFactory.createEtchedBorder());
        resultsPanel.add(this.lambdaJLabel);
        resultsPanel.add(this.rowJLabel);
        resultsPanel.add(this.stabilizableJLabel);
        this.northPanel.add(resultsPanel);
        this.buttonUpdate.setIcon(new ImageIcon("Icons/solve_22.png"));
        this.add((Component)this.northPanel, "First");
        this.add((Component)this.deltaStarMatrixScrollPane, "Center");
    }

    public void repaint() {
        super.repaint();
    }

    public void refresh() {
        double[][] deltaMatrix = null;
        Object[] results = null;
        try {
            results = LP_Solver.solveWithAjAndReturnFullDeltaStar(this.frame.getMapper().getServersTable(), this.frame.getMapper().getClassesTable());
            deltaMatrix = (double[][])results[0];
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.deltaStarMatrixJTable.setModel(new NonEditableTableModel(deltaMatrix.length, deltaMatrix[0].length));
        int i = 0;
        while (i < deltaMatrix.length) {
            int j = 0;
            while (j < deltaMatrix[i].length) {
                this.deltaStarMatrixJTable.setValueAt(deltaMatrix[i][j], i, j);
                ++j;
            }
            ++i;
        }
        int j = 0;
        while (j < deltaMatrix[0].length) {
            this.deltaStarMatrixJTable.getColumnModel().getColumn(j).setHeaderValue(String.valueOf(j + 1));
            ++j;
        }
        this.lambdaJLabel.setText("\u03bb * : " + (Double)results[1]);
        this.rowJLabel.setText("\u03c1* is " + 1.0 / (Double)results[1]);
        if ((Double)results[1] > 1.0) {
            this.stabilizableJLabel.setText("Stabilizable");
        } else {
            this.stabilizableJLabel.setText("Not Stabilizable");
        }
        this.deltaStarMatrixScrollPane.setViewportView(this.deltaStarMatrixJTable);
    }
}

