/*
 * Decompiled with CFR 0.152.
 */
package interfacing;

import interfacing.MainFrame;
import interfacing.OurDefaultTableModel;
import interfacing.ProgressBarFrame;
import interfacing.ServersTableModelListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.GregorianCalendar;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mapping.data.MessageToServer;
import mapping.data.Server;

public class ServersAvailabilityJPanel
extends JPanel
implements MouseListener,
PropertyChangeListener,
KeyListener {
    private static final long serialVersionUID = -1314942526341209428L;
    private String[] columnNames = new String[]{"ID", "Hostname"};
    private MainFrame frame;
    private JTable jTable;
    private OurDefaultTableModel tableModel;
    private ServersTableModelListener serversTableModelListener;
    private JScrollPane jTableScrollPane;
    private JSplitPane splitPane;
    private JScrollPane leftScrollPane;
    private JScrollPane rightScrollPane;
    private JPanel jTableContainer;
    private JPanel buttonsConatainers;
    private MessageToServerJPanel messagePanel;
    private JPanel rightJPanel;
    private JPanel serverLabelJPanel;
    private JLabel serverLabel;
    private JLabel serverName;
    private boolean editable = true;

    public ServersAvailabilityJPanel(MainFrame frame) {
        this.frame = frame;
        this.leftScrollPane = new JScrollPane();
        this.rightScrollPane = new JScrollPane();
        this.jTable = new JTable();
        this.jTableScrollPane = new JScrollPane();
        this.jTableContainer = new JPanel();
        this.setLayout(new BorderLayout());
        this.rightJPanel = new JPanel();
        this.rightJPanel.setLayout(new BorderLayout());
        this.serverLabelJPanel = new JPanel();
        this.serverLabel = new JLabel("Server: ");
        this.serverName = new JLabel();
        this.serverName.setFont(new Font("", 1, 13));
        this.serverLabelJPanel.add(this.serverLabel);
        this.serverLabelJPanel.add(this.serverName);
        this.rightJPanel.add((Component)this.serverLabelJPanel, "North");
        this.messagePanel = new MessageToServerJPanel(this);
        this.rightJPanel.add((Component)this.messagePanel, "Center");
        this.rightScrollPane.setViewportView(this.rightJPanel);
        this.splitPane = new JSplitPane(1, this.leftScrollPane, this.rightScrollPane);
        this.splitPane.setDividerLocation(450);
        this.serversTableModelListener = new ServersTableModelListener(this.frame);
        this.jTableContainer.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 1;
        gbConstraints.fill = 0;
        gbConstraints.anchor = 11;
        gbConstraints.gridheight = 1;
        gbConstraints.gridwidth = 1;
        this.jTableScrollPane.setViewportView(this.jTable);
        this.jTableContainer.add((Component)this.jTableScrollPane, gbConstraints);
        gbConstraints.gridy = 0;
        this.buttonsConatainers = new JPanel();
        this.jTableContainer.add((Component)this.buttonsConatainers, gbConstraints);
        gbConstraints.weighty = 1.0;
        gbConstraints.fill = 1;
        gbConstraints.gridy = 2;
        this.jTableContainer.add(Box.createVerticalGlue(), gbConstraints);
        this.leftScrollPane.setViewportView(this.jTableContainer);
        this.add(this.splitPane);
        this.jTable.setGridColor(Color.BLACK);
        this.jTable.setBackground(new Color(230, 230, 230));
        this.fillJTable();
        this.jTable.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.jTable.getColumnModel().getColumn(1).setPreferredWidth(250);
        this.jTable.setDragEnabled(false);
        int h = (1 + this.jTable.getModel().getRowCount()) * this.jTable.getRowHeight() + 100;
        this.setPreferredSize(new Dimension(600, h));
        this.splitPane.addPropertyChangeListener(this);
    }

    public void fillJTable() {
        this.tableModel = new OurDefaultTableModel(this.columnNames, 0);
        this.tableModel.setEditable(false);
        this.jTable.setModel(this.tableModel);
        this.jTable.addKeyListener(this);
        Object[] objects = this.frame.getMapper().getServersTable().keySet().toArray();
        int i = 0;
        while (i < objects.length) {
            Server server = this.frame.getMapper().getServer(i + 1);
            Object[] s = new String[]{String.valueOf(server.getIndex()), String.valueOf(server.getHostName())};
            this.tableModel.addRow(s);
            ++i;
        }
        this.jTable.getColumnModel().getColumn(0).setPreferredWidth(20);
        this.jTable.getColumnModel().getColumn(1).setPreferredWidth(350);
        this.jTable.addMouseListener(this);
        this.serversTableModelListener = new ServersTableModelListener(this.frame);
        this.tableModel.addTableModelListener(this.serversTableModelListener);
    }

    private void reSizeJTable() {
        int rowCount = 1 + this.jTable.getModel().getRowCount();
        int rowHeight = this.jTable.getRowHeight();
        int h = rowCount * rowHeight + 5;
        Dimension d = new Dimension(this.splitPane.getDividerLocation() - 10, h);
        this.jTable.setSize(d);
        this.jTableContainer.setPreferredSize(d);
        this.jTableScrollPane.setPreferredSize(d);
        this.rightJPanel.setPreferredSize(d);
        this.setPreferredSize(new Dimension(500, d.height + 100));
        this.repaint();
    }

    public void repaint() {
        if (this.jTable != null) {
            this.fillJTable();
        }
    }

    public void printModel(OurDefaultTableModel model) {
        int i = 0;
        while (i < model.getRowCount()) {
            int j = 0;
            while (j < model.getColumnCount()) {
                System.out.print(model.getValueAt(i, j) + " ");
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public void disableInput() {
        this.editable = false;
        this.tableModel.setEditable(false);
    }

    public void enableInput() {
        this.editable = true;
        this.tableModel.setEditable(true);
        if (this.editable) {
            this.editable = true;
        }
    }

    public boolean isThereASelection() {
        return this.jTable.getSelectedRowCount() > 0;
    }

    public void applyMessageAndFillTraces(MessageToServer message, double failuresPeriodsMean, double upTimeMean) {
        if (this.jTable.getSelectedRow() >= 0 && this.jTable.getSelectedRow() < this.frame.getMapper().getServersTable().size()) {
            ProgressBarFrame frame = new ProgressBarFrame("Servers", this.jTable.getSelectedRowCount());
            int i = 0;
            while (i < this.jTable.getSelectedRowCount()) {
                frame.changeProgress(i + 1, "Failure trace generations and message was applied to server " + (this.jTable.getSelectedRows()[i] + 1));
                this.frame.getMapper().getServer(this.jTable.getSelectedRows()[i] + 1).setAvailabilty(message.getAvailability());
                this.frame.getMapper().getServer(this.jTable.getSelectedRows()[i] + 1).setLastMessageSent((MessageToServer)message.clone());
                GregorianCalendar startTime = new GregorianCalendar();
                GregorianCalendar endTime = new GregorianCalendar();
                endTime.add(10, 48);
                this.frame.getMapper().getServer(this.jTable.getSelectedRows()[i] + 1).getFailureTrace().fillTrace(startTime, endTime, failuresPeriodsMean, upTimeMean, this.frame.getMapper().getTimeUnitInMinutes());
                System.out.println(message.toString());
                ++i;
            }
        }
    }

    public void applyMessage(MessageToServer message) {
        if (this.jTable.getSelectedRow() >= 0 && this.jTable.getSelectedRow() < this.frame.getMapper().getServersTable().size()) {
            ProgressBarFrame frame = new ProgressBarFrame("Servers", this.jTable.getSelectedRowCount());
            int i = 0;
            while (i < this.jTable.getSelectedRowCount()) {
                frame.changeProgress(i + 1, "Message was applied to server " + (this.jTable.getSelectedRows()[i] + 1));
                this.frame.getMapper().getServer(this.jTable.getSelectedRows()[i] + 1).setAvailabilty(message.getAvailability());
                this.frame.getMapper().getServer(this.jTable.getSelectedRows()[i] + 1).setLastMessageSent((MessageToServer)message.clone());
                System.out.println("Message: " + message.toString());
                ++i;
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.reSizeJTable();
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.jTable && this.jTable.getSelectedRow() >= 0 && this.jTable.getSelectedRow() < this.frame.getMapper().getServersTable().size()) {
            this.serverName.setText(((Server)this.frame.getMapper().getServersTable().get(this.jTable.getSelectedRow() + 1)).getHostName());
            this.messagePanel.setMessage(this.frame.getMapper().getServer(this.jTable.getSelectedRow() + 1).getLastMessageSent());
            if (this.jTable.getSelectedRowCount() > 1) {
                this.serverName.setText("Multiple");
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void keyPressed(KeyEvent arg0) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getSource() == this.jTable && this.jTable.getSelectedRow() >= 0 && this.jTable.getSelectedRow() < this.frame.getMapper().getServersTable().size()) {
            this.serverName.setText(((Server)this.frame.getMapper().getServersTable().get(this.jTable.getSelectedRow() + 1)).getHostName());
            this.messagePanel.setMessage(this.frame.getMapper().getServer(this.jTable.getSelectedRow() + 1).getLastMessageSent());
            if (this.jTable.getSelectedRowCount() > 1) {
                this.serverName.setText("Multiple");
            }
        }
    }

    public void keyTyped(KeyEvent arg0) {
    }

    public static class MessageToServerJPanel
    extends JPanel
    implements ActionListener,
    KeyListener,
    PropertyChangeListener,
    ChangeListener {
        private static final long serialVersionUID = -8429043770066937928L;
        JLabel[] labels;
        JComponent[] componenets;
        JLabel[] weightsLabels;
        JTextField[] weightsTF;
        JButton applyButton = new JButton("Apply");
        GridBagConstraints gbConstraints;
        MessageToServer message;
        JPanel mainPanel = new JPanel();
        WeightsPanel weighstPanel = new WeightsPanel(4);
        JPanel buttonsPanel = new JPanel();
        ServersAvailabilityJPanel container;

        public MessageToServerJPanel(ServersAvailabilityJPanel container) {
            this.container = container;
            this.mainPanel.setLayout(new GridBagLayout());
            this.labels = new JLabel[4];
            this.labels[0] = new JLabel("Availability");
            this.labels[1] = new JLabel("Period");
            this.labels[2] = new JLabel("Availability Mode");
            this.labels[3] = new JLabel("N");
            this.componenets = new JComponent[4];
            this.componenets[0] = new JTextField(10);
            this.componenets[1] = new JTextField(10);
            this.componenets[2] = new JComboBox();
            ((JComboBox)this.componenets[2]).addItem(new String("Weighted Average"));
            ((JComboBox)this.componenets[2]).addItem(new String("Recursive"));
            ((JComboBox)this.componenets[2]).addItem(new String("Non Active"));
            ((JComboBox)this.componenets[2]).setSelectedIndex(0);
            ((JComboBox)this.componenets[2]).addActionListener(this);
            this.componenets[3] = new JTextField(10);
            ((JTextField)this.componenets[3]).addKeyListener(this);
            ((JTextField)this.componenets[3]).addPropertyChangeListener(this);
            this.gbConstraints = new GridBagConstraints();
            this.gbConstraints.insets = new Insets(3, 3, 3, 3);
            this.gbConstraints.fill = 17;
            this.gbConstraints.anchor = 17;
            this.gbConstraints.gridheight = 1;
            this.gbConstraints.gridwidth = 1;
            int i = 0;
            while (i < this.labels.length) {
                this.gbConstraints.gridy = i;
                this.gbConstraints.gridx = 0;
                this.mainPanel.add((Component)this.labels[i], this.gbConstraints);
                this.gbConstraints.gridx = 1;
                this.mainPanel.add((Component)this.componenets[i], this.gbConstraints);
                ++i;
            }
            if (((JComboBox)this.componenets[2]).getSelectedIndex() == 0) {
                this.labels[3].setText("N");
                if (this.message != null) {
                    ((JTextField)this.componenets[3]).setText(String.valueOf(this.message.getN()));
                }
            }
            this.gbConstraints.fill = 1;
            this.gbConstraints.gridy = i;
            this.mainPanel.add(Box.createVerticalGlue(), this.gbConstraints);
            this.weighstPanel.refresh(4);
            this.buttonsPanel.add(this.applyButton);
            this.applyButton.addActionListener(this);
            this.setLayout(new GridBagLayout());
            this.gbConstraints = new GridBagConstraints();
            this.gbConstraints.insets = new Insets(3, 3, 3, 3);
            this.gbConstraints.anchor = 19;
            this.gbConstraints.gridheight = 1;
            this.gbConstraints.gridwidth = 1;
            this.gbConstraints.gridx = 0;
            this.gbConstraints.gridy = 0;
            this.add((Component)this.mainPanel, this.gbConstraints);
            this.gbConstraints.gridy = 1;
            this.add((Component)this.weighstPanel, this.gbConstraints);
            this.gbConstraints.gridy = 2;
            this.add((Component)this.buttonsPanel, this.gbConstraints);
            this.gbConstraints.fill = 1;
            this.gbConstraints.gridy = 3;
            this.gbConstraints.gridx = 0;
            this.gbConstraints.weighty = 1.0;
            this.add(Box.createVerticalGlue(), this.gbConstraints);
        }

        public void hideWeights() {
            this.weighstPanel.setVisible(false);
            this.repaint();
        }

        public void showWeights() {
            this.weighstPanel.setVisible(true);
            this.repaint();
        }

        public void setMessage(MessageToServer message) {
            this.message = message;
            this.refreshValues();
        }

        public void refreshValues() {
            if (this.labels == null) {
                return;
            }
            DecimalFormat formatter = new DecimalFormat();
            formatter.setMaximumFractionDigits(4);
            if (this.message != null) {
                ((JTextField)this.componenets[0]).setText(String.valueOf(this.message.getAvailability()));
                ((JTextField)this.componenets[1]).setText(String.valueOf(this.message.getForHowLong()));
                ((JComboBox)this.componenets[2]).setSelectedIndex(this.message.getAvailabilityMode());
            }
            if (((JComboBox)this.componenets[2]).getSelectedIndex() == 1) {
                this.labels[3].setText("C");
                if (this.message != null) {
                    ((JTextField)this.componenets[3]).setText(String.valueOf(this.message.getC()));
                }
            }
            if (((JComboBox)this.componenets[2]).getSelectedIndex() == 0) {
                this.labels[3].setText("N");
                if (this.message != null) {
                    ((JTextField)this.componenets[3]).setText(String.valueOf(this.message.getWeights().length));
                }
                if (this.message != null) {
                    this.weighstPanel.refresh(this.message.getWeights());
                }
            }
        }

        public void clearValues() {
            ((JTextField)this.componenets[0]).setText("");
            ((JTextField)this.componenets[1]).setText("");
            ((JTextField)this.componenets[2]).setText("");
            ((JTextField)this.componenets[3]).setText("");
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.componenets[2]) {
                if (((JComboBox)this.componenets[2]).getSelectedIndex() == 1) {
                    this.labels[3].setText("C");
                    this.hideWeights();
                    this.labels[3].setVisible(true);
                    this.componenets[3].setVisible(true);
                    ((JTextField)this.componenets[3]).setText(String.valueOf(this.message.getC()));
                    return;
                }
                if (((JComboBox)this.componenets[2]).getSelectedIndex() == 0) {
                    this.labels[3].setText("N");
                    this.showWeights();
                    this.labels[3].setVisible(true);
                    this.componenets[3].setVisible(true);
                    ((JTextField)this.componenets[3]).setText(String.valueOf(this.message.getWeights().length));
                    this.weighstPanel.refresh(this.message.getWeights());
                    return;
                }
                if (((JComboBox)this.componenets[2]).getSelectedIndex() == 2) {
                    this.labels[3].setText("N");
                    this.hideWeights();
                    this.labels[3].setVisible(false);
                    this.componenets[3].setVisible(false);
                    return;
                }
                return;
            }
            if (e.getSource() == this.applyButton) {
                block16: {
                    if (!this.container.isThereASelection()) {
                        JOptionPane.showMessageDialog(this.container, "Please select the servers.", "Error", 0);
                        return;
                    }
                    try {
                        this.message.setAvailability(Double.parseDouble(((JTextField)this.componenets[0]).getText()));
                    }
                    catch (NumberFormatException ex) {
                        JOptionPane.showMessageDialog(this, "Availability should be a double value.", "Error", 0);
                        return;
                    }
                    try {
                        this.message.setForHowLong(Double.parseDouble(((JTextField)this.componenets[1]).getText()));
                    }
                    catch (NumberFormatException ex) {
                        JOptionPane.showMessageDialog(this, "For how long should be a double value.", "Error", 0);
                        return;
                    }
                    this.message.setAvailabilityMode(((JComboBox)this.componenets[2]).getSelectedIndex());
                    if (this.message.getAvailabilityMode() == 1) {
                        try {
                            this.message.setC(Double.parseDouble(((JTextField)this.componenets[3]).getText()));
                        }
                        catch (NumberFormatException ex) {
                            if (this.message.getAvailability() == 2.0) break block16;
                            JOptionPane.showMessageDialog(this.container, String.valueOf(this.labels[3].getText().toUpperCase()) + " should be a double value.", "Error", 0);
                            return;
                        }
                    }
                }
                this.message.setWeights(this.weighstPanel.getWeights());
                if (this.message.getWeights() == null && this.message.getAvailabilityMode() == 0) {
                    JOptionPane.showMessageDialog(this, "Weights should be numbers", "Error", 0);
                }
                if (this.message.getWeights() == null || this.message.getAvailabilityMode() == 1 || this.message.getAvailabilityMode() == 2) {
                    this.message.setWeights(new double[1]);
                    this.message.setN(1);
                } else {
                    this.message.setN(this.message.getWeights().length);
                }
                this.container.applyMessage(this.message);
            }
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            if (e.getSource() == this.componenets[3]) {
                if (((JComboBox)this.componenets[2]).getSelectedIndex() == 1) {
                    return;
                }
                if (((JComboBox)this.componenets[2]).getSelectedIndex() == 0) {
                    try {
                        int n = Integer.parseInt(((JTextField)this.componenets[3]).getText());
                        if (n > 15) {
                            n = 15;
                        }
                        this.message.setN(n);
                        ((JTextField)this.componenets[3]).setText(String.valueOf(this.message.getN()));
                    }
                    catch (NumberFormatException ex) {
                        return;
                    }
                    this.weighstPanel.refresh(this.message.getN());
                }
                return;
            }
        }

        public void keyTyped(KeyEvent e) {
        }

        public void stateChanged(ChangeEvent arg0) {
        }

        public void propertyChange(PropertyChangeEvent evt) {
        }
    }

    public static class WeightsPanel
    extends JPanel {
        private static final long serialVersionUID = 1943145759520180425L;
        JLabel[] weightsLabel;
        JTextField[] weightsTF;

        public WeightsPanel(int N) {
            this.setLayout(new GridLayout(N, 2));
            this.weightsLabel = new JLabel[N];
            this.weightsTF = new JTextField[N];
            int i = 0;
            while (i < N) {
                this.weightsLabel[i] = new JLabel("W_" + (i + 1));
                this.weightsTF[i] = new JTextField(5);
                this.add(this.weightsLabel[i]);
                this.add(this.weightsTF[i]);
                ++i;
            }
        }

        public void refresh(int N) {
            this.removeAll();
            this.setLayout(new GridLayout(N, 2));
            this.weightsLabel = new JLabel[N];
            this.weightsTF = new JTextField[N];
            int i = 0;
            while (i < N) {
                this.weightsLabel[i] = new JLabel("W_" + (i + 1));
                this.weightsTF[i] = new JTextField(5);
                this.add(this.weightsLabel[i]);
                this.add(this.weightsTF[i]);
                ++i;
            }
            this.setVisible(false);
            this.setVisible(true);
            this.repaint();
        }

        public void refresh(double[] a) {
            if (a == null) {
                return;
            }
            this.removeAll();
            this.setLayout(new GridLayout(a.length, 2));
            this.weightsLabel = new JLabel[a.length];
            this.weightsTF = new JTextField[a.length];
            int i = 0;
            while (i < a.length) {
                this.weightsLabel[i] = new JLabel("W_" + (i + 1));
                this.weightsTF[i] = new JTextField(5);
                this.add(this.weightsLabel[i]);
                this.add(this.weightsTF[i]);
                this.weightsTF[i].setText(String.valueOf(a[i]));
                ++i;
            }
            this.setVisible(false);
            this.setVisible(true);
            this.repaint();
        }

        public double[] getWeights() {
            double[] array = new double[this.weightsTF.length];
            int i = 0;
            while (i < this.weightsTF.length) {
                try {
                    array[i] = Double.parseDouble(this.weightsTF[i].getText().trim());
                }
                catch (NumberFormatException ex) {
                    return null;
                }
                ++i;
            }
            return array;
        }
    }
}

