/*
 * Decompiled with CFR 0.152.
 */
package interfacing;

import interfacing.ExtensionFileFilter;
import interfacing.FailuresTraceJPanel;
import interfacing.MainFrame;
import interfacing.OurDefaultTableModel;
import interfacing.PropertiesJPanel;
import interfacing.ServersProcessingRatesJPanel;
import interfacing.ServersTableModelListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import logging.MueReader;
import logging.ServersReader;
import mapping.data.Server;
import mapping.data.ServersTableListener;

public class ServersTableJPanel
extends JPanel
implements PropertyChangeListener,
ActionListener,
MouseListener,
KeyListener,
ServersTableListener {
    private static final long serialVersionUID = -1314942526341209428L;
    private String[] columnNames = new String[]{"ID", "Hostname", "Down"};
    private MainFrame frame;
    private JTable jTable;
    private OurDefaultTableModel tableModel;
    private ServersTableModelListener serversTableModelListener;
    private JScrollPane jTableScrollPane;
    private JSplitPane splitPane;
    private JScrollPane leftScrollPane;
    private JScrollPane rightScrollPane;
    private JPanel jTableContainer;
    private JButton addButton;
    private JButton removeButton;
    final JFileChooser fileChooser = new JFileChooser();
    private JButton importButton;
    private JButton importPRButton;
    private JPanel buttonsConatainers;
    private PropertiesJPanel propPanel;
    private JButton addServerButton;
    private JPanel propPanelContainer;
    private ServersProcessingRatesJPanel serversProcessingRates;
    private JPanel rightJPanel;
    private JPanel serverLabelJPanel;
    private JLabel serverLabel;
    private JLabel serverName;
    private JTabbedPane rightTabbedPane;
    private ServersProcessingRatesJPanel processingRatesJPanel;
    private FailuresTraceJPanel failureTracesJPanel;
    private final int PROCESSING_RATES = 0;
    private final int FAILURE_RATES = 1;
    private int rightTabbedPaneContent = 0;
    private boolean editable = true;

    public ServersTableJPanel(MainFrame frame) {
        this.frame = frame;
        this.leftScrollPane = new JScrollPane();
        this.rightScrollPane = new JScrollPane();
        this.jTable = new JTable();
        this.jTableScrollPane = new JScrollPane();
        this.jTableContainer = new JPanel();
        this.setLayout(new BorderLayout());
        this.rightJPanel = new JPanel();
        this.rightJPanel.setLayout(new BorderLayout());
        this.serverLabelJPanel = new JPanel();
        this.serverLabel = new JLabel("Server: ");
        this.serverName = new JLabel();
        this.serverName.setFont(new Font("", 1, 13));
        this.serverLabelJPanel.add(this.serverLabel);
        this.serverLabelJPanel.add(this.serverName);
        this.rightJPanel.add((Component)this.serverLabelJPanel, "North");
        this.rightTabbedPane = new JTabbedPane();
        this.processingRatesJPanel = new ServersProcessingRatesJPanel();
        this.failureTracesJPanel = new FailuresTraceJPanel();
        this.rightTabbedPane.add("Processing Rates", this.processingRatesJPanel);
        this.rightTabbedPane.add("Failure Periods", this.failureTracesJPanel);
        this.rightJPanel.add((Component)this.rightTabbedPane, "Center");
        this.rightTabbedPane.addMouseListener(this);
        this.rightScrollPane.setViewportView(this.rightJPanel);
        this.splitPane = new JSplitPane(1, this.leftScrollPane, this.rightScrollPane);
        this.splitPane.setDividerLocation(450);
        this.serversTableModelListener = new ServersTableModelListener(this.frame);
        this.jTableContainer.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 1;
        gbConstraints.fill = 0;
        gbConstraints.anchor = 11;
        gbConstraints.gridheight = 1;
        gbConstraints.gridwidth = 1;
        this.jTableScrollPane.setViewportView(this.jTable);
        this.jTableContainer.add((Component)this.jTableScrollPane, gbConstraints);
        gbConstraints.gridy = 0;
        this.buttonsConatainers = new JPanel();
        this.importButton = new JButton("Import Servers");
        this.importButton.setIcon(new ImageIcon("Icons/filerevert_22.png"));
        this.importButton.addActionListener(this);
        this.addButton = new JButton("");
        this.addButton.setIcon(new ImageIcon("Icons/edit_add_22.png"));
        this.addButton.addActionListener(this);
        this.removeButton = new JButton("");
        this.removeButton.setIcon(new ImageIcon("Icons/edit_remove_22.png"));
        this.removeButton.addActionListener(this);
        this.importPRButton = new JButton("Import Mue");
        this.importPRButton.setIcon(new ImageIcon("Icons/import_u_22.png"));
        this.importPRButton.addActionListener(this);
        this.buttonsConatainers.add(this.importButton);
        this.buttonsConatainers.add(this.addButton);
        this.buttonsConatainers.add(this.removeButton);
        this.buttonsConatainers.add(this.importPRButton);
        this.jTableContainer.add((Component)this.buttonsConatainers, gbConstraints);
        gbConstraints.weighty = 1.0;
        gbConstraints.fill = 1;
        gbConstraints.gridy = 2;
        this.jTableContainer.add(Box.createVerticalGlue(), gbConstraints);
        this.leftScrollPane.setViewportView(this.jTableContainer);
        this.add(this.splitPane);
        this.jTable.setGridColor(Color.BLACK);
        this.jTable.setSelectionMode(0);
        this.buildPropretyJPanel();
        this.hidePropertyJPanel();
        this.fillJTable();
        this.jTable.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.jTable.getColumnModel().getColumn(1).setPreferredWidth(250);
        this.jTable.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.jTable.setDragEnabled(false);
        int h = (1 + this.jTable.getModel().getRowCount()) * this.jTable.getRowHeight() + 100;
        this.setPreferredSize(new Dimension(600, h));
        this.splitPane.addPropertyChangeListener(this);
        this.jTable.addMouseListener(this);
        this.jTable.addKeyListener(this);
    }

    public void fillJTable() {
        this.tableModel = new OurDefaultTableModel(this.columnNames, 0);
        this.jTable.setModel(this.tableModel);
        Object[] objects = this.frame.getMapper().getServersTable().keySet().toArray();
        int i = 0;
        while (i < objects.length) {
            Server server = this.frame.getMapper().getServer(i + 1);
            String downString = this.frame.getMapper().getServersTable().isServerDown(i + 1) ? "Down" : "Up";
            Object[] s = new String[]{String.valueOf(server.getIndex()), String.valueOf(server.getHostName()), String.valueOf(downString)};
            this.tableModel.addRow(s);
            ++i;
        }
        this.jTable.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.jTable.getColumnModel().getColumn(1).setPreferredWidth(250);
        this.jTable.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.serversTableModelListener = new ServersTableModelListener(this.frame);
        this.tableModel.addTableModelListener(this.serversTableModelListener);
    }

    public void buildPropretyJPanel() {
        String[] names = new String[]{"Hostname"};
        this.propPanel = new PropertiesJPanel(names, null);
        this.addServerButton = new JButton("Add Server");
        this.addServerButton.addActionListener(this);
        this.propPanelContainer = new JPanel();
        this.propPanelContainer.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 10;
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 0;
        this.propPanelContainer.add((Component)this.propPanel, gbConstraints);
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 1;
        this.propPanelContainer.add((Component)this.addServerButton, gbConstraints);
        gbConstraints.weighty = 1.0;
        gbConstraints.fill = 1;
        gbConstraints.gridy = 2;
        this.propPanelContainer.add(Box.createVerticalGlue(), gbConstraints);
        gbConstraints.gridheight = 3;
        gbConstraints.weightx = 0.0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridx = 1;
        gbConstraints.gridy = 0;
        this.propPanelContainer.add(Box.createHorizontalGlue(), gbConstraints);
        this.repaint();
    }

    private void reSizeJTable() {
        if (this.jTable == null) {
            return;
        }
        int rowCount = 1 + this.jTable.getModel().getRowCount();
        int rowHeight = this.jTable.getRowHeight();
        int h = rowCount * rowHeight + 5;
        Dimension d = new Dimension(this.splitPane.getDividerLocation() - 10, h);
        this.jTable.setSize(d);
        this.jTableContainer.setPreferredSize(d);
        this.jTableScrollPane.setPreferredSize(d);
        this.rightJPanel.setPreferredSize(d);
        this.setPreferredSize(new Dimension(500, d.height + 100));
    }

    public void actionPerformed(ActionEvent e) {
        int returnVal;
        ExtensionFileFilter filter;
        if (e.getSource() == this.importButton) {
            filter = new ExtensionFileFilter("SRS", new String[]{"SRS"});
            this.fileChooser.setCurrentDirectory(new File("Servers/servers.srs"));
            this.fileChooser.setFileFilter(filter);
            returnVal = this.fileChooser.showOpenDialog(this);
            if (returnVal == 0) {
                ServersReader.readServersFromFile(this.fileChooser.getSelectedFile().getPath(), this.frame.getMapper().getServersTable());
                this.frame.getMapper().fillProcessingRates();
            }
            this.fillJTable();
        }
        if (e.getSource() == this.addServerButton) {
            if (this.propPanel.getValue(0).trim().equalsIgnoreCase("")) {
                JOptionPane.showMessageDialog(this, "Please enter valid HostName.", "Error", 0);
                return;
            }
            this.frame.getMapper().getServersTable().addServer(new Server(this.propPanel.getValue(0)));
            this.fillJTable();
            this.hidePropertyJPanel();
            this.splitPane.setDividerLocation(this.splitPane.getDividerLocation() + 1);
        }
        if (e.getSource() == this.addButton) {
            this.showPropertyJPanelToAddServer();
        }
        if (e.getSource() == this.removeButton) {
            int previousSelection = -1;
            if (this.jTable.getSelectedRow() >= 0) {
                previousSelection = this.jTable.getSelectedRow();
            }
            this.removeSelectedServer();
            if (previousSelection >= 0 && this.jTable.getModel().getRowCount() > 0) {
                this.jTable.getSelectionModel().setSelectionInterval(previousSelection, previousSelection);
            }
            this.showServerInfo();
            this.repaint();
        }
        if (e.getSource() == this.importPRButton) {
            filter = new ExtensionFileFilter("MUE", new String[]{"MUE"});
            this.fileChooser.setFileFilter(filter);
            this.fileChooser.setCurrentDirectory(null);
            returnVal = this.fileChooser.showOpenDialog(this);
            if (returnVal == 0) {
                try {
                    MueReader.readMue(this.frame.getMapper(), this.fileChooser.getSelectedFile().getPath());
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, "Mue file has invalid format!\nPlease make sure the file has " + this.frame.getMapper().getClassesTable().size() + " lines (one for every job class) and " + this.frame.getMapper().getServersTable().size() + " comma-separated numbers in each line (for every server). ", "Error", 0);
                }
            }
            this.showServerInfo();
        }
    }

    public void showPropertyJPanelToAddServer() {
        this.rightScrollPane.setViewportView(this.propPanelContainer);
        this.propPanel.clearFields();
        this.propPanelContainer.setVisible(true);
    }

    public void hidePropertyJPanel() {
        this.propPanelContainer.setVisible(false);
    }

    public void removeSelectedServer() {
        if (this.jTable.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "Please select a server from the table.", "Error", 0);
            return;
        }
        this.frame.getMapper().getServersTable().removeServer(this.jTable.getSelectedRow() + 1);
        this.fillJTable();
        this.splitPane.setDividerLocation(this.splitPane.getDividerLocation());
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.jTable) {
            return;
        }
        this.reSizeJTable();
    }

    public void printModel(OurDefaultTableModel model) {
        int i = 0;
        while (i < model.getRowCount()) {
            int j = 0;
            while (j < model.getColumnCount()) {
                System.out.print(model.getValueAt(i, j) + " ");
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public void disableInput() {
        this.editable = false;
        this.tableModel.setEditable(false);
        if (this.serversProcessingRates != null) {
            this.serversProcessingRates.disableInput();
        }
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.importButton.setEnabled(false);
    }

    public void enableInput() {
        this.editable = true;
        this.tableModel.setEditable(true);
        if (this.serversProcessingRates != null) {
            this.serversProcessingRates.enableInput();
        }
        this.addButton.setEnabled(true);
        this.removeButton.setEnabled(true);
        this.importButton.setEnabled(true);
    }

    public void showServerInfo() {
        if (this.serverName == null) {
            return;
        }
        if (this.jTable.getSelectedRow() < 0 || this.jTable.getSelectedRow() > this.frame.getMapper().getServersTable().size()) {
            this.serverName.setText("Not Selected");
            this.rightTabbedPane.remove(this.processingRatesJPanel);
            this.rightTabbedPane.remove(this.failureTracesJPanel);
            return;
        }
        if (this.frame.getMapper().getServer(this.jTable.getSelectedRow() + 1) == null) {
            return;
        }
        this.serverName.setText(this.frame.getMapper().getServer(this.jTable.getSelectedRow() + 1).getHostName());
        this.rightTabbedPane.remove(this.processingRatesJPanel);
        this.rightTabbedPane.remove(this.failureTracesJPanel);
        this.processingRatesJPanel = new ServersProcessingRatesJPanel(this.frame, this.jTable.getSelectedRow() + 1);
        if (!this.editable && this.serversProcessingRates != null) {
            this.serversProcessingRates.disableInput();
        }
        this.failureTracesJPanel = new FailuresTraceJPanel(this.frame, this.frame.getMapper().getServer(this.jTable.getSelectedRow() + 1));
        this.rightTabbedPane.add("Processing Rates", this.processingRatesJPanel);
        this.rightTabbedPane.add("Failure Periods", this.failureTracesJPanel);
        this.rightTabbedPane.repaint();
        this.rightScrollPane.setViewportView(this.rightJPanel);
        this.rightTabbedPane.setSelectedIndex(this.rightTabbedPaneContent);
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.jTable && this.jTable.getSelectedRow() >= 0 && this.jTable.getSelectedRow() < this.frame.getMapper().getServersTable().size()) {
            this.showServerInfo();
        }
        if (e.getSource() == this.rightTabbedPane) {
            if (this.rightTabbedPane.getSelectedIndex() == 0) {
                this.rightTabbedPaneContent = 0;
            }
            if (this.rightTabbedPane.getSelectedIndex() == 1) {
                this.rightTabbedPaneContent = 1;
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void repaint() {
        super.repaint();
        this.reSizeJTable();
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getSource() == this.jTable && this.jTable.getSelectedRow() >= 0 && this.jTable.getSelectedRow() < this.frame.getMapper().getServersTable().size()) {
            this.showServerInfo();
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void ServersTableLister(long serverID, String hostname, String password, boolean down) {
    }

    public void hostNameChanged(int serverID, String hostname) {
    }

    public void passwordChanged(int serverID, String password) {
    }

    public void upDownStatusChanged(int serverID, boolean down) {
        if (down) {
            this.jTable.getModel().setValueAt("Down", serverID - 1, 2);
        } else {
            this.jTable.getModel().setValueAt("Up", serverID - 1, 2);
        }
    }
}

