/*
 * Decompiled with CFR 0.152.
 */
package mapping;

import adjusting.Adjuster;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import logging.Logger;
import mapping.Mapper;
import mapping.data.Server;

public class TimeOutAnnouncer
implements Runnable {
    private LinkedList<TimeNode> list = new LinkedList();
    private long currentSleepTime;
    private boolean alive = true;
    private Mapper mapper;
    private final long DEFAULT_SLEEP_TIME = 5000L;
    private Thread thisThread;
    Logger timeOutLogger = new Logger("timeout");

    public TimeOutAnnouncer(Mapper mapper) {
        this.setMapper(mapper);
    }

    public synchronized long getCurrentSleepTime() {
        return this.currentSleepTime;
    }

    public synchronized void setCurrentSleepTime(long currentSleepTime) {
        this.currentSleepTime = currentSleepTime;
    }

    public synchronized boolean isAlive() {
        return this.alive;
    }

    public synchronized void setAlive(boolean alive) {
        this.alive = alive;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    public Logger getTimeOutLogger() {
        return this.timeOutLogger;
    }

    public void setTimeOutLogger(Logger timeOutLogger) {
        this.timeOutLogger = timeOutLogger;
    }

    public void add(double AfterInTU, long jobID) {
        this.addSorted(new TimeNode(AfterInTU * this.getMapper().getTimeUnitInMinutes(), jobID));
    }

    private void addSorted(TimeNode node) {
        if (this.list.isEmpty()) {
            this.list.add(node);
            if (this.thisThread != null) {
                this.thisThread.interrupt();
            }
            return;
        }
        int i = 0;
        while (i < this.list.size()) {
            if (node.time.before(this.list.get((int)i).time)) {
                this.list.add(i, node);
                if (i == 0 && this.thisThread != null) {
                    this.thisThread.interrupt();
                }
                return;
            }
            ++i;
        }
        this.list.add(node);
    }

    public void startThread() {
        this.thisThread = new Thread(this);
        this.thisThread.start();
    }

    public void stopThread() {
        this.setAlive(false);
        this.thisThread.interrupt();
        this.thisThread = null;
    }

    public void print() {
        System.out.println("Size: " + this.list.size());
        System.out.println("now: " + new GregorianCalendar().getTime().toString() + "\n");
        int i = 0;
        while (i < this.list.size()) {
            System.out.println(this.list.get(i).toString());
            ++i;
        }
    }

    public void run() {
        this.upDateCurrentSleepTime();
        while (this.isAlive()) {
            try {
                Thread.sleep(this.getCurrentSleepTime());
            }
            catch (InterruptedException e) {
                if (!this.isAlive()) {
                    return;
                }
                this.upDateCurrentSleepTime();
                continue;
            }
            if (this.list.isEmpty()) continue;
            String status = this.getMapper().getJobsTable().getJobStatus(this.list.get((int)0).jobID);
            if (!status.equals("Done") && !status.equals("Queued")) {
                GregorianCalendar current = new GregorianCalendar();
                Server server = this.getMapper().getJobsTable().getJobServer(this.list.get((int)0).jobID);
                if (!Adjuster.isServerSufferingFromAFailure(current, server)) {
                    System.err.println("TimeOutAnnouncer: " + server.getHostName() + " is declared UP!:)");
                    this.getMapper().getServersTable().setServerDown(server.getIndex(), false);
                    this.getMapper().getServersTable().clearServerActiveJobsNumber(server.getIndex());
                    this.getMapper().getMappingScheme().serverIsUp(server.getIndex());
                    this.getMapper().getAvailableServersQueue().enqueue(server.getIndex());
                } else {
                    GregorianCalendar endOfFailure = Adjuster.getEndOFFailurePeriod(current, server);
                    long differenceInMilliSeconds = endOfFailure.getTimeInMillis() - current.getTimeInMillis();
                    this.getMapper().getEndOfFailureAnnouncer().add((double)differenceInMilliSeconds / 1000.0 / 60.0, server);
                    System.err.println("TimeOutAnnouncer: " + server.getHostName() + " is declared DOWN!!!");
                    this.getMapper().getServersTable().setServerDown(server.getIndex(), true);
                    this.getMapper().getMappingScheme().serverIsDown(server.getIndex());
                }
                this.getTimeOutLogger().log("Job " + this.list.get((int)0).jobID + "timed out");
                System.err.println("TimeOutAnnouncer.run: Time out happened. Job: " + this.list.get((int)0).jobID + " It was assigned to server " + this.mapper.getJobsTable().getJobHostName(this.list.get((int)0).jobID));
                this.getMapper().jobTimedOut(this.list.get((int)0).jobID);
                this.list.remove(0);
                continue;
            }
            if (!this.list.isEmpty()) {
                this.list.remove(0);
            }
            this.upDateCurrentSleepTime();
        }
    }

    public void upDateCurrentSleepTime() {
        if (this.list.isEmpty()) {
            this.setCurrentSleepTime(5000L);
        } else {
            long sleepTime = this.list.get((int)0).time.getTimeInMillis() - new GregorianCalendar().getTimeInMillis();
            if (sleepTime < 0L) {
                sleepTime = 1L;
            }
            this.setCurrentSleepTime(sleepTime);
        }
        GregorianCalendar timeToWakeUp = new GregorianCalendar();
        timeToWakeUp.add(14, (int)this.getCurrentSleepTime());
    }

    public static class TimeNode {
        GregorianCalendar time;
        long jobID;

        public TimeNode(GregorianCalendar cal, long jobID) {
            this.time = cal;
            this.jobID = jobID;
        }

        public TimeNode(double AfterInMinutes, long jobID) {
            this.time = new GregorianCalendar();
            this.time.add(13, (int)((AfterInMinutes - Math.floor(AfterInMinutes)) * 60.0));
            this.time.add(12, (int)Math.floor(AfterInMinutes));
            this.jobID = jobID;
        }

        public String toString() {
            return "Job: " + this.jobID + " at " + this.time.getTime().toString();
        }
    }
}

