/*
 * Decompiled with CFR 0.152.
 */
package mapping.data;

import adjusting.availability_adjusting.FailureTrace;
import java.io.Serializable;
import java.util.Hashtable;
import mapping.data.MessageToServer;
import mapping.data.ProcessingRatesPair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server
implements Serializable {
    private static final long serialVersionUID = 1536111816370136326L;
    private String hostName;
    private int numberOfActiveJobs = 0;
    private double timeToBeTaskFree;
    private Hashtable<Integer, ProcessingRatesPair> processingRates;
    private double availabilty = 1.0;
    private double previousAvailability = 1.0;
    private int index;
    private boolean down = false;
    private FailureTrace failureTrace;
    private MessageToServer lastMessageSent;

    public Server(String hostName) {
        this.setHostName(hostName);
        this.setProcessingRates(new Hashtable<Integer, ProcessingRatesPair>());
        this.setFailureTrace(new FailureTrace());
        this.setLastMessageSent(new MessageToServer());
    }

    public double getTimeToBeTaskFree() {
        return this.timeToBeTaskFree;
    }

    protected void setTimeToBeTaskFree(double timeToBeTaskFree) {
        this.timeToBeTaskFree = timeToBeTaskFree;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public synchronized int getNumberOfActiveJobs() {
        return this.numberOfActiveJobs;
    }

    private void setNumberOfActiveJobs(int numberOfActiveJobs) {
        this.numberOfActiveJobs = numberOfActiveJobs;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    protected void print() {
        System.out.print("Host Name: " + this.getHostName() + ", busy for : " + this.getTimeToBeTaskFree() + " time units.");
    }

    public void setAvailabilty(double availabilty) {
        this.availabilty = availabilty;
    }

    public double getAvailability() {
        return this.availabilty;
    }

    public double getPreviousAvailability() {
        return this.previousAvailability;
    }

    public void setPreviousAvailability(double previousAvailability) {
        this.previousAvailability = previousAvailability;
    }

    public FailureTrace getFailureTrace() {
        return this.failureTrace;
    }

    public void setFailureTrace(FailureTrace failureTrace) {
        this.failureTrace = failureTrace;
    }

    protected boolean isDown() {
        return this.down;
    }

    protected void setDown(boolean down) {
        if (down) {
            this.setPreviousAvailability(this.getAvailability());
            this.setAvailabilty(0.0);
        } else if (this.down) {
            this.setAvailabilty(this.getPreviousAvailability());
        }
        this.down = down;
    }

    public MessageToServer getLastMessageSent() {
        return this.lastMessageSent;
    }

    public void setLastMessageSent(MessageToServer lastMessageSent) {
        this.lastMessageSent = lastMessageSent;
    }

    protected void printprocessingRates() {
        System.out.print(" { ");
        System.out.print(this.processingRates.toString());
        System.out.print(" }");
    }

    public Hashtable<Integer, ProcessingRatesPair> getProcessingRates() {
        return this.processingRates;
    }

    public void setProcessingRates(Hashtable<Integer, ProcessingRatesPair> processingRate) {
        this.processingRates = processingRate;
    }

    public synchronized void addProcessingRate(ProcessingRatesPair pair, int jobClassID) {
        this.getProcessingRates().put(jobClassID, pair);
    }

    public synchronized void addProcessingRate(double realRate, double assumedRate, int jobClassID) {
        this.getProcessingRates().put(jobClassID, new ProcessingRatesPair(realRate, assumedRate));
    }

    public synchronized ProcessingRatesPair getProcessingRate(int jobClassID) {
        return this.getProcessingRates().get(jobClassID);
    }

    public synchronized double getAssumedRate(int jobClassID) {
        return this.getProcessingRates().get(jobClassID).getAssumedRate();
    }

    public synchronized double getRealRate(int jobClassID) {
        return this.getProcessingRates().get(jobClassID).getRealRate();
    }

    public synchronized void incrementActiveJobsNumber() {
        this.setNumberOfActiveJobs(this.getNumberOfActiveJobs() + 1);
    }

    public synchronized void decrementActiveJobsNumber() {
        this.setNumberOfActiveJobs(this.getNumberOfActiveJobs() - 1);
        if (this.getNumberOfActiveJobs() < 0) {
            this.setNumberOfActiveJobs(0);
        }
    }

    protected synchronized void clearActiveJobsNumber() {
        this.setNumberOfActiveJobs(0);
    }

    public String toString() {
        return "Server (" + this.getIndex() + ", " + this.getHostName() + ")\n\tNumber of Active Tasks: " + this.getNumberOfActiveJobs() + "\n\tTime to be task free: " + this.getTimeToBeTaskFree() + "\n\tAvailabilty: " + this.getAvailability() + "\n\tProcessing Rates: " + this.getProcessingRates().toString() + "\n";
    }
}

