/*
 * Decompiled with CFR 0.152.
 */
package lindenmayer.parser;

import java.util.HashMap;
import java.util.Map;
import lindenmayer.parser.Method;
import lindenmayer.parser.Provider;
import lindenmayer.parser.Variable;

public class MathProvider
implements Provider {
    static Method[] methods;
    static Variable[] variables;
    static Map variableMap;
    static Map methodMap;

    public Map getVariableMap() {
        return variableMap;
    }

    public Map getMethodMap() {
        return methodMap;
    }

    public Variable[] getVariables() {
        return variables;
    }

    public Method[] getMethods() {
        return methods;
    }

    static {
        int i;
        methods = new Method[]{new Method(){

            public String getId() {
                return "pow";
            }

            public int getParameterCount() {
                return 2;
            }

            public double execute(double[] parameters) {
                return Math.pow(parameters[0], parameters[1]);
            }
        }, new Method(){

            public String getId() {
                return "exp";
            }

            public int getParameterCount() {
                return 1;
            }

            public double execute(double[] parameters) {
                return Math.exp(parameters[0]);
            }
        }, new Method(){

            public String getId() {
                return "sqr";
            }

            public int getParameterCount() {
                return 1;
            }

            public double execute(double[] parameters) {
                return parameters[0] * parameters[0];
            }
        }, new Method(){

            public String getId() {
                return "sqrt";
            }

            public int getParameterCount() {
                return 1;
            }

            public double execute(double[] parameters) {
                return Math.sqrt(parameters[0]);
            }
        }, new Method(){

            public String getId() {
                return "root";
            }

            public int getParameterCount() {
                return 2;
            }

            public double execute(double[] parameters) {
                return Math.pow(parameters[1], 1.0 / parameters[1]);
            }
        }, new Method(){

            public String getId() {
                return "sin";
            }

            public int getParameterCount() {
                return 1;
            }

            public double execute(double[] parameters) {
                return Math.sin(parameters[0] * 180.0 / Math.PI);
            }
        }, new Method(){

            public String getId() {
                return "cos";
            }

            public int getParameterCount() {
                return 1;
            }

            public double execute(double[] parameters) {
                return Math.cos(parameters[0] * 180.0 / Math.PI);
            }
        }, new Method(){

            public String getId() {
                return "tan";
            }

            public int getParameterCount() {
                return 1;
            }

            public double execute(double[] parameters) {
                return Math.tan(parameters[0] * 180.0 / Math.PI);
            }
        }, new Method(){

            public String getId() {
                return "max";
            }

            public int getParameterCount() {
                return 2;
            }

            public double execute(double[] parameters) {
                return Math.max(parameters[0], parameters[1]);
            }
        }, new Method(){

            public String getId() {
                return "min";
            }

            public int getParameterCount() {
                return 2;
            }

            public double execute(double[] parameters) {
                return Math.min(parameters[0], parameters[1]);
            }
        }, new Method(){

            public String getId() {
                return "abs";
            }

            public int getParameterCount() {
                return 1;
            }

            public double execute(double[] parameters) {
                return Math.abs(parameters[0]);
            }
        }};
        variables = new Variable[]{new Variable("pi", Math.PI), new Variable("e", Math.E)};
        variableMap = new HashMap();
        methodMap = new HashMap();
        for (i = 0; i < methods.length; ++i) {
            methodMap.put(methods[i].getId(), methods[i]);
        }
        for (i = 0; i < variables.length; ++i) {
            variableMap.put(variables[i].getId(), variables[i]);
        }
    }
}

