/*
 * Decompiled with CFR 0.152.
 */
package lindenmayer.parser;

import java.util.Map;
import lindenmayer.parser.ExpressionArithmetic;
import lindenmayer.parser.Method;
import lindenmayer.parser.Statement;
import lindenmayer.parser.UndefinedVariableException;
import lindenmayer.parser.UnknownMethodException;
import lindenmayer.parser.WrongSignatureException;

public class MethodCall
extends Statement {
    String id;
    Method method;
    ExpressionArithmetic[] parameters;

    public MethodCall(String id, ExpressionArithmetic[] parameters) {
        this.id = id;
        this.parameters = parameters;
    }

    public void assignVariables(Map variableIdMap) throws UndefinedVariableException {
        if (this.parameters != null) {
            for (int i = 0; i < this.parameters.length; ++i) {
                this.parameters[i].assignVariables(variableIdMap);
            }
        }
    }

    public void assignMethods(Map methodIdMap) throws UnknownMethodException, WrongSignatureException {
        this.method = (Method)methodIdMap.get(this.id);
        if (this.method == null) {
            throw new UnknownMethodException(String.valueOf(String.valueOf(new StringBuffer("Unknwon method ").append(this.id).append("."))));
        }
        int parameterCount = this.parameters == null ? 0 : this.parameters.length;
        int methodParameterCount = this.method.getParameterCount();
        if (methodParameterCount != parameterCount && methodParameterCount != -1) {
            throw new WrongSignatureException(String.valueOf(String.valueOf(new StringBuffer("Method ").append(this.id).append(" requires ").append(methodParameterCount).append(" parameter(s), found: ").append(parameterCount))));
        }
    }

    public double execute() {
        if (this.method == null) {
            throw new IllegalStateException();
        }
        int parameterCount = this.parameters == null ? 0 : this.parameters.length;
        double[] parameterValues = new double[parameterCount];
        for (int i = 0; i < parameterCount; ++i) {
            parameterValues[i] = this.parameters[i].evaluateDouble();
        }
        return this.method.execute(parameterValues);
    }
}

