/*
 * Decompiled with CFR 0.152.
 */
package lindenmayer.parser;

import java.util.HashMap;
import java.util.Map;
import lindenmayer.parser.ExpressionArithmetic;
import lindenmayer.parser.SymbolDefinition;
import lindenmayer.parser.System;
import lindenmayer.parser.UndefinedVariableException;
import lindenmayer.parser.UnknownMethodException;
import lindenmayer.parser.WrongSignatureException;

public class SymbolConstant
implements Cloneable {
    SymbolDefinition symbol;
    double[] parameters;

    protected SymbolConstant() {
    }

    public SymbolConstant(System system, SymbolDefinition symbol, ExpressionArithmetic[] parameters) throws UnknownMethodException, UndefinedVariableException, WrongSignatureException {
        if (parameters == null && symbol.parameterCount > 0 || parameters != null && parameters.length != symbol.parameterCount) {
            throw new WrongSignatureException(String.valueOf(String.valueOf(new StringBuffer("Symbol ").append(symbol.id).append(" requires ").append(symbol.parameterCount).append(" parameters, found: ").append(parameters == null ? 0 : parameters.length))));
        }
        this.symbol = symbol;
        if (parameters != null) {
            HashMap variableMap = new HashMap(system.getMathProvider().getVariableMap());
            variableMap.putAll(system.getConstantDefinition().getVariableMap());
            Map methodMap = system.getMathProvider().getMethodMap();
            this.parameters = new double[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                parameters[i].assignVariables(variableMap);
                parameters[i].assignMethods(methodMap);
                this.parameters[i] = parameters[i].evaluateDouble();
            }
        }
    }

    public SymbolConstant(SymbolDefinition symbol, double[] parameters) throws WrongSignatureException {
        if (parameters == null && symbol.parameterCount > 0 || parameters != null && parameters.length != symbol.parameterCount) {
            throw new WrongSignatureException(String.valueOf(String.valueOf(new StringBuffer("Symbol ").append(symbol.id).append(" requires ").append(symbol.parameterCount).append(" parameters, found: ").append(parameters == null ? 0 : parameters.length))));
        }
        this.symbol = symbol;
        this.parameters = parameters;
    }

    public Object clone() {
        SymbolConstant clone = new SymbolConstant();
        clone.symbol = this.symbol;
        clone.parameters = (double[])this.parameters.clone();
        return clone;
    }

    public String toString() {
        String result = this.symbol.id;
        if (this.parameters != null && this.parameters.length > 0) {
            result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf("(".concat(String.valueOf(String.valueOf(this.parameters[0]))))));
            for (int i = 1; i < this.parameters.length; ++i) {
                result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf(", ".concat(String.valueOf(String.valueOf(this.parameters[i]))))));
            }
            result = String.valueOf(String.valueOf(result)).concat(")");
        }
        return result;
    }
}

