/*
 * Decompiled with CFR 0.152.
 */
package lindenmayer.system;

import lindenmayer.system.Symbol;

public class SymbolInstance
implements Cloneable {
    Symbol symbol;
    double[] parameters;

    public SymbolInstance(Symbol symbol) {
        this.symbol = symbol;
        this.parameters = new double[symbol.getParameterCount()];
    }

    public boolean isInstanceOf(Symbol symbol) {
        return symbol == this.symbol;
    }

    public boolean equals(Object object) {
        return object instanceof SymbolInstance && ((SymbolInstance)object).symbol == this.symbol;
    }

    public String getName() {
        return this.symbol.getName();
    }

    public int getParameterCount() {
        return this.symbol.getParameterCount();
    }

    public double get(int index) {
        return this.parameters[index];
    }

    public void set(int index, double value) {
        this.parameters[index] = value;
    }

    public Object clone() {
        SymbolInstance clone = new SymbolInstance(this.symbol);
        System.arraycopy(this.parameters, 0, clone.parameters, 0, this.parameters.length);
        return clone;
    }
}

