/*
 * Decompiled with CFR 0.152.
 */
package lindenmayer.turtle3d;

import com.sun.j3d.utils.behaviors.vp.OrbitBehavior;
import com.sun.j3d.utils.behaviors.vp.ViewPlatformBehavior;
import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.util.Stack;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JFrame;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import lindenmayer.parser.Method;
import lindenmayer.parser.Provider;
import lindenmayer.parser.Variable;
import lindenmayer.turtle3d.Appearances;
import lindenmayer.turtle3d.State;

public class Turtle3D
implements Provider {
    JFrame frame;
    Canvas3D canvas3d;
    BranchGroup scene;
    TransformGroup rootTransformGroup;
    BranchGroup rootGroup;
    SimpleUniverse simpleUniverse;
    Appearance appearance;
    Stack stack;
    State state;
    Method move = new Method(){

        public String getId() {
            return "move";
        }

        public int getParameterCount() {
            return -1;
        }

        public double execute(double[] parameters) {
            if (parameters == null || parameters.length == 0) {
                Turtle3D.this.move(Turtle3D.this.state.length);
            } else {
                Turtle3D.this.move(parameters[0]);
            }
            return 0.0;
        }
    };
    Method draw = new Method(){

        public String getId() {
            return "draw";
        }

        public int getParameterCount() {
            return -1;
        }

        public double execute(double[] parameters) {
            if (parameters == null || parameters.length == 0) {
                Turtle3D.this.cylinder(Turtle3D.this.state.length);
            } else {
                Turtle3D.this.cylinder(parameters[0]);
            }
            return 0.0;
        }
    };
    Method drawSphere = new Method(){

        public String getId() {
            return "drawSphere";
        }

        public int getParameterCount() {
            return -1;
        }

        public double execute(double[] parameters) {
            if (parameters == null || parameters.length == 0) {
                Turtle3D.this.sphere(Turtle3D.this.state.length);
            } else {
                Turtle3D.this.sphere(parameters[0]);
            }
            return 0.0;
        }
    };
    Method setLineWidth = new Method(){

        public String getId() {
            return "setLineWidth";
        }

        public int getParameterCount() {
            return 1;
        }

        public double execute(double[] parameters) {
            Turtle3D.this.state.lineWidth = parameters[0];
            return 0.0;
        }
    };
    Method incLineWidth = new Method(){

        public String getId() {
            return "incLineWidth";
        }

        public int getParameterCount() {
            return 1;
        }

        public double execute(double[] parameters) {
            Turtle3D.this.state.lineWidth += parameters[0];
            return 0.0;
        }
    };
    Method mulLineWidth = new Method(){

        public String getId() {
            return "mulLineWidth";
        }

        public int getParameterCount() {
            return 1;
        }

        public double execute(double[] parameters) {
            Turtle3D.this.state.lineWidth *= parameters[0];
            return 0.0;
        }
    };
    Method getLineWidth = new Method(){

        public String getId() {
            return "getLineWidth";
        }

        public int getParameterCount() {
            return 0;
        }

        public double execute(double[] parameters) {
            return Turtle3D.this.state.lineWidth;
        }
    };
    Method setLength = new Method(){

        public String getId() {
            return "setLength";
        }

        public int getParameterCount() {
            return 1;
        }

        public double execute(double[] parameters) {
            Turtle3D.this.state.length = parameters[0];
            return 0.0;
        }
    };
    Method incLength = new Method(){

        public String getId() {
            return "incLength";
        }

        public int getParameterCount() {
            return 1;
        }

        public double execute(double[] parameters) {
            Turtle3D.this.state.length += parameters[0];
            return 0.0;
        }
    };
    Method mulLength = new Method(){

        public String getId() {
            return "mulLength";
        }

        public int getParameterCount() {
            return 1;
        }

        public double execute(double[] parameters) {
            Turtle3D.this.state.length *= parameters[0];
            return 0.0;
        }
    };
    Method getLength = new Method(){

        public String getId() {
            return "getLength";
        }

        public int getParameterCount() {
            return 0;
        }

        public double execute(double[] parameters) {
            return Turtle3D.this.state.length;
        }
    };
    Method setMaterial = new Method(){

        public String getId() {
            return "setMaterial";
        }

        public int getParameterCount() {
            return 1;
        }

        public double execute(double[] parameters) {
            int index = (int)parameters[0];
            if (index < 0 || index >= Appearances.APPEARANCES.length) {
                throw new IllegalArgumentException("Illegal material index: ".concat(String.valueOf(String.valueOf(index))));
            }
            Turtle3D.this.state.appearance = Appearances.APPEARANCES[index];
            return 0.0;
        }
    };
    int rotateCount = 0;
    Method rotateX = new Method(){

        public String getId() {
            return "rotateX";
        }

        public int getParameterCount() {
            return 1;
        }

        public double execute(double[] parameters) {
            Turtle3D.this.rotateX(parameters[0] * Math.PI / (double)180);
            return 0.0;
        }
    };
    Method rotateY = new Method(){

        public String getId() {
            return "rotateY";
        }

        public int getParameterCount() {
            return 1;
        }

        public double execute(double[] parameters) {
            Turtle3D.this.rotateY(parameters[0] * Math.PI / (double)180);
            return 0.0;
        }
    };
    Method rotateZ = new Method(){

        public String getId() {
            return "rotateZ";
        }

        public int getParameterCount() {
            return 1;
        }

        public double execute(double[] parameters) {
            Turtle3D.this.rotateZ(parameters[0] * Math.PI / (double)180);
            return 0.0;
        }
    };
    Method rotate = new Method(){

        public String getId() {
            return "rotate";
        }

        public int getParameterCount() {
            return 1;
        }

        public double execute(double[] parameters) {
            Turtle3D.this.rotateZ(parameters[0] * Math.PI / (double)180);
            return 0.0;
        }
    };
    int pushCount = 0;
    int popCount = 0;
    int stackDepth = 0;
    Method push = new Method(){

        public String getId() {
            return "push";
        }

        public int getParameterCount() {
            return 0;
        }

        public double execute(double[] parameters) {
            Turtle3D.this.push();
            return 0.0;
        }
    };
    Method pop = new Method(){

        public String getId() {
            return "pop";
        }

        public int getParameterCount() {
            return 0;
        }

        public double execute(double[] parameters) {
            Turtle3D.this.pop();
            return 0.0;
        }
    };
    Method[] methods = new Method[]{this.move, this.draw, this.drawSphere, this.setLineWidth, this.getLineWidth, this.incLineWidth, this.mulLineWidth, this.setLength, this.getLength, this.incLength, this.mulLength, this.setMaterial, this.rotateX, this.rotateY, this.rotateZ, this.rotate, this.push, this.pop};
    Variable[] variables;

    public void init() {
        this.initProvider();
        this.scene = new BranchGroup();
        AmbientLight ambientLight = new AmbientLight();
        ambientLight.setInfluencingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000.0));
        this.scene.addChild((Node)ambientLight);
        DirectionalLight directionalLight = new DirectionalLight();
        directionalLight.setInfluencingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000.0));
        this.scene.addChild((Node)directionalLight);
        this.stack = new Stack();
        this.state = new State();
        this.state.group = this.scene;
        this.state.transform = new Transform3D();
        this.state.appearance = Appearances.BROWN_DULL;
        this.state.lineWidth = 0.002;
    }

    public void compile() {
        this.scene.compile();
    }

    public void show() {
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        this.canvas3d = new Canvas3D(config);
        this.frame = new JFrame();
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)this.canvas3d, "Center");
        ((Component)this.frame).setSize(400, 400);
        ((Component)this.frame).setVisible(true);
        this.frame.setDefaultCloseOperation(2);
        this.simpleUniverse = new SimpleUniverse(this.canvas3d);
        this.simpleUniverse.getViewingPlatform().setNominalViewingTransform();
        OrbitBehavior orbit = new OrbitBehavior(this.canvas3d, 112);
        orbit.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000.0));
        this.simpleUniverse.getViewingPlatform().setViewPlatformBehavior((ViewPlatformBehavior)orbit);
        this.simpleUniverse.addBranchGraph(this.scene);
    }

    public void rotateX(double r) {
        Transform3D rot = new Transform3D();
        rot.rotX(r);
        this.state.transform.mul(rot);
    }

    public void rotateY(double r) {
        Transform3D rot = new Transform3D();
        rot.rotY(r);
        this.state.transform.mul(rot);
    }

    public void rotateZ(double r) {
        Transform3D rot = new Transform3D();
        rot.rotZ(r);
        this.state.transform.mul(rot);
    }

    public void move(double length) {
        Transform3D t = new Transform3D();
        t.setZero();
        t.setTranslation(new Vector3d(0.0, length, 0.0));
        this.state.transform.add(t);
    }

    public void cylinder(double length) {
        TransformGroup transformGroup = new TransformGroup(this.state.transform);
        Transform3D objectTransform = new Transform3D();
        objectTransform.setTranslation(new Vector3d(0.0, length / 2.0, 0.0));
        TransformGroup objectTransformGroup = new TransformGroup(objectTransform);
        Cylinder cylinder = new Cylinder((float)this.state.lineWidth, (float)length, 3, this.state.appearance);
        objectTransformGroup.addChild((Node)cylinder);
        transformGroup.addChild((Node)objectTransformGroup);
        this.state.group.addChild((Node)transformGroup);
        this.state.group = transformGroup;
        this.state.transform = new Transform3D();
        this.state.transform.setTranslation(new Vector3d(0.0, length, 0.0));
    }

    public void sphere(double length) {
        this.state.transform.setTranslation(new Vector3d(0.0, length, 0.0));
        TransformGroup transformGroup = new TransformGroup(this.state.transform);
        Transform3D objectTransform = new Transform3D();
        objectTransform.setTranslation(new Vector3d(0.0, length / (double)2, 0.0));
        TransformGroup objectTransformGroup = new TransformGroup(objectTransform);
        Sphere sphere = new Sphere((float)length / (float)2, 3, this.state.appearance);
        objectTransformGroup.addChild((Node)sphere);
        transformGroup.addChild((Node)objectTransformGroup);
        this.state.group.addChild((Node)transformGroup);
        this.state.group = transformGroup;
        this.state.transform = new Transform3D();
    }

    public void push() {
        this.stack.push(this.state);
        this.state = (State)this.state.clone();
    }

    public void pop() {
        this.state = (State)this.stack.pop();
    }

    void initProvider() {
        int variableCount = Appearances.APPEARANCES_ID.length;
        this.variables = new Variable[variableCount];
        for (int i = 0; i < Appearances.APPEARANCES_ID.length; ++i) {
            this.variables[i] = new Variable(Appearances.APPEARANCES_ID[i]);
            this.variables[i].setValue(i);
        }
    }

    public Method[] getMethods() {
        return this.methods;
    }

    public Variable[] getVariables() {
        return this.variables;
    }
}

