/*
 * Decompiled with CFR 0.152.
 */
package lindenmayer.parser;

import java.util.HashMap;
import java.util.Map;
import lindenmayer.parser.ExpressionArithmetic;
import lindenmayer.parser.Method;
import lindenmayer.parser.Provider;
import lindenmayer.parser.System;
import lindenmayer.parser.UndefinedVariableException;
import lindenmayer.parser.UnknownMethodException;
import lindenmayer.parser.Variable;
import lindenmayer.parser.WrongSignatureException;

public class ConstantDefinition
implements Provider {
    static Method[] methods = new Method[0];
    Map variableMap;
    Variable[] variables;

    public ConstantDefinition(System system, Variable[] variables, ExpressionArithmetic[] expressions) throws UnknownMethodException, WrongSignatureException, UndefinedVariableException {
        if (variables.length != expressions.length) {
            throw new IllegalArgumentException();
        }
        this.variables = variables;
        Map methodMap = system.getMathProvider().getMethodMap();
        this.variableMap = new HashMap(system.getMathProvider().getVariableMap());
        for (int i = 0; i < variables.length; ++i) {
            expressions[i].assignMethods(methodMap);
            expressions[i].assignVariables(this.variableMap);
            variables[i].setValue(expressions[i].evaluateDouble());
            this.variableMap.put(variables[i].getId(), variables[i]);
        }
    }

    public Map getVariableMap() {
        return this.variableMap;
    }

    public Variable[] getVariables() {
        return this.variables;
    }

    public Method[] getMethods() {
        return methods;
    }
}

