/*
 * Decompiled with CFR 0.152.
 */
package lindenmayer.parser;

import java.util.HashMap;
import java.util.Map;
import lindenmayer.parser.DuplicateSymbolException;
import lindenmayer.parser.SymbolDefinition;
import lindenmayer.parser.UndefinedSymbolException;

public class SymbolsDefinition {
    String id;
    SymbolDefinition[] symbols;
    Map idMap;

    public SymbolsDefinition(String id, SymbolDefinition[] symbols) throws DuplicateSymbolException {
        this.id = id;
        this.symbols = symbols;
        this.idMap = new HashMap();
        for (int i = 0; i < symbols.length; ++i) {
            if (this.idMap.containsKey(symbols[i].id)) {
                throw new DuplicateSymbolException(String.valueOf(String.valueOf(new StringBuffer("Duplicate definition of symbol ").append(symbols[i].id).append("."))));
            }
            this.idMap.put(symbols[i].id, symbols[i]);
        }
    }

    public SymbolDefinition getById(String id) throws UndefinedSymbolException {
        SymbolDefinition result = (SymbolDefinition)this.idMap.get(id);
        if (result == null) {
            throw new UndefinedSymbolException(String.valueOf(String.valueOf(new StringBuffer("Symbol ").append(id).append(" is not defined."))));
        }
        return result;
    }

    public String toString() {
        String result = "symbols";
        if (this.id != null) {
            result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf(" ".concat(String.valueOf(String.valueOf(this.id))))));
        }
        result = String.valueOf(String.valueOf(result)).concat(" = (");
        if (this.symbols.length > 0) {
            result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf(this.symbols[0].toString())));
            for (int i = 1; i < this.symbols.length; ++i) {
                result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf(", ".concat(String.valueOf(String.valueOf(this.symbols[i].toString()))))));
            }
        }
        result = String.valueOf(String.valueOf(result)).concat(")");
        return result;
    }
}

