/*
 * Decompiled with CFR 0.152.
 */
package lindenmayer.parser;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import lindenmayer.parser.Rule;
import lindenmayer.parser.WordConstant;

public class Table {
    String id;
    ArrayList rules = new ArrayList();

    public Table(String id) {
        this.id = id;
    }

    public void appendRule(Rule rule) {
        this.rules.add(rule);
    }

    public List getApplyableRules(WordConstant word, int position) {
        LinkedList applyableRules = new LinkedList();
        for (int i = 0; i < this.rules.size(); ++i) {
            if (!((Rule)this.rules.get(i)).isApplyable(word, position)) continue;
            applyableRules.add(this.rules.get(i));
        }
        return applyableRules;
    }

    public Rule getApplyableRuleRandomly(WordConstant word, int position, Random random) {
        List applyableRules = this.getApplyableRules(word, position);
        if (applyableRules.size() > 0) {
            return (Rule)applyableRules.get(random.nextInt(applyableRules.size()));
        }
        return null;
    }

    public String toString() {
        String result = "\ttable".concat(String.valueOf(String.valueOf(this.id != null ? String.valueOf(String.valueOf(new StringBuffer(" ").append(this.id).append(" =\n"))) : " =\n")));
        result = String.valueOf(String.valueOf(result)).concat("\t(\n");
        Iterator i = ((AbstractList)this.rules).iterator();
        while (i.hasNext()) {
            result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("\t\t").append(i.next().toString()).append("\n"))))));
        }
        result = String.valueOf(String.valueOf(result)).concat("\t)");
        return result;
    }
}

