%%%  src/INet/Description/Utils.lhs
%%%
%%%  Copyright ©  2015 Wolfram Kahl
%%%
%%%  This file is part of HINet.
%%%
%%%  HINet is free software: you can redistribute it and/or modify
%%%  it under the terms of the GNU General Public License as published by
%%%  the Free Software Foundation, in version 3 of the License.
%%%
%%%  HINet is distributed in the hope that it will be useful,
%%%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%%%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%%%  GNU General Public License version 3 for more details.
%%%
%%%  You should have received a copy of the GNU General Public License
%%%  along with HINet.  If not, see <http://www.gnu.org/licenses/>.
\section{|INet.Description.Utils|}\sectlabel{INet.Description.Utils}

\begin{ModuleHead}
\begin{code}
module INet.Description.Utils where

import INet.Description

import qualified INet.Utils.Vector as V
\end{code}
\end{ModuleHead}

\begin{code}
isSourcePTD :: PortTargetDescription -> Bool
isSourcePTD (SourcePort _) = True
isSourcePTD _ = False

isTargetPTD :: PortTargetDescription -> Bool
isTargetPTD (TargetPort _) = True
isTargetPTD _ = False
\end{code}

\begin{code}
instance Functor NodeDescription where
  fmap f (NodeDescription nl ptds) = NodeDescription (f nl) ptds

instance Functor NetDescription where
  fmap f (NetDescription src trg ns) = NetDescription src trg $ fmap (fmap f) ns
\end{code}

For extracting arity information:
\begin{code}
collectArityFromNetDescription :: (nLab -> n) -> NetDescription nLab -> [(n, Int)] -> [(n, Int)]
collectArityFromNetDescription f nd r
   = V.foldr  (\ (NodeDescription nl ptds) -> ((f nl, V.length ptds) :))  r (nodes nd)
\end{code}

% Local Variables:
% folded-file: t
% eval: (fold-set-marks "%{{{ " "%}}}")
% eval: (fold-whole-buffer)
% fold-internal-margins: 0
% end:
