%%%  src/INet/Polar/Read.lhs
%%%
%%%  Copyright ©  2015 Wolfram Kahl
%%%
%%%  This file is part of HINet.
%%%
%%%  HINet is free software: you can redistribute it and/or modify
%%%  it under the terms of the GNU General Public License as published by
%%%  the Free Software Foundation, in version 3 of the License.
%%%
%%%  HINet is distributed in the hope that it will be useful,
%%%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%%%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%%%  GNU General Public License version 3 for more details.
%%%
%%%  You should have received a copy of the GNU General Public License
%%%  along with HINet.  If not, see <http://www.gnu.org/licenses/>.
\section{Reading the End State of Polar Nets}\sectlabel{INet.Polar.Read}

\begin{ModuleHead}
\begin{code}
module INet.Polar.Read where

import INet.Polar.INet
import INet.PTerm
import INet.Polarity
import qualified INet.Utils.Vector as V

import Control.Concurrent.MVar (takeMVar)
\end{code}
\end{ModuleHead}

\begin{code}
getPTerm :: (Show nLab) => Port nLab -> IO (PTerm nLab (Conn nLab))
getPTerm (Port pl c) = h Nothing (Port (opposite pl) c) where
  err mNLab s = fail $ "getPTerm: " ++ s ++ case mNLab of
                  Nothing -> ""
                  Just nL -> " below " ++ show nL
  h mNLab (Port Pos c) = return $ ConnVar c
    -- |err mNLab $ "encountered positive polarity"|
  h mNLab (Port pl c) = do
    -- |putStrLn $ unwords ["getPTerm", show mNLab, show pl]|
    Node nL ps <- takeMVar c
    succs <- mapM (h $ Just nL) $ V.toList ps
    return $ PNode nL succs
\end{code}

