%%%  src/INet/Utils/TmpFile.lhs
%%%
%%%  Copyright ©  2015 Wolfram Kahl
%%%
%%%  This file is part of HINet.
%%%
%%%  HINet is free software: you can redistribute it and/or modify
%%%  it under the terms of the GNU General Public License as published by
%%%  the Free Software Foundation, in version 3 of the License.
%%%
%%%  HINet is distributed in the hope that it will be useful,
%%%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%%%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%%%  GNU General Public License version 3 for more details.
%%%
%%%  You should have received a copy of the GNU General Public License
%%%  along with HINet.  If not, see <http://www.gnu.org/licenses/>.
\section{Temp File Utilities}

\begin{code}
{-# LANGUAGE CPP #-}
module INet.Utils.TmpFile (writeTmp) where

#ifdef mingw32_HOST_OS
import Data.IORef
import System.IO.Unsafe
#else
import System.Posix.Temp
#endif
import System.IO
\end{code}


\begin{code}
writeTmp :: String -> String -> IO FilePath
\end{code}

\begin{code}
#ifdef mingw32_HOST_OS
{-# NOINLINE tmpx #-}
tmpx :: IORef Int
tmpx = unsafePerformIO $ newIORef 3241

writeTmp suffix s = do
  i <- atomicModifyIORef tmpx (\ k -> (succ k, k))
  let tmpFile = "TempFile" ++ shows i suffix
  writeFile tmpFile s
  return tmpFile
#else
writeTmp _suffix s = do
  (tmpFile, h) <- mkstemp "/tmp/Data.Rel.Utils.TmpFile.XXXXXX"
  hPutStr h s
  hClose h
  return tmpFile
#endif
\end{code}

%{{{ EMACS lv
% Local Variables:
% folded-file: t
% fold-internal-margins: 0
% eval: (fold-set-marks "%{{{ " "%}}}")
% eval: (fold-whole-buffer)
% end:
%}}}
