-- Copyright 2006 by Wolfram Kahl, all rights reserved

module Main where

import SImPLParser
import SImPLEval
import System

interpSImPL :: FilePath -> IO ()
interpSImPL file = do
    putStrLn $ "Loading " ++ file ++ " ..."
    prog <- readSImPL file
    putStrLn $ "Running " ++ file ++ " ..."
    putStrLn $ runProg prog
  `catch`
    \ err -> putStrLn $ "Error in file " ++ file ++ ": " ++ show err

main = do
  files <- getArgs
  mapM interpSImPL files
