-- Copyright 2006 by Wolfram Kahl, all rights reserved


-- This module contains token types that are used
-- BOTH for lexing and in the abstract syntax.

module SImPLTokens where

data BinOp       = MkBoolOp  BoolOp
                 | MkRelOp   RelOp
                 | MkArithOp ArithOp
data BoolOp      = And  | Or
data RelOp       = Less | LessOrEqual | Equal | NotEqual
                 | Greater | GreaterOrEqual
data ArithOp     = Plus | Minus | Times | Div
data UnaryOp     = Not

type Variable    = String

data Literal     = LitInt Integer
                 | LitBool Bool

data Type        = IntType
                 | BoolType

instance Show BinOp where
  show (MkBoolOp op) = show op
  show (MkRelOp op) = show op
  show (MkArithOp op) = show op

instance Show BoolOp where
  show And = "&&"
  show Or = "||"

instance Show RelOp where
  show Less = "<"
  show LessOrEqual = "<="
  show Equal = "=="
  show NotEqual = "/="
  show Greater = ">"
  show GreaterOrEqual = ">="

instance Show ArithOp where
  show Plus = "+"
  show Minus = "-"
  show Times = "*"
  show Div = "/"

instance Show UnaryOp where
  show Not = "!"

instance Show Literal where
  show (LitInt k) = show k
  show (LitBool b) = show b

instance Show Type where
  show IntType = "int"
  show BoolType = "bool"
