
// FILE DemoLorenz1.cc


#include "VNODE.h"
#include "Lorenz.h"  


int main()
{
  
  VnodeInit();
  
  PtrODENumeric ODE = new Lorenz; 
  PtrDataRepr DataRepr = new TAYLOR_EXPANSION<LorenzTaylGenODE,LorenzTaylGenVAR>;
  
  ODE->LoadProblemParam( 1 );
  
  /* Order of the method. The code is constant order, but different 
     constant orders can be specified. */
  int Order = 15; 
  
  /* Create a solver. SOLVER_1 implements a Taylor series method, and
     SOLVER_2 implements an Hermite-Obreschkoff method.  By default,
     the order is 17. A solver with the default order can be created
     by PtrODESolver Solver = new SOLVER_1( ODE, DataRepr ); 
     */
  PtrODESolver Solver = new SOLVER_1( ODE, DataRepr, Order );
  
  /* We want graph output. */
  Solver->GraphOutput(true);
  
  /* If graph output is specified, the solver stores information into
     temporary files in the current directory. If two integrations are
     running at the same time and both generate graph output, these
     files will be overwriten. */
  
  cout << "*** Integrating " << ODE->GetName() << endl;
  Solver -> Integrate();

  /* Output the solution at the end point. GetTightEncl() returns 
     the last computed enclosure. 
     */
  cout << endl << " Enclosure at T = " << ODE->GetTcur() << endl;
  PrintVec( ODE->GetTightEncl() );
  
  /* Display the stepsize. */
  Solver->DisplayStepSize();
  
  /* Display the components of the solution */
  for ( int i = 1; i <= ODE->GetSize(); i++ )
    ODE->DisplaySolution(i);
  
  /* Plot the second component vs. the first component. */
  ODE->DisplayPhase( 1,2 );
  
  /* To store this plot in an encapsulated postscript file, we write */
  ODE->DisplayPhase(1,2,"Lorenz12.eps");
  /* Lorenz12.eps is created in the current directory. */
  
  return 0;
}
