
// FILE DemoLorenz2.cc

#include "VNODE.h"    
#include "Lorenz.h" 

int main()
{
  VnodeInit(); 
  
  PtrODENumeric ODE = new Lorenz; 
  PtrDataRepr DataRepr = new TAYLOR_EXPANSION<LorenzTaylGenODE,LorenzTaylGenVAR>;
  
  ODE->LoadProblemParam( 2 );   
  
  PtrODESolver Solver = new SOLVER_1( ODE, DataRepr );
  
  Solver->GraphOutput(true); 
  
  cout << "*** Integrating " << ODE->GetName() << endl;
  cout << "*** From " << ODE->GetT0() << " to " << ODE->GetTend() << endl;

  Solver -> Integrate(); 
  
  // Save the initial condition in Y0.
  INTERVAL_VECTOR Y0( ODE->GetInitCond() );
  
  // Reverse the integration: integrate from the current point to 1.
  ODE->SetTend( 1 );
  Solver -> Integrate( true ); 

  return 0;
}



